/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.project;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.project.RemoteProjectSource;
import com.jetbrains.toolbox.gateway.project.UtilsKt;
import com.jetbrains.toolbox.gateway.project.model.CachedEnvironmentDto;
import com.jetbrains.toolbox.project.DetectedProject;
import com.jetbrains.toolbox.project.IconSet;
import com.jetbrains.toolbox.project.ProjectDetector;
import com.jetbrains.toolbox.project.RemoteEnvironmentProjectSource;
import com.jetbrains.toolbox.project.RemoteProject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nRemoteProjectDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteProjectDetector.kt\ncom/jetbrains/toolbox/gateway/project/RemoteProjectDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1374#2:36\n1460#2,2:37\n1634#2,3:39\n1462#2,3:42\n*S KotlinDebug\n*F\n+ 1 RemoteProjectDetector.kt\ncom/jetbrains/toolbox/gateway/project/RemoteProjectDetector\n*L\n15#1:36\n15#1:37,2\n16#1:39,3\n15#1:42,3\n*E\n"})
public final class RemoteProjectDetector
implements ProjectDetector {
    @NotNull
    private final StateFlow<Collection<DetectedProject>> state;

    public RemoteProjectDetector(@NotNull RemoteProjectSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.state = FlowExtensionsKt.mapState(source.getProjects(), RemoteProjectDetector::state$lambda$0);
    }

    @Override
    @NotNull
    public StateFlow<Collection<DetectedProject>> getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    private static final List state$lambda$0(Map projects) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
        Iterable $this$flatMap$iv = projects.entrySet();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void destination$iv;
            void $this$mapTo$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            DevEnvironmentId id = (DevEnvironmentId)entry.getKey();
            CachedEnvironmentDto dto = (CachedEnvironmentDto)entry.getValue();
            Iterable iterable2 = dto.getProjects();
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void project2;
                CachedEnvironmentDto.Project project3 = (CachedEnvironmentDto.Project)item$iv;
                void var18_18 = destination$iv;
                boolean bl2 = false;
                String string = UtilsKt.toProjectEnvironmentId(id);
                String string2 = project2.getId();
                String string3 = project2.getName();
                IconSet iconSet = new IconSet(project2.getLightIcon-CQRfofY(), project2.getDarkIcon-CQRfofY(), null);
                String string4 = project2.getLocation();
                List<String> list2 = project2.getPaths();
                Instant instant = project2.getLastModified();
                RemoteProject.Source source = RemoteProject.Source.Agent;
                boolean bl3 = project2.getDeleted();
                var18_18.add(new DetectedProject(new RemoteProject(string, string2, string3, iconSet, instant, bl3, string4, list2, source, null, null, 1536, null), SetsKt.setOf((Object)RemoteEnvironmentProjectSource.Detected.INSTANCE)));
            }
            Iterable list$iv$iv = (Iterable)destination$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

