/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginManagement;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;

public final class SeekableByteChannelDataSource
implements DataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeekableByteChannel channel;
    private final long offset;
    @Nullable
    private final Long size;
    private static final int MAX_READ_CHUNK_SIZE = 0x100000;

    public SeekableByteChannelDataSource(@NotNull SeekableByteChannel channel, long offset, @Nullable Long size) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.offset = offset;
        this.size = size;
        if (this.offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + this.size);
        }
        if (this.size != null && this.size < 0L) {
            throw new IndexOutOfBoundsException("size: " + this.size);
        }
    }

    public /* synthetic */ SeekableByteChannelDataSource(SeekableByteChannel seekableByteChannel, long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        this(seekableByteChannel, l, l2);
    }

    @Nullable
    public final Long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(long offset, int size, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        if (size == 0) {
            return;
        }
        if (size > dest.remaining()) {
            throw new BufferOverflowException();
        }
        long offsetInFile = this.offset + offset;
        int prevLimit = dest.limit();
        try {
            int chunkSize;
            dest.limit(dest.position() + size);
            for (int remaining = size; remaining > 0; remaining -= chunkSize) {
                this.channel.position(offsetInFile);
                chunkSize = this.channel.read(dest);
                offsetInFile += (long)chunkSize;
            }
        }
        finally {
            dest.limit(prevLimit);
        }
    }

    public void feed(@NotNull WritableByteChannel writableByteChannel, long offset, long size) {
        int chunkSize;
        long remaining;
        Intrinsics.checkNotNullParameter((Object)writableByteChannel, (String)"writableByteChannel");
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        if (size == 0L) {
            return;
        }
        long chunkOffsetInFile = this.offset + offset;
        ByteBuffer buf = ByteBuffer.allocateDirect(RangesKt.coerceAtMost((int)((int)remaining), (int)0x100000));
        for (remaining = size; remaining > 0L; remaining -= (long)chunkSize) {
            int read2;
            buf.limit(chunkSize);
            this.channel.position(chunkOffsetInFile);
            for (int chunkRemaining = chunkSize = (int)RangesKt.coerceAtMost((long)remaining, (long)buf.capacity()); chunkRemaining > 0; chunkRemaining -= read2) {
                read2 = this.channel.read(buf);
                if (read2 >= 0) continue;
                throw new IOException("Unexpected EOF encountered");
            }
            buf.flip();
            writableByteChannel.write(buf);
            buf.clear();
            chunkOffsetInFile += (long)chunkSize;
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        ByteBuffer result2 = ByteBuffer.allocate(size);
        Intrinsics.checkNotNull((Object)result2);
        this.copyTo(offset, size, result2);
        result2.flip();
        return result2;
    }

    @Override
    public long size() {
        Long l = this.size;
        return l != null ? l.longValue() : this.channel.size();
    }

    @Override
    @NotNull
    public DataSource slice(long offset, long size) {
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        return offset == 0L && size == sourceSize ? (DataSource)this : (DataSource)new SeekableByteChannelDataSource(this.channel, this.offset + offset, size);
    }

    public static final class Companion {
        private Companion() {
        }

        private final void checkChunkValid(long offset, long size, long sourceSize) {
            long endOffset = offset + size;
            if (offset < 0L) {
                throw new IndexOutOfBoundsException("offset: " + offset);
            }
            if (size < 0L) {
                throw new IndexOutOfBoundsException("size: " + size);
            }
            if (offset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + sourceSize + ")");
            }
            if (endOffset < offset) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
            }
            if (endOffset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + sourceSize + ")");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

