/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginImpl;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.api.remoteDev.connection.RemoteToolsHelper;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.RawInterfaces;
import com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl;
import com.jetbrains.toolbox.gateway.tools.ToolHintParser;
import com.jetbrains.toolbox.gateway.utils.DevEnvironmentManagerExtensions;
import com.jetbrains.toolbox.tools.IntellijToolBuildQuery;
import com.jetbrains.toolbox.tools.ToolSearchRule;
import com.jetbrains.toolbox.tools.ToolStateManager;
import com.jetbrains.toolbox.tools.UniversalIntellijToolBuildDescriptor;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRemoteToolsHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteToolsHelperImpl.kt\ncom/jetbrains/toolbox/gateway/pluginImpl/RemoteToolsHelperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,97:1\n1563#2:98\n1634#2,3:99\n1563#2:102\n1634#2,3:103\n116#3,10:106\n7#4,7:116\n*S KotlinDebug\n*F\n+ 1 RemoteToolsHelperImpl.kt\ncom/jetbrains/toolbox/gateway/pluginImpl/RemoteToolsHelperImpl\n*L\n40#1:98\n40#1:99,3\n55#1:102\n55#1:103,3\n77#1:106,10\n83#1:116,7\n*E\n"})
public final class RemoteToolsHelperImpl
implements RemoteToolsHelper {
    @NotNull
    private final String providerId;
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final ToolHintParser toolHintParser;
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final Mutex installMutex;

    private RemoteToolsHelperImpl(String providerId, DevEnvironmentManager devEnvironmentManager, ToolHintParser toolHintParser, CoroutineScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        Intrinsics.checkNotNullParameter((Object)toolHintParser, (String)"toolHintParser");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.providerId = providerId;
        this.devEnvironmentManager = devEnvironmentManager;
        this.toolHintParser = toolHintParser;
        this.pluginScope = pluginScope;
        this.installMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    private final Object getRawInterfaces(String environmentId, Continuation<? super RawInterfaces> $completion) {
        RawInterfaces rawInterfaces;
        StateFlow<RawInterfaces> stateFlow = DevEnvironmentManagerExtensions.INSTANCE.findEnvironment(this.devEnvironmentManager, new DevEnvironmentId(this.providerId, environmentId, null));
        if (stateFlow != null && (stateFlow = stateFlow.getRawInterfaces()) != null) {
            Object object = FlowExtensionsKt.firstNotNull((Flow)stateFlow, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            rawInterfaces = (RawInterfaces)object;
        } else {
            rawInterfaces = null;
        }
        return rawInterfaces;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getAvailableRemoteTools(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super List<String>> $completion) {
        if (!($completion instanceof getAvailableRemoteTools.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAvailableRemoteTools(null, null, (Continuation<? super List<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to get available remote tools for environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$getAvailableRemoteTools_u24lambda_u240 = this;
                    $i$a$-run-RemoteToolsHelperImpl$getAvailableRemoteTools$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't list available remote tools because the environment " + environmentId + " doesn't exist");
                    return CollectionsKt.emptyList();
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAvailableRemoteTools$lambda$1(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, rules));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)environmentId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)hint);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.label = 2;
                v2 = query.findAvailableTools(rules, (Continuation<? super List<UniversalIntellijToolBuildDescriptor>>)$continuation);
                if (v2 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set<ToolSearchRule>)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                $this$map$iv = (Iterable)v2;
                $i$f$map = false;
                var9_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_19 = (UniversalIntellijToolBuildDescriptor)item$iv$iv;
                    var16_21 = destination$iv$iv;
                    $i$a$-map-RemoteToolsHelperImpl$getAvailableRemoteTools$3 = false;
                    var16_21.add(it.getProductCode() + "-" + BuildNumber.toString-impl(it.getBuildNumber-Y_E1uuk()));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getInstalledRemoteTools(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super List<String>> $completion) {
        if (!($completion instanceof getInstalledRemoteTools.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getInstalledRemoteTools(null, null, (Continuation<? super List<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to get installed remote tools for environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$getInstalledRemoteTools_u24lambda_u240 = this;
                    $i$a$-run-RemoteToolsHelperImpl$getInstalledRemoteTools$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't list installed remote tools because the environment " + environmentId + " doesn't exist");
                    return CollectionsKt.emptyList();
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getInstalledRemoteTools$lambda$1(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, rules));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)environmentId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)hint);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(rules);
                $continuation.label = 2;
                v2 = query.findInstalledTools(rules, (Continuation<? super List<UniversalIntellijToolBuildDescriptor>>)$continuation);
                if (v2 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set<ToolSearchRule>)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                $this$map$iv = (Iterable)v2;
                $i$f$map = false;
                var9_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_19 = (UniversalIntellijToolBuildDescriptor)item$iv$iv;
                    var16_21 = destination$iv$iv;
                    $i$a$-map-RemoteToolsHelperImpl$getInstalledRemoteTools$3 = false;
                    var16_21.add(it.getProductCode() + "-" + BuildNumber.toString-impl(it.getBuildNumber-Y_E1uuk()));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object installRemoteTool(@NotNull String environmentId, @NotNull String hint, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof installRemoteTool.1)) ** GOTO lbl-1000
        var23_4 = $completion;
        if ((var23_4.label & -2147483648) != 0) {
            var23_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteToolsHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.installRemoteTool(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Received request to install remote tool in environment " + environmentId + ", hint: " + hint);
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.label = 1;
                v0 = this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$continuation);
                if (v0 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (RawInterfaces)v0;
                if (v1 == null) {
                    $this$installRemoteTool_u24lambda_u240 = this;
                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$rawInterfaces$1 = false;
                    Logger.INSTANCE.error("Couldn't install remote tool because the environment " + environmentId + " doesn't exist");
                    return Boxing.boxBoolean((boolean)false);
                }
                rawInterfaces = v1;
                query = rawInterfaces.getRemoteIdeaToolBuildQuery();
                rules = this.toolHintParser.parse(hint);
                Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, installRemoteTool$lambda$1(com.jetbrains.toolbox.gateway.pluginImpl.RemoteToolsHelperImpl java.util.Set ), ()Ljava/lang/String;)((RemoteToolsHelperImpl)this, (Set)rules));
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.L$2 = rawInterfaces;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)rules);
                $continuation.label = 2;
                v2 = query.findLatestAvailableTool(rules, (Continuation<? super UniversalIntellijToolBuildDescriptor>)$continuation);
                if (v2 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                rules = (Set)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                v3 = (UniversalIntellijToolBuildDescriptor)v2;
                if (v3 == null) {
                    $this$installRemoteTool_u24lambda_u242 = this;
                    $i$a$-run-RemoteToolsHelperImpl$installRemoteTool$tool$1 = false;
                    Logger.INSTANCE.error("Couldn't find latest build of available tool " + environmentId + ", hint: " + hint);
                    return Boxing.boxBoolean((boolean)false);
                }
                tool = v3;
                Logger.INSTANCE.info("Trying to install tool " + tool.getProductCode() + "-" + BuildNumber.toString-impl(tool.getBuildNumber-Y_E1uuk()) + " in environment: " + environmentId);
                toolStateManager = rawInterfaces.getToolStateManager(this.pluginScope);
                $this$withLock_u24default$iv = this.installMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)rules);
                $continuation.L$5 = tool;
                $continuation.L$6 = toolStateManager;
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 3;
                v4 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v4 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl93
            }
            case 3: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                toolStateManager = (ToolStateManager)$continuation.L$6;
                tool = (UniversalIntellijToolBuildDescriptor)$continuation.L$5;
                rules = (Set)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl93:
                // 3 sources

                $i$a$-withLock$default-RemoteToolsHelperImpl$installRemoteTool$3 = 0;
                $continuation.L$0 = environmentId;
                $continuation.L$1 = hint;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)rules);
                $continuation.L$5 = tool;
                $continuation.L$6 = toolStateManager;
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-RemoteToolsHelperImpl$installRemoteTool$3;
                $continuation.label = 4;
                v5 = toolStateManager.getInstalledTool-tQRIPQs(tool.getType-UtVBrGo(), tool.getVersionName(), tool.getBuildNumber-Y_E1uuk(), (Continuation<? super StateFlow<Pair<ChannelId, ToolDescription>>>)$continuation);
                v6 = v5;
                if (v5 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl129
            }
            case 4: {
                $i$a$-withLock$default-RemoteToolsHelperImpl$installRemoteTool$3 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                toolStateManager = (ToolStateManager)$continuation.L$6;
                tool = (UniversalIntellijToolBuildDescriptor)$continuation.L$5;
                rules = (Set)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl129:
                    // 2 sources

                    v7 = (Pair)((StateFlow)v6).getValue();
                    if (v7 != null) {
                        v8 = (ChannelId)v7.getFirst();
                        v9 = v8 != null ? v8.unbox-impl() : null;
                    } else {
                        v9 = installedTool = null;
                    }
                    if (installedTool == null) ** GOTO lbl-1000
                    Logger.INSTANCE.info("Tool " + tool.getProductCode() + "-" + BuildNumber.toString-impl(tool.getBuildNumber-Y_E1uuk()) + " is already installed in environment " + environmentId);
                    var21_29 = Boxing.boxBoolean((boolean)true);
                }
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var21_29;
            }
lbl-1000:
            // 1 sources

            {
                $i$f$catching = 0;
                try {
                    $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3$1 = 0;
                    $continuation.L$0 = environmentId;
                    $continuation.L$1 = hint;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)rules);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)tool);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)toolStateManager);
                    $continuation.L$7 = $this$withLock_u24default$iv;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)installedTool);
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.I$1 = $i$a$-withLock$default-RemoteToolsHelperImpl$installRemoteTool$3;
                    $continuation.I$2 = $i$f$catching;
                    $continuation.I$3 = $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3$1;
                    $continuation.label = 5;
                    v10 = toolStateManager.install-yWuBznU(tool.getType-UtVBrGo(), tool.getVersionName(), tool.getBuildNumber-Y_E1uuk(), true, (Continuation<? super Unit>)$continuation);
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    var16_34 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                    ** GOTO lbl192
                }
            }
            v11 = v10;
            if (v10 == var24_6) {
                return var24_6;
            }
            ** GOTO lbl191
            case 5: {
                $i$a$-catching-RemoteToolsHelperImpl$installRemoteTool$3$1 = $continuation.I$3;
                $i$f$catching = $continuation.I$2;
                $i$a$-withLock$default-RemoteToolsHelperImpl$installRemoteTool$3 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                installedTool = (String)$continuation.L$8;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                toolStateManager = (ToolStateManager)$continuation.L$6;
                tool = (UniversalIntellijToolBuildDescriptor)$continuation.L$5;
                rules = (Set)$continuation.L$4;
                query = (IntellijToolBuildQuery)$continuation.L$3;
                rawInterfaces = (RawInterfaces)$continuation.L$2;
                hint = (String)$continuation.L$1;
                environmentId = (String)$continuation.L$0;
                ** try [egrp 4[TRYBLOCK] [7 : 1240->1325)] { 
lbl-1000:
                // 1 sources

                {
                    ResultKt.throwOnFailure((Object)$result);
                    v11 = $result;
lbl191:
                    // 2 sources

                    var16_34 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
lbl192:
                // 2 sources

                var13_31 = var16_34;
                v12 = Result.exceptionOrNull-impl((Object)var13_31);
                if (v12 == null) {
                    return Boxing.boxBoolean((boolean)true);
                }
                it = v12;
                $i$a$-getOrElse-RemoteToolsHelperImpl$installRemoteTool$3$2 = false;
                Logger.INSTANCE.error(it, "Failed to install remote tool in environment " + environmentId + ", hint: " + hint);
                return Boxing.boxBoolean((boolean)false);
lbl200:
                // 1 sources

                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String dumpRules(Set<? extends ToolSearchRule> rules) {
        return CollectionsKt.joinToString$default((Iterable)rules, (CharSequence)"\n", null, null, (int)0, null, RemoteToolsHelperImpl::dumpRules$lambda$0, (int)30, null);
    }

    private static final String getAvailableRemoteTools$lambda$1(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested available tools query:\n" + this$0.dumpRules($rules);
    }

    private static final String getInstalledRemoteTools$lambda$1(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested installed tools query:\n" + this$0.dumpRules($rules);
    }

    private static final String installRemoteTool$lambda$1(RemoteToolsHelperImpl this$0, Set $rules) {
        return "Requested tool installation by query:\n" + this$0.dumpRules($rules);
    }

    private static final CharSequence dumpRules$lambda$0(ToolSearchRule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return " -" + it.toPrettyString();
    }

    public /* synthetic */ RemoteToolsHelperImpl(String providerId, DevEnvironmentManager devEnvironmentManager, ToolHintParser toolHintParser, CoroutineScope pluginScope, DefaultConstructorMarker $constructor_marker) {
        this(providerId, devEnvironmentManager, toolHintParser, pluginScope);
    }

    public static final /* synthetic */ Object access$getRawInterfaces(RemoteToolsHelperImpl $this, String environmentId, Continuation $completion) {
        return $this.getRawInterfaces(environmentId, (Continuation<? super RawInterfaces>)$completion);
    }
}

