/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.error;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.remoteDev.ssh.validation.SshValidationFailure;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.openssh.SshException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ConnectionError
extends EnvironmentError {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ConnectionError() {
    }

    public /* synthetic */ ConnectionError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class AuthenticationError
    extends ConnectionError {
        @NotNull
        public static final AuthenticationError INSTANCE = new AuthenticationError();
        @NotNull
        private static final String message = "Failed to authenticate to remote host";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("Failed to authenticate to remote host");
        @NotNull
        private static final List<DescriptionTree> description = CollectionsKt.listOf((Object)new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("All authentication methods failed")));

        private AuthenticationError() {
            super((DefaultConstructorMarker)null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return description;
        }

        @Override
        @NotNull
        public String toString() {
            return "AuthenticationError";
        }

        public int hashCode() {
            return -966150596;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationError)) {
                return false;
            }
            AuthenticationError cfr_ignored_0 = (AuthenticationError)other;
            return true;
        }
    }

    @SourceDebugExtension(value={"SMAP\nConnectionError.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionError.kt\ncom/jetbrains/toolbox/gateway/error/ConnectionError$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1563#2:279\n1634#2,3:280\n*S KotlinDebug\n*F\n+ 1 ConnectionError.kt\ncom/jetbrains/toolbox/gateway/error/ConnectionError$Companion\n*L\n229#1:279\n229#1:280,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ConnectionError fromSshValidationFailure(@NotNull List<? extends SshValidationFailure> failures) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(failures, (String)"failures");
            Iterable $this$map$iv = failures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ConnectionError connectionError;
                void it;
                SshValidationFailure sshValidationFailure = (SshValidationFailure)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_11 = it;
                if (var12_11 instanceof SshValidationFailure.UnknownSshValidationFailure) {
                    connectionError = new UnknownError("Unknown ssh validation failure", LocalizableStringExKt.trl("Unknown SSH validation failure"));
                } else if (var12_11 instanceof SshValidationFailure.UnresolvedHostname) {
                    connectionError = new UnresolvedHostname(((SshValidationFailure.UnresolvedHostname)it).getHostname(), ((SshValidationFailure.UnresolvedHostname)it).getReason());
                } else if (var12_11 == SshValidationFailure.SimpleValidationFailures.HOST_UNREACHABLE) {
                    connectionError = HostUnreachable.INSTANCE;
                } else if (var12_11 == SshValidationFailure.SimpleValidationFailures.CONNECTION_TIMEOUT) {
                    connectionError = ConnectionTimeout.INSTANCE;
                } else if (var12_11 == SshValidationFailure.SimpleValidationFailures.CONNECTION_REFUSED) {
                    connectionError = ConnectionRefused.INSTANCE;
                } else if (var12_11 == SshValidationFailure.SimpleValidationFailures.WRONG_CREDENTIALS) {
                    connectionError = AuthenticationError.INSTANCE;
                } else if (var12_11 == SshValidationFailure.SimpleValidationFailures.FORWARDING_PROHIBITED) {
                    connectionError = ForwardingProhibited.INSTANCE;
                } else if (var12_11 instanceof SshValidationFailure.TooWidePermissions) {
                    connectionError = new TooWidePermissions(((SshValidationFailure.TooWidePermissions)it).getKey());
                } else if (var12_11 instanceof SshValidationFailure.InaccessibleFile) {
                    connectionError = new InaccessibleFile(((SshValidationFailure.InaccessibleFile)it).getFileType(), ((SshValidationFailure.InaccessibleFile)it).getPath(), ((SshValidationFailure.InaccessibleFile)it).getReason());
                } else if (var12_11 instanceof SshValidationFailure.HostKeyVerificationFailed) {
                    connectionError = new HostKeyVerificationFailed(((SshValidationFailure.HostKeyVerificationFailed)it).getHost());
                } else if (var12_11 instanceof SshValidationFailure.NonZeroExitCode) {
                    connectionError = new NonZeroExitCode(((SshValidationFailure.NonZeroExitCode)it).getExitCode());
                } else if (var12_11 instanceof SshValidationFailure.SshAgentConflict) {
                    connectionError = new SshAgentConflict(((SshValidationFailure.SshAgentConflict)it).getIdentityAgentPath(), ((SshValidationFailure.SshAgentConflict)it).getSshAuthSock());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(connectionError);
            }
            List mapped = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            return mapped.size() == 1 ? (ConnectionError)CollectionsKt.first((List)mapped) : (ConnectionError)new CompositeError(mapped);
        }

        @NotNull
        public final SshExecutableError fromSshException(@NotNull SshException sshException) {
            Intrinsics.checkNotNullParameter((Object)sshException, (String)"sshException");
            if (!(sshException instanceof com.jetbrains.toolbox.openssh.SshExecutableError)) {
                throw new NoWhenBranchMatchedException();
            }
            return new SshExecutableError(((com.jetbrains.toolbox.openssh.SshExecutableError)sshException).getPath());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class CompositeError
    extends ConnectionError {
        @NotNull
        private final List<ConnectionError> errors;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public CompositeError(@NotNull List<? extends ConnectionError> errors) {
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            super((DefaultConstructorMarker)null);
            this.errors = errors;
            this.message = "Encountered " + this.errors.size() + " errors during SSH connection";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf(this.errors.size()))};
            this.localized = LocalizableStringExKt.trn("Encountered {{count}} error during SSH connection", "Encountered {{count}} errors during SSH connection", this.errors.size(), pairArray);
        }

        @NotNull
        public final List<ConnectionError> getErrors() {
            return this.errors;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @NotNull
        public final List<ConnectionError> component1() {
            return this.errors;
        }

        @NotNull
        public final CompositeError copy(@NotNull List<? extends ConnectionError> errors) {
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            return new CompositeError(errors);
        }

        public static /* synthetic */ CompositeError copy$default(CompositeError compositeError, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = compositeError.errors;
            }
            return compositeError.copy(list2);
        }

        @Override
        @NotNull
        public String toString() {
            return "CompositeError(errors=" + this.errors + ")";
        }

        public int hashCode() {
            return ((Object)this.errors).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompositeError)) {
                return false;
            }
            CompositeError compositeError = (CompositeError)other;
            return Intrinsics.areEqual(this.errors, compositeError.errors);
        }
    }

    public static final class ConnectionRefused
    extends ConnectionError {
        @NotNull
        public static final ConnectionRefused INSTANCE = new ConnectionRefused();
        @NotNull
        private static final String message = "Connection refused";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("Connection refused");

        private ConnectionRefused() {
            super((DefaultConstructorMarker)null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public String toString() {
            return "ConnectionRefused";
        }

        public int hashCode() {
            return -1940859682;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionRefused)) {
                return false;
            }
            ConnectionRefused cfr_ignored_0 = (ConnectionRefused)other;
            return true;
        }
    }

    public static final class ConnectionTimeout
    extends ConnectionError {
        @NotNull
        public static final ConnectionTimeout INSTANCE = new ConnectionTimeout();
        @NotNull
        private static final String message = "Connection timeout";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("Connection timeout");

        private ConnectionTimeout() {
            super((DefaultConstructorMarker)null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public String toString() {
            return "ConnectionTimeout";
        }

        public int hashCode() {
            return -45351057;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionTimeout)) {
                return false;
            }
            ConnectionTimeout cfr_ignored_0 = (ConnectionTimeout)other;
            return true;
        }
    }

    public static final class ForwardingProhibited
    extends ConnectionError {
        @NotNull
        public static final ForwardingProhibited INSTANCE = new ForwardingProhibited();
        @NotNull
        private static final String message = "The TCP port forwarding is administratively prohibited on SSH server";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("The TCP port forwarding is administratively prohibited on SSH server");
        @NotNull
        private static final List<DescriptionTree> description;

        private ForwardingProhibited() {
            super((DefaultConstructorMarker)null);
        }

        private final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return description;
        }

        @Override
        @NotNull
        public String toString() {
            return "ForwardingProhibited";
        }

        public int hashCode() {
            return 1548200783;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForwardingProhibited)) {
                return false;
            }
            ForwardingProhibited cfr_ignored_0 = (ForwardingProhibited)other;
            return true;
        }

        static {
            Object[] objectArray = new DescriptionTree[]{new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Contact your remote machine administrator or change the configuration of SSH server")), new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("To enable the TCP port forwarding in OpenSSH server, add the following line to the sshd_config:")), new DescriptionTree.Code("AllowTcpForwarding yes"), new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Remember to restart the OpenSSH server after applying changes to the configuration."))};
            description = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    public static final class HostKeyVerificationFailed
    extends ConnectionError {
        @NotNull
        private final String host;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public HostKeyVerificationFailed(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super((DefaultConstructorMarker)null);
            this.host = host;
            this.message = "Host key verification failed";
            this.localized = LocalizableStringExKt.trl("Host key verification failed");
            Object[] objectArray = new DescriptionTree[4];
            Object[] objectArray2 = new Pair[]{TuplesKt.to((Object)"host", (Object)this.host)};
            objectArray[0] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The verification of the host key has failed for host: {{host}}", objectArray2));
            objectArray[1] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The problem may indicate that:"));
            objectArray2 = new LocalizableStringEx[]{LocalizableStringExKt.trl("Someone could be eavesdropping on you right now (man-in-the-middle attack)"), LocalizableStringExKt.trl("The identity of the host present at the provided address has changed.")};
            objectArray[2] = new DescriptionTree.Bulletpoints(CollectionsKt.listOf((Object[])objectArray2));
            objectArray[3] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("If you are sure that the connection is safe, delete the conflicting entry in file: ~/.ssh/known_hosts"));
            this.description = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final HostKeyVerificationFailed copy(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new HostKeyVerificationFailed(host);
        }

        public static /* synthetic */ HostKeyVerificationFailed copy$default(HostKeyVerificationFailed hostKeyVerificationFailed, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = hostKeyVerificationFailed.host;
            }
            return hostKeyVerificationFailed.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "HostKeyVerificationFailed(host=" + this.host + ")";
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HostKeyVerificationFailed)) {
                return false;
            }
            HostKeyVerificationFailed hostKeyVerificationFailed = (HostKeyVerificationFailed)other;
            return Intrinsics.areEqual((Object)this.host, (Object)hostKeyVerificationFailed.host);
        }
    }

    public static final class HostUnreachable
    extends ConnectionError {
        @NotNull
        public static final HostUnreachable INSTANCE = new HostUnreachable();
        @NotNull
        private static final String message = "Failed to initialize access to the remote host";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("Failed to initialize access to the remote host");

        private HostUnreachable() {
            super((DefaultConstructorMarker)null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public String toString() {
            return "HostUnreachable";
        }

        public int hashCode() {
            return -860056104;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HostUnreachable)) {
                return false;
            }
            HostUnreachable cfr_ignored_0 = (HostUnreachable)other;
            return true;
        }
    }

    public static final class InaccessibleFile
    extends ConnectionError {
        @NotNull
        private final String type;
        @NotNull
        private final String path;
        @NotNull
        private final String reason;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public InaccessibleFile(@NotNull String type2, @NotNull String path2, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.type = type2;
            this.path = path2;
            this.reason = reason;
            this.message = "Inaccessible " + this.type + " file at " + this.path;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)this.type), TuplesKt.to((Object)"path", (Object)this.path)};
            this.localized = LocalizableStringExKt.trl("Inaccessible {{type}} file at {{path}}", pairArray);
            this.description = CollectionsKt.listOf((Object)new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.notr(this.reason)));
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final String component3() {
            return this.reason;
        }

        @NotNull
        public final InaccessibleFile copy(@NotNull String type2, @NotNull String path2, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new InaccessibleFile(type2, path2, reason);
        }

        public static /* synthetic */ InaccessibleFile copy$default(InaccessibleFile inaccessibleFile, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = inaccessibleFile.type;
            }
            if ((n & 2) != 0) {
                string2 = inaccessibleFile.path;
            }
            if ((n & 4) != 0) {
                string3 = inaccessibleFile.reason;
            }
            return inaccessibleFile.copy(string, string2, string3);
        }

        @Override
        @NotNull
        public String toString() {
            return "InaccessibleFile(type=" + this.type + ", path=" + this.path + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InaccessibleFile)) {
                return false;
            }
            InaccessibleFile inaccessibleFile = (InaccessibleFile)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)inaccessibleFile.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)inaccessibleFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)inaccessibleFile.reason);
        }
    }

    public static final class NonZeroExitCode
    extends ConnectionError {
        @Nullable
        private final Integer exitCode;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public NonZeroExitCode(@Nullable Integer exitCode) {
            super((DefaultConstructorMarker)null);
            this.exitCode = exitCode;
            this.message = "Command returned non-zero exit code: " + this.exitCode;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"exitCode", (Object)String.valueOf(this.exitCode))};
            this.localized = LocalizableStringExKt.trl("Command returned non-zero exit code: {{exitCode}}", pairArray);
        }

        @Nullable
        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Nullable
        public final Integer component1() {
            return this.exitCode;
        }

        @NotNull
        public final NonZeroExitCode copy(@Nullable Integer exitCode) {
            return new NonZeroExitCode(exitCode);
        }

        public static /* synthetic */ NonZeroExitCode copy$default(NonZeroExitCode nonZeroExitCode, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = nonZeroExitCode.exitCode;
            }
            return nonZeroExitCode.copy(n);
        }

        @Override
        @NotNull
        public String toString() {
            return "NonZeroExitCode(exitCode=" + this.exitCode + ")";
        }

        public int hashCode() {
            return this.exitCode == null ? 0 : ((Object)this.exitCode).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NonZeroExitCode)) {
                return false;
            }
            NonZeroExitCode nonZeroExitCode = (NonZeroExitCode)other;
            return Intrinsics.areEqual((Object)this.exitCode, (Object)nonZeroExitCode.exitCode);
        }
    }

    public static final class SshAgentConflict
    extends ConnectionError {
        @Nullable
        private final String identityAgentPath;
        @Nullable
        private final String sshAuthSock;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public SshAgentConflict(@Nullable String identityAgentPath, @Nullable String sshAuthSock) {
            super((DefaultConstructorMarker)null);
            this.identityAgentPath = identityAgentPath;
            this.sshAuthSock = sshAuthSock;
            this.message = "Detected a conflict in ssh-agent configuration";
            this.localized = LocalizableStringExKt.trl("Detected a conflict in ssh-agent configuration");
            Object[] objectArray = new DescriptionTree[7];
            objectArray[0] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The IdentityAgent property in ssh_config points to:"));
            String string = this.identityAgentPath;
            if (string == null) {
                string = "(not set)";
            }
            objectArray[1] = new DescriptionTree.Code(string);
            objectArray[2] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The SSH_AUTH_SOCK environment variable points to:"));
            String string2 = this.sshAuthSock;
            if (string2 == null) {
                string2 = "(not set)";
            }
            objectArray[3] = new DescriptionTree.Code(string2);
            objectArray[4] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("This conflict may lead to problems with authentication."));
            Object[] objectArray2 = new LocalizableStringEx[]{LocalizableStringExKt.trl("The problem is often associated with configuring 1Password or another 3rd party ssh-agent."), LocalizableStringExKt.trl("Update both IdentityAgent property in your ssh_config and SSH_AUTH_SOCK environment variable."), LocalizableStringExKt.trl("Make sure that environment variable is inherited by Toolbox App")};
            objectArray[5] = new DescriptionTree.Bulletpoints(CollectionsKt.listOf((Object[])objectArray2));
            objectArray[6] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("SSH_AUTH_SOCK in the scope of this connection has been overridden to match IdentityAgent path"));
            this.description = CollectionsKt.listOf((Object[])objectArray);
        }

        @Nullable
        public final String getIdentityAgentPath() {
            return this.identityAgentPath;
        }

        @Nullable
        public final String getSshAuthSock() {
            return this.sshAuthSock;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @Nullable
        public final String component1() {
            return this.identityAgentPath;
        }

        @Nullable
        public final String component2() {
            return this.sshAuthSock;
        }

        @NotNull
        public final SshAgentConflict copy(@Nullable String identityAgentPath, @Nullable String sshAuthSock) {
            return new SshAgentConflict(identityAgentPath, sshAuthSock);
        }

        public static /* synthetic */ SshAgentConflict copy$default(SshAgentConflict sshAgentConflict, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = sshAgentConflict.identityAgentPath;
            }
            if ((n & 2) != 0) {
                string2 = sshAgentConflict.sshAuthSock;
            }
            return sshAgentConflict.copy(string, string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "SshAgentConflict(identityAgentPath=" + this.identityAgentPath + ", sshAuthSock=" + this.sshAuthSock + ")";
        }

        public int hashCode() {
            int result2 = this.identityAgentPath == null ? 0 : this.identityAgentPath.hashCode();
            result2 = result2 * 31 + (this.sshAuthSock == null ? 0 : this.sshAuthSock.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SshAgentConflict)) {
                return false;
            }
            SshAgentConflict sshAgentConflict = (SshAgentConflict)other;
            if (!Intrinsics.areEqual((Object)this.identityAgentPath, (Object)sshAgentConflict.identityAgentPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sshAuthSock, (Object)sshAgentConflict.sshAuthSock);
        }
    }

    public static final class SshExecutableError
    extends ConnectionError {
        @NotNull
        private final String executablePath;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public SshExecutableError(@NotNull String executablePath) {
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            super((DefaultConstructorMarker)null);
            this.executablePath = executablePath;
            this.message = "The SSH executable path does not point to valid OpenSSH client";
            this.localized = LocalizableStringExKt.trl("The SSH executable path does not point to valid OpenSSH client");
            Object[] objectArray = new DescriptionTree[]{new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The SSH executable path:")), new DescriptionTree.Code(this.executablePath), new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl(" does not point to valid OpenSSH client.")), new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Please install an OpenSSH client. Then, restart Toolbox App and select proper OpenSSH client in the Advanced settings. If the client path is not present in selection field, you can provide the path manually."))};
            this.description = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final String getExecutablePath() {
            return this.executablePath;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.executablePath;
        }

        @NotNull
        public final SshExecutableError copy(@NotNull String executablePath) {
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            return new SshExecutableError(executablePath);
        }

        public static /* synthetic */ SshExecutableError copy$default(SshExecutableError sshExecutableError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = sshExecutableError.executablePath;
            }
            return sshExecutableError.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "SshExecutableError(executablePath=" + this.executablePath + ")";
        }

        public int hashCode() {
            return this.executablePath.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SshExecutableError)) {
                return false;
            }
            SshExecutableError sshExecutableError = (SshExecutableError)other;
            return Intrinsics.areEqual((Object)this.executablePath, (Object)sshExecutableError.executablePath);
        }
    }

    public static final class SshExecutableMissing
    extends ConnectionError {
        @NotNull
        public static final SshExecutableMissing INSTANCE = new SshExecutableMissing();
        @NotNull
        private static final String message = "Could not find OpenSSH client executable";
        @NotNull
        private static final LocalizableString localized = LocalizableStringExKt.trl("Could not find OpenSSH client executable");
        @NotNull
        private static final List<DescriptionTree> description = CollectionsKt.listOf((Object)new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Please install an OpenSSH client. Then, restart Toolbox App and select proper OpenSSH client in the Advanced settings. If the client path is not present in selection field, you can provide the path manually.")));

        private SshExecutableMissing() {
            super((DefaultConstructorMarker)null);
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return description;
        }

        @Override
        @NotNull
        public String toString() {
            return "SshExecutableMissing";
        }

        public int hashCode() {
            return -1446842808;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SshExecutableMissing)) {
                return false;
            }
            SshExecutableMissing cfr_ignored_0 = (SshExecutableMissing)other;
            return true;
        }
    }

    public static final class TooWidePermissions
    extends ConnectionError {
        @NotNull
        private final String keyPath;
        @NotNull
        private final String absolutePathString;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public TooWidePermissions(@NotNull String keyPath) {
            Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
            super((DefaultConstructorMarker)null);
            this.keyPath = keyPath;
            Path path2 = Path.of(this.keyPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            this.absolutePathString = ((Object)path2.toAbsolutePath()).toString();
            this.message = "The public key '" + this.absolutePathString + "' is ignored: Permissions are too open. To fix this problem, set proper permissions to the key.";
            Object object = new Pair[]{TuplesKt.to((Object)"absolutePathString", (Object)this.absolutePathString)};
            this.localized = LocalizableStringExKt.trl("The public key '{{absolutePathString}}' is ignored: Permissions are too open. To fix this problem, set proper permissions to the key.", object);
            Object object2 = object = CollectionsKt.createListBuilder();
            TooWidePermissions tooWidePermissions = this;
            boolean bl = false;
            if (OS.INSTANCE.isWindows()) {
                v1 = $this$description_u24lambda_u240.add(new DescriptionTree.Code(StringsKt.trimIndent((String)("\n          # Set Key File Variable:\n            New-Variable -Name Key -Value \"" + this.absolutePathString + "\"\n\n          # Remove Inheritance:\n            Icacls $Key /c /t /Inheritance:d\n\n          # Set Ownership to Owner:\n            # Key's within $env:UserProfile:\n              Icacls $Key /c /t /Grant ${env:UserName}:F\n\n            # Key's outside of $env:UserProfile:\n              TakeOwn /F $Key\n              Icacls $Key /c /t /Grant:r ${env:UserName}:F\n\n          # Remove All Users, except for Owner:\n            Icacls $Key /c /t /Remove:g Administrator \"Authenticated Users\" BUILTIN\\Administrators BUILTIN Everyone System Users\n\n          # Verify:\n            Icacls $Key\n\n          # Remove Variable:\n            Remove-Variable -Name Key\n          "))));
            } else {
                $this$description_u24lambda_u240.add(new DescriptionTree.Code(StringsKt.trimIndent((String)("\n            #!/bin/bash\n            chmod 600 \"" + this.absolutePathString + "\"\n            "))));
                v1 = $this$description_u24lambda_u240.add(new DescriptionTree.Action((LocalizableString)LocalizableStringExKt.trl("Quick fix"), () -> TooWidePermissions.description$lambda$0$0(this)));
            }
            tooWidePermissions.description = CollectionsKt.build((List)object);
        }

        @NotNull
        public final String getKeyPath() {
            return this.keyPath;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.keyPath;
        }

        @NotNull
        public final TooWidePermissions copy(@NotNull String keyPath) {
            Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
            return new TooWidePermissions(keyPath);
        }

        public static /* synthetic */ TooWidePermissions copy$default(TooWidePermissions tooWidePermissions, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = tooWidePermissions.keyPath;
            }
            return tooWidePermissions.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "TooWidePermissions(keyPath=" + this.keyPath + ")";
        }

        public int hashCode() {
            return this.keyPath.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TooWidePermissions)) {
                return false;
            }
            TooWidePermissions tooWidePermissions = (TooWidePermissions)other;
            return Intrinsics.areEqual((Object)this.keyPath, (Object)tooWidePermissions.keyPath);
        }

        private static final boolean description$lambda$0$0(TooWidePermissions this$0) {
            return (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this$0, null){
                int label;
                final /* synthetic */ TooWidePermissions this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ TooWidePermissions this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                                                int label;
                                                final /* synthetic */ TooWidePermissions this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            String[] stringArray = new String[]{"chmod", "600", TooWidePermissions.access$getAbsolutePathString$p(this.this$0)};
                                                            CompletableFuture<Process> completableFuture = new ProcessBuilder(new String[0]).command(stringArray).start().onExit();
                                                            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"onExit(...)");
                                                            this.label = 1;
                                                            Object object2 = FutureKt.await((CompletionStage)completableFuture, (Continuation)((Continuation)this));
                                                            if (object2 != object) return Boxing.boxBoolean((boolean)true);
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return Boxing.boxBoolean((boolean)true);
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            v1 = (Boolean)v0;
                            return Boxing.boxBoolean((boolean)(v1 != null ? v1 : false));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static final /* synthetic */ String access$getAbsolutePathString$p(TooWidePermissions $this) {
            return $this.absolutePathString;
        }
    }

    public static final class UnknownError
    extends ConnectionError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public UnknownError(@NotNull String message2, @NotNull LocalizableString localized) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)localized, (String)"localized");
            super((DefaultConstructorMarker)null);
            this.message = message2;
            this.localized = localized;
        }

        public /* synthetic */ UnknownError(String string, LocalizableString localizableString, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                localizableString = LocalizableStringExKt.trl("Unknown error");
            }
            this(string, localizableString);
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final LocalizableString component2() {
            return this.localized;
        }

        @NotNull
        public final UnknownError copy(@NotNull String message2, @NotNull LocalizableString localized) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)localized, (String)"localized");
            return new UnknownError(message2, localized);
        }

        public static /* synthetic */ UnknownError copy$default(UnknownError unknownError, String string, LocalizableString localizableString, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknownError.message;
            }
            if ((n & 2) != 0) {
                localizableString = unknownError.localized;
            }
            return unknownError.copy(string, localizableString);
        }

        @Override
        @NotNull
        public String toString() {
            return "UnknownError(message=" + this.message + ", localized=" + this.localized + ")";
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + this.localized.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnknownError)) {
                return false;
            }
            UnknownError unknownError = (UnknownError)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)unknownError.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.localized, (Object)unknownError.localized);
        }
    }

    public static final class UnresolvedHostname
    extends ConnectionError {
        @NotNull
        private final String hostname;
        @NotNull
        private final String reason;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @Nullable
        private final List<DescriptionTree> description;

        public UnresolvedHostname(@NotNull String hostname, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super((DefaultConstructorMarker)null);
            this.hostname = hostname;
            this.reason = reason;
            this.message = "Unresolved hostname";
            this.localized = LocalizableStringExKt.trl("Unresolved hostname");
            Object[] objectArray = new DescriptionTree[3];
            Object[] objectArray2 = new Pair[]{TuplesKt.to((Object)"hostname", (Object)this.hostname), TuplesKt.to((Object)"reason", (Object)this.reason)};
            objectArray[0] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The hostname {{hostname}} could not be resolved: {{reason}}", objectArray2));
            objectArray[1] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Check your connection to the remote host"));
            objectArray2 = new LocalizableStringEx[]{LocalizableStringExKt.trl("Check your Internet connection"), LocalizableStringExKt.trl("Connect to the required VPN"), LocalizableStringExKt.trl("Check your proxy configuration")};
            objectArray[2] = new DescriptionTree.Bulletpoints(CollectionsKt.listOf((Object[])objectArray2));
            this.description = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final String getHostname() {
            return this.hostname;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @Nullable
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.hostname;
        }

        @NotNull
        public final String component2() {
            return this.reason;
        }

        @NotNull
        public final UnresolvedHostname copy(@NotNull String hostname, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new UnresolvedHostname(hostname, reason);
        }

        public static /* synthetic */ UnresolvedHostname copy$default(UnresolvedHostname unresolvedHostname, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = unresolvedHostname.hostname;
            }
            if ((n & 2) != 0) {
                string2 = unresolvedHostname.reason;
            }
            return unresolvedHostname.copy(string, string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "UnresolvedHostname(hostname=" + this.hostname + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = this.hostname.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnresolvedHostname)) {
                return false;
            }
            UnresolvedHostname unresolvedHostname = (UnresolvedHostname)other;
            if (!Intrinsics.areEqual((Object)this.hostname, (Object)unresolvedHostname.hostname)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)unresolvedHostname.reason);
        }
    }
}

