/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import com.jetbrains.toolbox.TestUtil;
import com.jetbrains.toolbox.api.core.Arch;
import com.jetbrains.toolbox.api.core.OS;
import com.jetbrains.toolbox.api.remoteDev.deploy.AgentDistributionProvider;
import com.jetbrains.toolbox.api.remoteDev.deploy.DistributionInfo;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.gateway.deploy.JbrDistributionProvider;
import java.net.URI;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class LocalSnapshotToolboxAgentDistributionProvider
implements AgentDistributionProvider {
    @NotNull
    private final JbrDistributionProvider jbrDistributionProvider;
    @NotNull
    private final FileSystem fileSystem;

    public LocalSnapshotToolboxAgentDistributionProvider(@NotNull JbrDistributionProvider jbrDistributionProvider, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)jbrDistributionProvider, (String)"jbrDistributionProvider");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.jbrDistributionProvider = jbrDistributionProvider;
        this.fileSystem = fileSystem;
    }

    @Nullable
    public Object getAgentDistribution(@NotNull OS os, @NotNull Arch arch, boolean jreIncluded, @NotNull Continuation<? super DistributionInfo> $completion) {
        return this.resolveLocallyBuiltClient(os, arch, jreIncluded);
    }

    private final DistributionInfo resolveLocallyBuiltClient(OS os, Arch arch, boolean jreIncluded) {
        DistributionInfo distributionInfo;
        java.nio.file.Path source;
        java.nio.file.Path path2;
        java.nio.file.Path localAgentPath = TestUtil.INSTANCE.getLocalAgentPath();
        if (!jreIncluded) {
            path2 = localAgentPath;
            if (path2 == null) {
                path2 = TestUtil.INSTANCE.resolveFromCheckoutRootOrNull("cli/build/distributions/tbcli.tar.gz");
            }
        } else {
            path2 = os == OS.Linux && arch == Arch.X64 ? TestUtil.INSTANCE.resolveFromCheckoutRootOrNull("cli/build/distributions/tbcli-linux-x64-legacy.tar.gz") : null;
        }
        java.nio.file.Path path3 = source = path2;
        Path localSource = path3 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path3, (boolean)false, (int)1, null) : null;
        if (!(localSource != null && this.fileSystem.exists(localSource))) {
            boolean bl = false;
            String string = "Locally built Toolbox-Agent must be present on '" + localSource + "'\nIt's automatically built for tests by cli:distTar task, so this should not happen";
            throw new IllegalStateException(string.toString());
        }
        String sha256 = HexExtensionsKt.toHexString$default((byte[])ShaKt.sha256(this.fileSystem, localSource), null, (int)1, null);
        URI uRI = localSource.toNioPath().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        DistributionInfo it = distributionInfo = new DistributionInfo(uRI, sha256);
        boolean bl = false;
        Logger.INSTANCE.debug("Resolved agent distribution: " + it);
        return distributionInfo;
    }

    @Nullable
    public Object getJreDistribution(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super DistributionInfo> $completion) {
        return this.jbrDistributionProvider.getJbrDistribution(os, arch);
    }

    @Nullable
    public Object getMinimalJreMajor(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)this.jbrDistributionProvider.getMinimalMajor());
    }

    @Nullable
    public Object getAgentBuild(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super String> $completion) {
        return this.resolveLocallyBuiltClient(os, arch, false).getSha256();
    }
}

