/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarketplaceInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String moniker;
    @NotNull
    private final String url;
    @NotNull
    private final String searchUrl;
    @NotNull
    private final String downloadUrl;
    @NotNull
    private final String iconUrl;
    @NotNull
    private static final String searchEndpoint = "/api/search/graphql";
    @NotNull
    private static final String downloadEndpoint = "/plugin/download";
    @NotNull
    private static final MarketplaceInstance PROD = new MarketplaceInstance("PROD", "https://plugins.jetbrains.com");
    @NotNull
    private static final MarketplaceInstance DEMO = new MarketplaceInstance("DEMO", "https://master.demo.marketplace.intellij.net");
    @NotNull
    private static final MarketplaceInstance DEV = new MarketplaceInstance("DEV", "https://master.dev.marketplace.intellij.net");
    @NotNull
    private static final List<MarketplaceInstance> values;

    public MarketplaceInstance(@NotNull String moniker, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.moniker = moniker;
        this.url = url;
        char[] cArray = new char[]{'/'};
        this.searchUrl = StringsKt.trimEnd((String)this.url, (char[])cArray) + searchEndpoint;
        cArray = new char[]{'/'};
        this.downloadUrl = StringsKt.trimEnd((String)this.url, (char[])cArray) + downloadEndpoint;
        cArray = new char[]{'/'};
        this.iconUrl = StringsKt.trimEnd((String)this.url, (char[])cArray) + "/api/icon";
    }

    @NotNull
    public final String getMoniker() {
        return this.moniker;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getSearchUrl() {
        return this.searchUrl;
    }

    @NotNull
    public final String getDownloadUrl() {
        return this.downloadUrl;
    }

    @NotNull
    public final String getIconUrl() {
        return this.iconUrl;
    }

    @NotNull
    public final String component1() {
        return this.moniker;
    }

    @NotNull
    public final String component2() {
        return this.url;
    }

    @NotNull
    public final MarketplaceInstance copy(@NotNull String moniker, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new MarketplaceInstance(moniker, url);
    }

    public static /* synthetic */ MarketplaceInstance copy$default(MarketplaceInstance marketplaceInstance, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = marketplaceInstance.moniker;
        }
        if ((n & 2) != 0) {
            string2 = marketplaceInstance.url;
        }
        return marketplaceInstance.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "MarketplaceInstance(moniker=" + this.moniker + ", url=" + this.url + ")";
    }

    public int hashCode() {
        int result2 = this.moniker.hashCode();
        result2 = result2 * 31 + this.url.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarketplaceInstance)) {
            return false;
        }
        MarketplaceInstance marketplaceInstance = (MarketplaceInstance)other;
        if (!Intrinsics.areEqual((Object)this.moniker, (Object)marketplaceInstance.moniker)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)marketplaceInstance.url);
    }

    static {
        Object[] objectArray = new MarketplaceInstance[]{PROD, DEMO, DEV};
        values = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSearchEndpoint() {
            return searchEndpoint;
        }

        @NotNull
        public final String getDownloadEndpoint() {
            return downloadEndpoint;
        }

        @NotNull
        public final MarketplaceInstance getPROD() {
            return PROD;
        }

        @NotNull
        public final MarketplaceInstance getDEMO() {
            return DEMO;
        }

        @NotNull
        public final MarketplaceInstance getDEV() {
            return DEV;
        }

        @NotNull
        public final List<MarketplaceInstance> getValues() {
            return values;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

