/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fus;

import com.jetbrains.toolbox.ex.stdlib.security.RandomKt;
import java.security.MessageDigest;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class FusAnonymizer {
    @NotNull
    public static final FusAnonymizer INSTANCE = new FusAnonymizer();
    @NotNull
    private static final Lazy salt$delegate = LazyKt.lazy(FusAnonymizer::salt_delegate$lambda$0);
    @NotNull
    private static final ConcurrentHashMap<String, String> anonymizedCache = new ConcurrentHashMap();

    private FusAnonymizer() {
    }

    private final String hashSha256(byte[] salt, String data2) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(salt);
        String string = data2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        byte[] byArray2 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return HexExtensionsKt.toHexString$default((byte[])byArray2, null, (int)1, null);
    }

    private final byte[] getOrGenerateSaltFromPrefs() {
        String saltKey;
        String name2 = "jetbrains";
        Preferences prefs = Preferences.userRoot().node(name2);
        byte[] salt = prefs.getByteArray(saltKey = "feature_usage_event_log_salt_tba", null);
        if (salt == null) {
            salt = RandomKt.randomBytes$default(0, 1, null);
            prefs.putByteArray(saltKey, salt);
            Logger.INSTANCE.info("Generating new salt for FUS");
        }
        return salt;
    }

    @NotNull
    public final String anonymize(@NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (StringsKt.isBlank((CharSequence)data2)) {
            return data2;
        }
        String string = anonymizedCache.computeIfAbsent(data2, arg_0 -> FusAnonymizer.anonymize$lambda$1(FusAnonymizer::anonymize$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return string;
    }

    private final byte[] getSalt() {
        Lazy lazy = salt$delegate;
        return (byte[])lazy.getValue();
    }

    private static final String anonymize$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.hashSha256(INSTANCE.getSalt(), it);
    }

    private static final String anonymize$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final byte[] salt_delegate$lambda$0() {
        return INSTANCE.getOrGenerateSaltFromPrefs();
    }
}

