/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.frontend;

import com.jetbrains.toolbox.common.platform.OS;
import java.net.UnixDomainSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nFrontendConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendConstants.kt\ncom/jetbrains/toolbox/frontend/FrontendConstants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class FrontendConstants {
    @NotNull
    public static final FrontendConstants INSTANCE = new FrontendConstants();
    @NotNull
    private static final String socketName = "jb.tbx.frontend.sock";

    private FrontendConstants() {
    }

    @NotNull
    public final UnixDomainSocketAddress getSocketAddress() {
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(this.getSocketPath());
        Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
        return unixDomainSocketAddress;
    }

    @NotNull
    public final Path getSocketPath() {
        return WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()] == 1 ? this.getSocketPathLinux() : this.getSocketPathGeneric();
    }

    private final Path getSocketPathGeneric() {
        String tempDirectory = this.getBaseDirectory();
        String[] stringArray = new String[]{socketName};
        Path path2 = Path.of(tempDirectory, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return path2;
    }

    private final Path getSocketPathLinux() {
        String xdgDir = this.getLinuxXdgRuntimeDir();
        if (xdgDir != null) {
            String[] stringArray = new String[]{socketName};
            Path path2 = Path.of(xdgDir, stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            return path2;
        }
        String userName = this.getUserName();
        String[] stringArray = new String[]{"toolbox-frontend-" + userName + ".sock"};
        Path path3 = Path.of(this.getBaseDirectory(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    private final String getUserName() {
        String string;
        String it = System.getProperty("user.name");
        boolean bl = false;
        CharSequence charSequence = it;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)it, (Object)"?")) {
            string = System.getenv("USER");
            if (string == null) {
                string = "user";
            }
        } else {
            void var1_1;
            string = var1_1;
        }
        return string;
    }

    private final String getBaseDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }

    private final String getLinuxXdgRuntimeDir() {
        String xdgRuntimeDir = System.getenv("XDG_RUNTIME_DIR");
        CharSequence charSequence = xdgRuntimeDir;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Files.exists(Path.of(xdgRuntimeDir, new String[0]), new LinkOption[0])) {
            return xdgRuntimeDir;
        }
        return null;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

