/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fleet.core;

import com.jetbrains.toolbox.fleet.core.ShipDescriptor;
import com.jetbrains.toolbox.fleet.core.ShipParams;
import com.jetbrains.toolbox.fleet.core.ShipState;
import com.jetbrains.toolbox.fleet.core.ShipType;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecentShipInfo {
    @NotNull
    private final ShipType shipType;
    @NotNull
    private final ShipParams shipParams;
    @NotNull
    private final ShipState shipState;
    @Nullable
    private final ShipDescriptor shipBundleDescriptor;
    @NotNull
    private final Map<String, String> meta;

    public RecentShipInfo(@NotNull ShipType shipType, @NotNull ShipParams shipParams, @NotNull ShipState shipState, @Nullable ShipDescriptor shipBundleDescriptor, @NotNull Map<String, String> meta) {
        Intrinsics.checkNotNullParameter((Object)shipType, (String)"shipType");
        Intrinsics.checkNotNullParameter((Object)shipParams, (String)"shipParams");
        Intrinsics.checkNotNullParameter((Object)shipState, (String)"shipState");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        this.shipType = shipType;
        this.shipParams = shipParams;
        this.shipState = shipState;
        this.shipBundleDescriptor = shipBundleDescriptor;
        this.meta = meta;
    }

    @NotNull
    public final ShipType getShipType() {
        return this.shipType;
    }

    @NotNull
    public final ShipParams getShipParams() {
        return this.shipParams;
    }

    @NotNull
    public final ShipState getShipState() {
        return this.shipState;
    }

    @Nullable
    public final ShipDescriptor getShipBundleDescriptor() {
        return this.shipBundleDescriptor;
    }

    @NotNull
    public final Map<String, String> getMeta() {
        return this.meta;
    }

    @NotNull
    public String toString() {
        return "RecentShipInfo(shipType=" + this.shipType + ", shipParams=" + this.shipParams + ", shipState=" + this.shipState + ", shipBundleDescriptor=" + this.shipBundleDescriptor + ", meta=" + this.meta + ")";
    }

    public int hashCode() {
        int result2 = this.shipType.hashCode();
        result2 = result2 * 31 + this.shipParams.hashCode();
        result2 = result2 * 31 + this.shipState.hashCode();
        result2 = result2 * 31 + (this.shipBundleDescriptor == null ? 0 : this.shipBundleDescriptor.hashCode());
        result2 = result2 * 31 + ((Object)this.meta).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecentShipInfo)) {
            return false;
        }
        RecentShipInfo recentShipInfo = (RecentShipInfo)other;
        if (!Intrinsics.areEqual((Object)this.shipType, (Object)recentShipInfo.shipType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipParams, (Object)recentShipInfo.shipParams)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipState, (Object)recentShipInfo.shipState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipBundleDescriptor, (Object)recentShipInfo.shipBundleDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.meta, recentShipInfo.meta);
    }
}

