/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feedjet;

import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.feed.ApplicationFeedJSONLoader;
import com.jetbrains.toolbox.feed.ApplicationMajorVersionKt;
import com.jetbrains.toolbox.feed.DataPiecesKt;
import com.jetbrains.toolbox.feed.FeedV1Json;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feedjet.FeedjetManager;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import com.jetbrains.toolbox.platform.image.internal.ImageId;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Collection;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nFeedjetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedjetManager.kt\ncom/jetbrains/toolbox/feedjet/FeedjetManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class FeedjetManager
implements ProtocolHandler {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final Notifications notifications;
    @NotNull
    private final ApplicationFeedJSONLoader applicationFeedJSONLoader;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final I18n i18n;
    private final boolean impliesUiMode;

    public FeedjetManager(@NotNull DownloadManager downloadManager, @NotNull Notifications notifications, @NotNull ApplicationFeedJSONLoader applicationFeedJSONLoader, @NotNull ImageManager imageManager, @NotNull UIGlobalState uiGlobalState, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)applicationFeedJSONLoader, (String)"applicationFeedJSONLoader");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.downloadManager = downloadManager;
        this.notifications = notifications;
        this.applicationFeedJSONLoader = applicationFeedJSONLoader;
        this.imageManager = imageManager;
        this.uiGlobalState = uiGlobalState;
        this.i18n = i18n;
        this.impliesUiMode = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"toolbox")) {
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string, (String)"/feedjet", (boolean)false, (int)2, null)) {
                bl = true;
                return Boxing.boxBoolean((boolean)bl);
            }
        }
        bl = false;
        return Boxing.boxBoolean((boolean)bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        block29: {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var20_3 = $completion;
            if ((var20_3.label & -2147483648) != 0) {
                var20_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ FeedjetManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = URIExtensionsKt.parseQuery(uri).get("url");
                    if (v0 == null) {
                        return Unit.INSTANCE;
                    }
                    url = v0;
                    Logger.INSTANCE.info("Processing feedjet from url " + url);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                    $continuation.L$1 = url;
                    $continuation.label = 1;
                    v1 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                    if (v1 == var21_5) {
                        return var21_5;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    url = (String)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    session = (DownloadSession)v1;
                    request = new Request.Builder().get().url(url).build();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                    $continuation.L$1 = url;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)session);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.label = 2;
                    v2 = DownloadSessionUtilKt.await(session.getHttpClient().newCall(request), (Continuation<? super Response>)$continuation);
                    if (v2 == var21_5) {
                        return var21_5;
                    }
                    ** GOTO lbl47
                }
                case 2: {
                    request = (Request)$continuation.L$3;
                    session = (DownloadSession)$continuation.L$2;
                    url = (String)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 2 sources

                    if ((response = (Response)v2).isSuccessful()) break;
                    Logger.INSTANCE.warn("Unable to download feed from " + url + ": " + response.message());
                    if (!Intrinsics.areEqual((Object)response.message(), (Object)"Failed to authenticate with proxy")) {
                        var7_21 = new Pair[]{TuplesKt.to((Object)"errorMessage", (Object)response.message())};
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)url);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)session);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                        $continuation.L$4 = response;
                        $continuation.label = 3;
                        v3 = this.notifications.showErrorMessage(this.i18n.tr("Cannot download package description: {{errorMessage}}", var7_21), (Continuation<? super Unit>)$continuation);
                        if (v3 == var21_5) {
                            return var21_5;
                        }
                    }
                    ** GOTO lbl69
                }
                case 3: {
                    response = (Response)$continuation.L$4;
                    request = (Request)$continuation.L$3;
                    session = (DownloadSession)$continuation.L$2;
                    url = (String)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl69:
                    // 2 sources

                    response.close();
                    return Unit.INSTANCE;
                }
            }
            Logger.INSTANCE.debug("Downloaded feed " + url);
            try {
                v4 /* !! */  = response.body();
                if (v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .byteStream()) != null) {
                    var10_24 = v4 /* !! */ ;
                    var11_25 = null;
                    try {
                        it = (InputStream)var10_24;
                        $i$a$-use-FeedjetManager$handle$result$1 = false;
                        var12_26 = ApplicationFeedJSONLoader.parse$default(this.applicationFeedJSONLoader, url, it, null, 4, null);
                        v5 = var12_26;
                    }
                    catch (Throwable var13_28) {
                        var11_25 = var13_28;
                        throw var13_28;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var10_24, (Throwable)var11_25);
                    }
                } else {
                    v5 = null;
                }
                var8_31 = v5;
            }
            catch (Throwable t) {
                Logger.INSTANCE.warn(t, "Unable to parse feed from " + url);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)t);
                $continuation.label = 4;
                v6 = this.notifications.showErrorMessage(this.i18n.tr("Cannot read package description"), (Continuation<? super Unit>)$continuation);
                if (v6 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl116
            }
            {
                case 4: {
                    t = (Throwable)$continuation.L$5;
                    response = (Response)$continuation.L$4;
                    request = (Request)$continuation.L$3;
                    session = (DownloadSession)$continuation.L$2;
                    url = (String)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl116:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            result = var8_31;
            if (result == null) {
                Logger.INSTANCE.warn("Response body is null for " + url);
                return Unit.INSTANCE;
            }
            count = ((Collection)result.getFeedItems()).size();
            Logger.INSTANCE.info("Found " + count + " feed items in feedjet " + url);
            Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handle$lambda$1(com.jetbrains.toolbox.feed.FeedV1Json ), ()Ljava/lang/String;)((FeedV1Json)result));
            if (count == 1) break block29;
            Logger.INSTANCE.warn("Expected exactly ONE feed item in feedjet");
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)url);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)session);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)response);
            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)result);
            $continuation.I$0 = count;
            $continuation.label = 5;
            v7 = this.notifications.showErrorMessage(this.i18n.tr("Wrong feedjet file format, expected exactly one item"), (Continuation<? super Unit>)$continuation);
            if (v7 == var21_5) {
                return var21_5;
            }
            ** GOTO lbl148
            {
                case 5: {
                    count = $continuation.I$0;
                    result = (FeedV1Json)$continuation.L$5;
                    response = (Response)$continuation.L$4;
                    request = (Request)$continuation.L$3;
                    session = (DownloadSession)$continuation.L$2;
                    url = (String)$continuation.L$1;
                    uri = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl148:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        feedItem = (RemoteFeedItem)CollectionsKt.first(result.getFeedItems());
        Logger.INSTANCE.info("Asking user permission to install" + feedItem.getPresentableFullNameAndVersionAndBuild());
        v8 = ToolBuild.Companion;
        v9 = feedItem;
        v10 = feedItem.getIcon-fijqFwY();
        if (v10 != null) {
            var12_26 = v10;
            var13_30 = this.imageManager;
            var14_37 = var12_26;
            var17_38 = v9;
            var16_39 = v8;
            $i$a$-let-FeedjetManager$handle$toolBuild$1 = false;
            v11 = var13_30.convert-AuLSNLU((String)p0);
            var18_41 = v11 != null ? ImageId.box-impl((String)v11) : null;
            v8 = var16_39;
            v9 = var17_38;
            v12 = var18_41;
            v13 = v12 != null ? v12.unbox-impl() : null;
        } else {
            v13 = null;
        }
        toolBuild = v8.of-QT3uPOY(v9, v13, DataPiecesKt.getDefaultApplicationQuality(), ApplicationMajorVersionKt.getMaxApplicationMajorVersion());
        this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handle$lambda$2(com.jetbrains.toolbox.tools.model.ToolBuild com.jetbrains.toolbox.UIModalState ), (Lcom/jetbrains/toolbox/UIModalState;)Lcom/jetbrains/toolbox/UIModalState;)((ToolBuild)toolBuild));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean getImpliesUiMode() {
        return this.impliesUiMode;
    }

    private static final String handle$lambda$1(FeedV1Json $result) {
        return CollectionsKt.joinToString$default((Iterable)$result.getFeedItems(), (CharSequence)"\n", (CharSequence)"Feed items in feedjet: [", (CharSequence)"]", (int)0, null, FeedjetManager::handle$lambda$1$0, (int)24, null);
    }

    private static final CharSequence handle$lambda$1$0(RemoteFeedItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPresentableFullNameAndVersionAndBuild();
    }

    private static final UIModalState handle$lambda$2(ToolBuild $toolBuild, UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.Normal ? (UIModalState)new UIModalState.FeedjetItem($toolBuild) : it;
    }
}

