/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

sealed interface TokenPart {

    public static final class StringLiteral
    implements TokenPart {
        @NotNull
        private final String value;

        public StringLiteral(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.value = value2;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return "StringLiteral(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringLiteral)) {
                return false;
            }
            StringLiteral stringLiteral = (StringLiteral)other;
            return Intrinsics.areEqual((Object)this.value, (Object)stringLiteral.value);
        }
    }

    public static final class Template
    implements TokenPart {
        @NotNull
        private final String name;

        public Template(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return "Template(name=" + this.name + ")";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Template)) {
                return false;
            }
            Template template = (Template)other;
            return Intrinsics.areEqual((Object)this.name, (Object)template.name);
        }
    }
}

