/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.FeedV1Json;
import com.jetbrains.toolbox.feed.JsonFeedParser;
import com.jetbrains.toolbox.feed.RawFeedV1DecoderKt;
import com.jetbrains.toolbox.feed.SignatureManager;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tukaani.xz.XZInputStream;

public final class RawFeedV1Decoder {
    @NotNull
    private final SignatureManager signatureManager;
    @NotNull
    private final JsonFeedParser feedParser;

    public RawFeedV1Decoder(@NotNull SignatureManager signatureManager, @NotNull JsonFeedParser feedParser2) {
        Intrinsics.checkNotNullParameter((Object)signatureManager, (String)"signatureManager");
        Intrinsics.checkNotNullParameter((Object)feedParser2, (String)"feedParser");
        this.signatureManager = signatureManager;
        this.feedParser = feedParser2;
    }

    public /* synthetic */ RawFeedV1Decoder(SignatureManager signatureManager, JsonFeedParser jsonFeedParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            signatureManager = new SignatureManager(null, 1, null);
        }
        if ((n & 2) != 0) {
            jsonFeedParser = JsonFeedParser.Companion.getDefault();
        }
        this(signatureManager, jsonFeedParser);
    }

    @NotNull
    public final SignatureManager.ResultWithCerts<FeedV1Json> decode(@NotNull InputStream feedXzSignedInputStream) {
        Intrinsics.checkNotNullParameter((Object)feedXzSignedInputStream, (String)"feedXzSignedInputStream");
        return this.signatureManager.consumeAndVerify(feedXzSignedInputStream, arg_0 -> RawFeedV1Decoder.decode$lambda$0(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FeedV1Json decode$lambda$0(RawFeedV1Decoder this$0, InputStream feedXzInputStream) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)feedXzInputStream, (String)"feedXzInputStream");
        try {
            FeedV1Json feedV1Json;
            object = (Closeable)new XZInputStream(feedXzInputStream);
            Throwable throwable = null;
            try {
                XZInputStream feedInputStream = (XZInputStream)object;
                boolean bl = false;
                feedV1Json = this$0.feedParser.parse((InputStream)feedInputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = feedV1Json;
        }
        catch (Throwable t2) {
            RawFeedV1DecoderKt.access$getLogger$p().debug("Failed to parse JSON document. " + t2.getMessage(), t2);
            throw new Exception("Failed to parse JSON. " + t2.getMessage(), t2);
        }
        return object;
    }

    public RawFeedV1Decoder() {
        this(null, null, 3, null);
    }
}

