/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.BuildNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@VisibleForTesting
public final class Query {
    @NotNull
    private final Map<String, Object> properties;
    @NotNull
    private final Map<String, Function2<Object, Object, Boolean>> operators;

    public Query(@NotNull Map<String, ? extends Object> properties2) {
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        this.properties = properties2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$eq", Query::operators$lambda$0), TuplesKt.to((Object)"$ne", Query::operators$lambda$1), TuplesKt.to((Object)"$gt", (arg_0, arg_1) -> Query.operators$lambda$2(this, arg_0, arg_1)), TuplesKt.to((Object)"$gte", (arg_0, arg_1) -> Query.operators$lambda$3(this, arg_0, arg_1)), TuplesKt.to((Object)"$lt", (arg_0, arg_1) -> Query.operators$lambda$4(this, arg_0, arg_1)), TuplesKt.to((Object)"$lte", (arg_0, arg_1) -> Query.operators$lambda$5(this, arg_0, arg_1))};
        this.operators = MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ Query(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2);
    }

    @NotNull
    public final List<String> evaluate(@NotNull Map<String, ? extends JsonElement> query2) {
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        List errors = new ArrayList();
        for (String condition : query2.keySet()) {
            if (!this.properties.keySet().contains(condition)) {
                return CollectionsKt.listOf((Object)"Unknown requirements");
            }
            JsonElement predicates = query2.get(condition);
            if (predicates instanceof JsonObject) {
                for (String predicate : ((JsonObject)predicates).keySet()) {
                    if (Intrinsics.areEqual((Object)predicate, (Object)"error_message")) continue;
                    if (!this.operators.containsKey(predicate)) {
                        return CollectionsKt.listOf((Object)"Unknown requirements");
                    }
                    Function2 function = (Function2)MapsKt.getValue(this.operators, (Object)predicate);
                    Object value2 = MapsKt.getValue(this.properties, (Object)condition);
                    Object object = (JsonElement)((JsonObject)predicates).get((Object)predicate);
                    if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
                        object = "";
                    }
                    if (((Boolean)function.invoke(value2, object)).booleanValue()) continue;
                    Object object2 = (JsonElement)((JsonObject)predicates).get((Object)"error_message");
                    if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) == null) {
                        object2 = "";
                    }
                    errors.add(StringsKt.replace$default((String)object2, (String)"$value", (String)value2.toString(), (boolean)false, (int)4, null));
                }
                continue;
            }
            Object object = predicates;
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
                object = "";
            }
            Object value3 = object;
            Function2 function = (Function2)MapsKt.getValue(this.operators, (Object)"$eq");
            Object object3 = this.properties.get(condition);
            if (object3 == null) {
                object3 = "";
            }
            if (((Boolean)function.invoke(object3, value3)).booleanValue()) continue;
            return CollectionsKt.listOf((Object)"Unknown requirements");
        }
        return errors;
    }

    private final int compareTo(Object $this$compareTo, Object other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        if ($this$compareTo instanceof Integer || other instanceof Integer) {
            return Intrinsics.compare((int)this.toInt($this$compareTo), (int)this.toInt(other));
        }
        if ($this$compareTo instanceof BuildNumber || other instanceof BuildNumber) {
            return BuildNumber.compareTo-Szkhn3Q(this.toVersion-ekfRXtk($this$compareTo), this.toVersion-ekfRXtk(other));
        }
        return $this$compareTo.toString().compareTo(other.toString());
    }

    private final int toInt(Object $this$toInt) {
        if ($this$toInt instanceof Number) {
            return ((Number)$this$toInt).intValue();
        }
        if ($this$toInt instanceof String) {
            return Integer.parseInt((String)$this$toInt, CharsKt.checkRadix((int)10));
        }
        return 0;
    }

    private final String toVersion-ekfRXtk(Object $this$toVersion_u2dekfRXtk) {
        if ($this$toVersion_u2dekfRXtk instanceof BuildNumber) {
            return ((BuildNumber)$this$toVersion_u2dekfRXtk).unbox-impl();
        }
        if ($this$toVersion_u2dekfRXtk instanceof String) {
            return BuildNumber.constructor-impl((String)$this$toVersion_u2dekfRXtk);
        }
        return BuildNumber.Companion.getZERO-Y_E1uuk();
    }

    private static final boolean operators$lambda$0(Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a.toString(), (Object)b.toString());
    }

    private static final boolean operators$lambda$1(Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return !Intrinsics.areEqual((Object)a.toString(), (Object)b.toString());
    }

    private static final boolean operators$lambda$2(Query this$0, Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this$0.compareTo(a, b) > 0;
    }

    private static final boolean operators$lambda$3(Query this$0, Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this$0.compareTo(a, b) >= 0;
    }

    private static final boolean operators$lambda$4(Query this$0, Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this$0.compareTo(a, b) < 0;
    }

    private static final boolean operators$lambda$5(Query this$0, Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this$0.compareTo(a, b) <= 0;
    }

    public Query() {
        this(null, 1, null);
    }
}

