/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.Capabilities;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.FeedV1Json;
import com.jetbrains.toolbox.feed.JsonFeedParserKt;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import java.io.InputStream;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonFeedParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Capabilities capabilities;
    @NotNull
    private Function1<? super FeedLocation, FeedLocation> locationMapper;
    @NotNull
    private Function1<? super String, Boolean> osFilter;
    @NotNull
    private Function1<? super RemoteFeedItem, Boolean> feedFilter;
    @NotNull
    private Function1<? super RemoteFeedItem, RemoteFeedItem> feedMapper;

    public JsonFeedParser(@NotNull Function1<? super JsonFeedParser, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        this.locationMapper = JsonFeedParser::locationMapper$lambda$0;
        this.osFilter = JsonFeedParser::osFilter$lambda$0;
        this.feedFilter = JsonFeedParser::feedFilter$lambda$0;
        this.feedMapper = JsonFeedParser::feedMapper$lambda$0;
        init2.invoke((Object)this);
    }

    public /* synthetic */ JsonFeedParser(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = JsonFeedParser::_init_$lambda$0;
        }
        this((Function1<? super JsonFeedParser, Unit>)function1);
    }

    public final void setCapabilities(@Nullable Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public final void setLocationMapper(@NotNull Function1<? super FeedLocation, FeedLocation> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.locationMapper = function1;
    }

    public final void setOsFilter(@NotNull Function1<? super String, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.osFilter = function1;
    }

    public final void setFeedFilter(@NotNull Function1<? super RemoteFeedItem, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.feedFilter = function1;
    }

    public final void setFeedMapper(@NotNull Function1<? super RemoteFeedItem, RemoteFeedItem> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.feedMapper = function1;
    }

    @NotNull
    public final FeedV1Json parse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return JsonFeedParserKt.parseWholeFeed(stream, this.capabilities, this.locationMapper, this.osFilter, this.feedFilter, this.feedMapper);
    }

    private static final Unit _init_$lambda$0(JsonFeedParser jsonFeedParser) {
        Intrinsics.checkNotNullParameter((Object)jsonFeedParser, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final FeedLocation locationMapper$lambda$0(FeedLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final boolean osFilter$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean feedFilter$lambda$0(RemoteFeedItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final RemoteFeedItem feedMapper$lambda$0(RemoteFeedItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    public JsonFeedParser() {
        this(null, 1, null);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonFeedParser getDefault() {
            return new JsonFeedParser(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

