/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.DataUrl;
import com.jetbrains.toolbox.feed.Activation;
import com.jetbrains.toolbox.feed.AdditionalInstallAction;
import com.jetbrains.toolbox.feed.ApplicationMajorVersion;
import com.jetbrains.toolbox.feed.ApplicationMajorVersionKt;
import com.jetbrains.toolbox.feed.ApplicationPackage;
import com.jetbrains.toolbox.feed.ApplicationPackageType;
import com.jetbrains.toolbox.feed.ApplicationQuality;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.ArchFilter;
import com.jetbrains.toolbox.feed.Authenticator;
import com.jetbrains.toolbox.feed.Build;
import com.jetbrains.toolbox.feed.DataPiecesKt;
import com.jetbrains.toolbox.feed.Distribution;
import com.jetbrains.toolbox.feed.EmbeddedClient;
import com.jetbrains.toolbox.feed.FeedConvertorKt;
import com.jetbrains.toolbox.feed.FeedV1;
import com.jetbrains.toolbox.feed.FeedV2;
import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.feed.Flavor;
import com.jetbrains.toolbox.feed.IntelliJBuildProperties;
import com.jetbrains.toolbox.feed.IntelliJConfiguration;
import com.jetbrains.toolbox.feed.IntelliJPlatformData;
import com.jetbrains.toolbox.feed.IntelliJToolProperties;
import com.jetbrains.toolbox.feed.LicenseAgreement;
import com.jetbrains.toolbox.feed.Patch;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.feed.ProductOverview;
import com.jetbrains.toolbox.feed.ReSharperData;
import com.jetbrains.toolbox.feed.RemoteChecksum;
import com.jetbrains.toolbox.feed.RemoteDevelopment;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.RemoteFeedItemKt;
import com.jetbrains.toolbox.feed.RemoteFeedItemLicensing;
import com.jetbrains.toolbox.feed.RemotePatchItem;
import com.jetbrains.toolbox.feed.SupersededApplication;
import com.jetbrains.toolbox.feed.SupportedLanguage;
import com.jetbrains.toolbox.feed.Tool;
import com.jetbrains.toolbox.feed.ToolPlatform;
import com.jetbrains.toolbox.feed.ToolVersion;
import com.jetbrains.toolbox.feed.UninstallOptions;
import com.jetbrains.toolbox.feed.Vendor;
import com.jetbrains.toolbox.feed.WhatsNew;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SourceDebugExtension(value={"SMAP\nFeedConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedConvertor.kt\ncom/jetbrains/toolbox/feed/FeedConvertorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1563#2:201\n1634#2,3:202\n1491#2:205\n1516#2,3:206\n1519#2,3:216\n1491#2:219\n1516#2,3:220\n1519#2,3:230\n1491#2:236\n1516#2,3:237\n1519#2,3:247\n1491#2:253\n1516#2,3:254\n1519#2,3:264\n1969#2,14:270\n1491#2:284\n1516#2,3:285\n1519#2,3:295\n1563#2:302\n1634#2,2:303\n1252#2,4:307\n1636#2:311\n1563#2:317\n1634#2,3:318\n1252#2,4:324\n382#3,7:209\n382#3,7:223\n382#3,7:240\n382#3,7:257\n382#3,7:288\n463#3:305\n413#3:306\n463#3:322\n413#3:323\n126#4:233\n153#4,2:234\n77#4:250\n97#4,2:251\n126#4:267\n153#4,2:268\n126#4:299\n153#4,2:300\n155#4:312\n155#4:313\n99#4,3:314\n155#4:321\n1#5:298\n*S KotlinDebug\n*F\n+ 1 FeedConvertor.kt\ncom/jetbrains/toolbox/feed/FeedConvertorKt\n*L\n33#1:201\n33#1:202,3\n92#1:205\n92#1:206,3\n92#1:216,3\n95#1:219\n95#1:220,3\n95#1:230,3\n100#1:236\n100#1:237,3\n100#1:247,3\n121#1:253\n121#1:254,3\n121#1:264,3\n123#1:270,14\n124#1:284\n124#1:285,3\n124#1:295,3\n141#1:302\n141#1:303,2\n155#1:307,4\n141#1:311\n173#1:317\n173#1:318,3\n195#1:324,4\n92#1:209,7\n95#1:223,7\n100#1:240,7\n121#1:257,7\n124#1:288,7\n155#1:305\n155#1:306\n195#1:322\n195#1:323\n96#1:233\n96#1:234,2\n120#1:250\n120#1:251,2\n122#1:267\n122#1:268,2\n133#1:299\n133#1:300,2\n133#1:312\n122#1:313\n120#1:314,3\n96#1:321\n*E\n"})
public final class FeedConvertorKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.jetbrains.toolbox.feed.FeedConvertor");
    private static final Comparator<RemoteFeedItem> feedItemsComparator;
    @VisibleForTesting
    @NotNull
    private static final Comparator<Distribution> distributionsComparator;
    private static final Comparator<Pair<ApplicationMajorVersion, ApplicationQuality>> majorVersionThenQualityComparator;

    private static final int order(ArchFilter archFilter) {
        return switch (WhenMappings.$EnumSwitchMapping$0[archFilter.ordinal()]) {
            case 1, 2 -> 1;
            case 3 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final IntelliJToolProperties toToolProperties(IntelliJPlatformData $this$toToolProperties) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$toToolProperties.getConfig();
        Set set2 = CollectionsKt.toSet((Iterable)$this$toToolProperties.getDirectoryPatterns());
        String string = $this$toToolProperties.getShellScriptName();
        String string2 = $this$toToolProperties.getProductCode-fnix534();
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntelliJConfiguration intelliJConfiguration = (IntelliJConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRecentProjectsFilename());
        }
        collection = (List)destination$iv$iv;
        IntelliJConfiguration intelliJConfiguration = (IntelliJConfiguration)CollectionsKt.firstOrNull($this$toToolProperties.getConfig());
        DefaultConstructorMarker defaultConstructorMarker = null;
        Collection<Flavor> collection2 = $this$toToolProperties.getFlavors();
        boolean bl = intelliJConfiguration != null ? intelliJConfiguration.getShowSingleProject() : true;
        Set set3 = CollectionsKt.toSet((Iterable)collection);
        Set set4 = set2;
        String string3 = string;
        String string4 = string2;
        return new IntelliJToolProperties(string4, string3, set4, set3, bl, collection2, defaultConstructorMarker);
    }

    private static final IntelliJBuildProperties toBuildProperties(IntelliJPlatformData $this$toBuildProperties) {
        return new IntelliJBuildProperties($this$toBuildProperties.getUserVmOptions(), CollectionsKt.toSet((Iterable)$this$toBuildProperties.getIncompatibleVmoptions()), $this$toBuildProperties.getDefaultConfigDirectories(), $this$toBuildProperties.getLocalizationPlugins());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ArchFilter getArchFilter(@NotNull ApplicationPackage $this$archFilter) {
        block10: {
            block12: {
                block13: {
                    block15: {
                        block14: {
                            block11: {
                                block9: {
                                    Intrinsics.checkNotNullParameter((Object)$this$archFilter, (String)"<this>");
                                    requirements = $this$archFilter.getRequirements();
                                    if (requirements == null) {
                                        FeedConvertorKt.logger.debug("No requirements defined ({}), can't determine arch", (Object)$this$archFilter.getUrl());
                                        return ArchFilter.ANY_ARCH;
                                    }
                                    var3_2 = requirements.get((Object)"cpu_arch");
                                    v0 = cpuArch = var3_2 instanceof JsonObject != false ? (JsonObject)var3_2 : null;
                                    if (cpuArch == null) {
                                        FeedConvertorKt.logger.debug("No cpu_arch defined in `{}` ({}), can't determine arch", (Object)requirements, (Object)$this$archFilter.getUrl());
                                        return ArchFilter.ANY_ARCH;
                                    }
                                    var5_4 = cpuArch.get((Object)"$eq");
                                    v1 = var5_4 instanceof JsonPrimitive != false ? (JsonPrimitive)var5_4 : null;
                                    v2 = eq = v1 != null ? v1.getContent() : null;
                                    if (!Intrinsics.areEqual((Object)eq, (Object)"x64")) break block9;
                                    v3 = ArchFilter.ONLY_X64;
                                    break block10;
                                }
                                if (!Intrinsics.areEqual((Object)eq, (Object)"arm64")) break block11;
                                v3 = ArchFilter.ONLY_ARM64;
                                break block10;
                            }
                            if (eq != null) break block12;
                            var6_5 = cpuArch.get((Object)"$ne");
                            v4 = var6_5 instanceof JsonPrimitive != false ? (JsonPrimitive)var6_5 : null;
                            v5 = ne = v4 != null ? v4.getContent() : null;
                            if (v5 == null) break block13;
                            switch (v5.hashCode()) {
                                case 93084186: {
                                    if (!ne.equals("arm64")) {
                                        ** break;
                                    }
                                    break block14;
                                }
                                case 117046: {
                                    if (ne.equals("x64")) break;
                                    ** break;
                                }
                                case 117110: {
                                    if (!ne.equals("x86")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                            }
                            v3 = ArchFilter.ONLY_ARM64;
                            break block10;
                        }
                        v3 = ArchFilter.ONLY_X64;
                        break block10;
                    }
                    v3 = ArchFilter.ANY_ARCH;
                    break block10;
                }
                FeedConvertorKt.logger.warn("No cpu_arch eq/ne defined in `{}` ({}), can't determine arch", (Object)requirements, (Object)$this$archFilter.getUrl());
                v3 = ArchFilter.ANY_ARCH;
                break block10;
lbl51:
                // 4 sources

                var5_4 = new Object[]{ne, requirements, $this$archFilter.getUrl()};
                FeedConvertorKt.logger.warn("Unknown cpu_arch ne ({}) in `{}` ({}), can't determine arch", var5_4);
                v3 = ArchFilter.ANY_ARCH;
                break block10;
            }
            var4_7 = new Object[]{eq, requirements, $this$archFilter.getUrl()};
            FeedConvertorKt.logger.warn("Unknown cpu_arch eq ({}) in `{}` ({}), can't determine arch", var4_7);
            v3 = ArchFilter.ANY_ARCH;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FeedV2 toV2(@NotNull FeedV1 $this$toV2) {
        Object object;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map.Entry $this$map$iv;
        Object feedItems;
        void $this$mapTo$iv$iv;
        Map<PluginId, List<String>> $this$groupByTo$iv$iv;
        Object key$iv$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$toV2, (String)"<this>");
        Iterable $this$groupBy$iv = $this$toV2.getPatches();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            RemotePatchItem it = (RemotePatchItem)element$iv$iv2;
            boolean bl = false;
            ApplicationType key$iv$iv = ApplicationType.box-impl(it.getApplicationType-UtVBrGo());
            Object object3 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv2);
        }
        Map appTypeToPatches = destination$iv$iv;
        Iterable $this$groupBy$iv2 = $this$toV2.getFeedItems();
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        element$iv$iv2 = $this$groupByTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Object object4;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv2.next();
            RemoteFeedItem it = (RemoteFeedItem)element$iv$iv3;
            boolean bl = false;
            ApplicationType key$iv$iv = ApplicationType.box-impl(it.getApplicationType-UtVBrGo());
            key$iv$iv$iv = destination$iv$iv2;
            ApplicationType key$iv$iv$iv2 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv2);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv2, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv3);
        }
        Map<PluginId, List<String>> $this$map$iv2 = destination$iv$iv2;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Collection<Patch> collection;
            void $this$mapTo$iv$iv2;
            List list2;
            Map.Entry $this$flatMapTo$iv$iv;
            String string;
            String string2;
            String string3;
            List<SupersededApplication> list3;
            Vendor vendor;
            String string4;
            int n;
            LocalDateTime localDateTime;
            String string5;
            Activation activation;
            List<SupportedLanguage> list4;
            LicenseAgreement licenseAgreement;
            boolean bl;
            ProductOverview productOverview;
            IntelliJToolProperties intelliJToolProperties;
            List list5;
            Object value$iv$iv$iv;
            void $this$groupByTo$iv$iv3;
            void $this$groupBy$iv3;
            Map.Entry item$iv$iv;
            Map.Entry list$iv$iv = item$iv$iv = (Map.Entry)element$iv$iv2.next();
            Object object5 = destination$iv$iv2;
            boolean bl4 = false;
            String appType = ((ApplicationType)list$iv$iv.getKey()).unbox-impl();
            feedItems = (List)list$iv$iv.getValue();
            RemoteFeedItem latestBuildOfBestQuality = FeedConvertorKt.findLatestOfBestQuality((List<RemoteFeedItem>)feedItems);
            Iterable $i$f$getOrPut = (Iterable)feedItems;
            boolean $i$f$groupBy32 = false;
            void answer$iv$iv$iv = $this$groupBy$iv3;
            Map destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo3 = false;
            for (Object element$iv$iv4 : $this$groupByTo$iv$iv3) {
                Object object6;
                void $this$getOrPut$iv$iv$iv;
                RemoteFeedItem it = (RemoteFeedItem)element$iv$iv4;
                boolean bl5 = false;
                Pair key$iv$iv = TuplesKt.to((Object)ApplicationMajorVersionKt.orMax(it.getMajorVersion()), (Object)DataPiecesKt.orDefault(it.getQuality()));
                Map map2 = destination$iv$iv3;
                Pair key$iv$iv$iv3 = key$iv$iv;
                boolean $i$f$getOrPut2 = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv3);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv3, answer$iv$iv$iv2);
                    object6 = answer$iv$iv$iv2;
                } else {
                    object6 = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object6;
                list$iv$iv2.add(element$iv$iv4);
            }
            Comparator<Pair<ApplicationMajorVersion, ApplicationQuality>> comparator = majorVersionThenQualityComparator;
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"majorVersionThenQualityComparator");
            SortedMap versions = MapsKt.toSortedMap((Map)destination$iv$iv3, comparator);
            String toolIcon = latestBuildOfBestQuality.getIcon-fijqFwY();
            String string6 = appType;
            String string7 = latestBuildOfBestQuality.getName();
            String string8 = toolIcon;
            List<SupersededApplication> list6 = latestBuildOfBestQuality.getSupersedes();
            Vendor vendor2 = latestBuildOfBestQuality.getVendor();
            String string9 = latestBuildOfBestQuality.getDescription();
            int n2 = latestBuildOfBestQuality.getOrderValue();
            LocalDateTime localDateTime2 = latestBuildOfBestQuality.getLaunched();
            String string10 = latestBuildOfBestQuality.getHomeUrl();
            Activation activation2 = latestBuildOfBestQuality.getActivation();
            List<SupportedLanguage> list7 = latestBuildOfBestQuality.getLanguages();
            LicenseAgreement licenseAgreement2 = latestBuildOfBestQuality.getLicenseAgreement();
            boolean bl7 = latestBuildOfBestQuality.getFreeForNonCommercialUse();
            ProductOverview productOverview2 = latestBuildOfBestQuality.getProductOverview();
            IntelliJPlatformData intelliJPlatformData = latestBuildOfBestQuality.getIntelliJPlatform();
            IntelliJToolProperties intelliJToolProperties2 = intelliJPlatformData != null ? FeedConvertorKt.toToolProperties(intelliJPlatformData) : null;
            if (latestBuildOfBestQuality.getDeprecated()) {
                list5 = CollectionsKt.emptyList();
            } else {
                void $this$flatMap$iv;
                Map $i$f$groupBy32 = versions;
                intelliJToolProperties = intelliJToolProperties2;
                productOverview = productOverview2;
                bl = bl7;
                licenseAgreement = licenseAgreement2;
                list4 = list7;
                activation = activation2;
                string5 = string10;
                localDateTime = localDateTime2;
                n = n2;
                string4 = string9;
                vendor = vendor2;
                list3 = list6;
                string3 = string8;
                string2 = string7;
                string = string6;
                boolean $i$f$flatMap = false;
                destination$iv$iv3 = $this$flatMap$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv3;
                    Map patchVersions;
                    Map $this$groupByTo$iv$iv4;
                    Map.Entry element$iv$iv5;
                    Map.Entry bl5 = element$iv$iv5 = iterator2.next();
                    boolean bl8 = false;
                    List items2 = (List)bl5.getValue();
                    Intrinsics.checkNotNull((Object)items2);
                    Iterable $this$groupBy$iv4 = items2;
                    boolean $i$f$groupBy4 = false;
                    value$iv$iv$iv = $this$groupBy$iv4;
                    Object destination$iv$iv5 = new LinkedHashMap();
                    boolean $i$f$groupByTo4 = false;
                    Iterator<Object> iterator3 = $this$groupByTo$iv$iv4.iterator();
                    while (iterator3.hasNext()) {
                        Object object7;
                        void $this$getOrPut$iv$iv$iv;
                        Object element$iv$iv6 = iterator3.next();
                        RemoteFeedItem it = (RemoteFeedItem)element$iv$iv6;
                        boolean bl9 = false;
                        String key$iv$iv = it.getVersion();
                        Map map3 = destination$iv$iv5;
                        String key$iv$iv$iv4 = key$iv$iv;
                        boolean $i$f$getOrPut3 = false;
                        Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv4);
                        if (value$iv$iv$iv2 == null) {
                            boolean bl10 = false;
                            List answer$iv$iv$iv3 = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv4, answer$iv$iv$iv3);
                            object7 = answer$iv$iv$iv3;
                        } else {
                            object7 = value$iv$iv$iv2;
                        }
                        List list$iv$iv3 = (List)object7;
                        list$iv$iv3.add(element$iv$iv6);
                    }
                    Map $this$map$iv3 = patchVersions = destination$iv$iv5;
                    boolean $i$f$map2 = false;
                    $this$groupByTo$iv$iv4 = $this$map$iv3;
                    destination$iv$iv5 = new ArrayList($this$map$iv3.size());
                    boolean $i$f$mapTo2 = false;
                    iterator3 = $this$mapTo$iv$iv3.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Object object8;
                        void $this$mapTo$iv$iv4;
                        void $this$map$iv4;
                        boolean bl11;
                        void it;
                        Object key$iv$iv$iv5;
                        void $this$groupByTo$iv$iv5;
                        Object t2;
                        Map.Entry item$iv$iv2;
                        Map.Entry entry = item$iv$iv2 = (Map.Entry)iterator3.next();
                        Object object9 = destination$iv$iv5;
                        boolean bl12 = false;
                        String versionName = (String)entry.getKey();
                        List builds = (List)entry.getValue();
                        Iterable $this$maxBy$iv = builds;
                        boolean $i$f$maxByOrThrow = false;
                        Iterator iterator$iv = $this$maxBy$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            t2 = maxElem$iv;
                        } else {
                            RemoteFeedItem it2 = (RemoteFeedItem)maxElem$iv;
                            boolean bl13 = false;
                            Comparable maxValue$iv = BuildNumber.box-impl(it2.getBuild-Y_E1uuk());
                            do {
                                Object e$iv = iterator$iv.next();
                                RemoteFeedItem it3 = (RemoteFeedItem)e$iv;
                                $i$a$-maxByOrThrow-FeedConvertorKt$toV2$tools$2$1$1$rfi$1 = false;
                                Comparable v$iv = BuildNumber.box-impl(it3.getBuild-Y_E1uuk());
                                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            t2 = maxElem$iv;
                        }
                        RemoteFeedItem rfi = (RemoteFeedItem)t2;
                        Object $this$groupBy$iv5 = builds;
                        boolean $i$f$groupBy222 = false;
                        maxElem$iv = $this$groupBy$iv5;
                        Object destination$iv$iv6 = new LinkedHashMap();
                        boolean $i$f$groupByTo5 = false;
                        for (Object element$iv$iv7 : $this$groupByTo$iv$iv5) {
                            Object object10;
                            void $this$getOrPut$iv$iv$iv;
                            RemoteFeedItem it4 = (RemoteFeedItem)element$iv$iv7;
                            boolean bl14 = false;
                            BuildNumber key$iv$iv = BuildNumber.box-impl(it4.getBuild-Y_E1uuk());
                            Map map4 = destination$iv$iv6;
                            key$iv$iv$iv5 = key$iv$iv;
                            boolean $i$f$getOrPut4 = false;
                            Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv5);
                            if (value$iv$iv$iv3 == null) {
                                boolean bl15 = false;
                                List answer$iv$iv$iv4 = new ArrayList();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv5, answer$iv$iv$iv4);
                                object10 = answer$iv$iv$iv4;
                            } else {
                                object10 = value$iv$iv$iv3;
                            }
                            List list$iv$iv4 = (List)object10;
                            list$iv$iv4.add(element$iv$iv7);
                        }
                        Map buildToOses = destination$iv$iv6;
                        String string11 = rfi.getIcon-fijqFwY();
                        Object object11 = $this$groupBy$iv5 = string11 != null ? DataUrl.box-impl(string11) : null;
                        String $i$f$groupBy222 = object11 != null ? ((DataUrl)object11).unbox-impl() : null;
                        ApplicationMajorVersion applicationMajorVersion = ApplicationMajorVersionKt.orMax(rfi.getMajorVersion());
                        ApplicationQuality applicationQuality = DataPiecesKt.orDefault(rfi.getQuality());
                        int n3 = ApplicationMajorVersionKt.orMax(rfi.getMajorVersion()).getOrder();
                        String string12 = versionName;
                        boolean $i$a$-takeIf-FeedConvertorKt$toV2$tools$2$1$1$22 = false;
                        if (it == null) {
                            bl11 = toolIcon == null;
                        } else {
                            String string13 = toolIcon;
                            bl11 = string13 == null ? false : DataUrl.equals-impl0((String)it, string13);
                        }
                        boolean bl16 = !bl11;
                        Object object12 = bl16 ? $this$groupBy$iv5 : null;
                        $this$groupBy$iv5 = buildToOses;
                        RemoteFeedItemLicensing remoteFeedItemLicensing = rfi.getLicensing();
                        WhatsNew whatsNew2 = rfi.getWhatsNew();
                        String string14 = object12 != null ? ((DataUrl)object12).unbox-impl() : null;
                        boolean $i$f$map3 = false;
                        void $i$a$-takeIf-FeedConvertorKt$toV2$tools$2$1$1$22 = $this$map$iv4;
                        destination$iv$iv6 = new ArrayList($this$map$iv4.size());
                        boolean $i$f$mapTo3 = false;
                        Iterator<Object> iterator4 = $this$mapTo$iv$iv4.entrySet().iterator();
                        while (iterator4.hasNext()) {
                            Collection<Distribution> collection2;
                            void $this$mapTo$iv$iv5;
                            void $this$map$iv5;
                            Map.Entry item$iv$iv3;
                            Map.Entry entry2 = item$iv$iv3 = (Map.Entry)iterator4.next();
                            object8 = destination$iv$iv6;
                            boolean bl17 = false;
                            String buildNumber = ((BuildNumber)entry2.getKey()).unbox-impl();
                            List buildsForOses = (List)entry2.getValue();
                            key$iv$iv$iv5 = buildsForOses;
                            RemoteDevelopment remoteDevelopment = rfi.getRemoteDevelopment();
                            ReSharperData reSharperData = rfi.getResharper();
                            LocalDateTime localDateTime3 = rfi.getExpires();
                            LocalDateTime localDateTime4 = rfi.getReleased();
                            WhatsNew whatsNew3 = rfi.getWhatsNew();
                            String string15 = buildNumber;
                            boolean $i$f$map4 = false;
                            void var84_132 = $this$map$iv5;
                            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
                            boolean $i$f$mapTo4 = false;
                            for (Object item$iv$iv4 : $this$mapTo$iv$iv5) {
                                AdditionalInstallAction additionalInstallAction;
                                AdditionalInstallAction additionalInstallAction2;
                                Object object13;
                                FileAssociationsSupport fileAssociationsSupport;
                                void $this$associateByTo$iv$iv$iv2;
                                void $this$mapValuesTo$iv$iv2;
                                void $this$mapValues$iv2;
                                CharSequence charSequence;
                                void buildForOs;
                                RemoteFeedItem remoteFeedItem = (RemoteFeedItem)item$iv$iv4;
                                collection2 = destination$iv$iv7;
                                boolean bl18 = false;
                                ToolPlatform toolPlatform = new ToolPlatform(buildForOs.getPackage().getOs());
                                ArchFilter archFilter = FeedConvertorKt.getArchFilter(buildForOs.getPackage());
                                ApplicationPackageType applicationPackageType = buildForOs.getPackage().getType();
                                int n4 = buildForOs.getPackage().getStripDirectories();
                                Object object14 = buildForOs.getPackage().getCommand();
                                if (object14.length() == 0) {
                                    boolean bl19 = false;
                                    charSequence = null;
                                } else {
                                    charSequence = object14;
                                }
                                String string16 = (String)charSequence;
                                RemoteDevelopment remoteDevelopment2 = buildForOs.getRemoteDevelopment();
                                object14 = remoteDevelopment2 != null ? remoteDevelopment2.getEmbeddedClient() : null;
                                String string17 = buildForOs.getPackage().getUrl();
                                long l = buildForOs.getPackage().getSize();
                                Authenticator authenticator = buildForOs.getPackage().getAuth();
                                List<RemoteChecksum> list8 = buildForOs.getPackage().getChecksums();
                                List<String> list9 = buildForOs.getPackage().getArguments();
                                Map<String, String> map5 = (Map<String, String>)buildForOs.getPackage().getRequirements();
                                if (map5 == null) {
                                    map5 = MapsKt.emptyMap();
                                }
                                Map<String, String> map6 = map5;
                                boolean $i$f$mapValues = false;
                                Object object15 = $this$mapValues$iv2;
                                Map destination$iv$iv8 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
                                boolean $i$f$mapValuesTo = false;
                                Object object16 = $this$mapValuesTo$iv$iv2.entrySet();
                                Map destination$iv$iv$iv = destination$iv$iv8;
                                boolean $i$f$associateByTo = false;
                                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                                    void $this$associateByTo$iv$iv$iv3;
                                    void $this$mapValuesTo$iv$iv3;
                                    void it$iv$iv;
                                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                                    Map map7 = destination$iv$iv$iv;
                                    boolean bl20 = false;
                                    Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
                                    Object k = it$iv$iv.getKey();
                                    Map map8 = map7;
                                    boolean bl21 = false;
                                    JsonElement v = (JsonElement)entry4.getValue();
                                    Map $this$mapValues$iv3 = (Map)JsonElementKt.getJsonObject((JsonElement)v);
                                    boolean $i$f$mapValues2 = false;
                                    Map map9 = $this$mapValues$iv3;
                                    Map destination$iv$iv9 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
                                    boolean $i$f$mapValuesTo2 = false;
                                    Iterable iterable2 = $this$mapValuesTo$iv$iv3.entrySet();
                                    Map destination$iv$iv$iv2 = destination$iv$iv9;
                                    boolean $i$f$associateByTo2 = false;
                                    for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv3) {
                                        void it$iv$iv2;
                                        Map.Entry entry5 = (Map.Entry)element$iv$iv$iv2;
                                        Map map10 = destination$iv$iv$iv2;
                                        $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                                        Map.Entry entry6 = (Map.Entry)element$iv$iv$iv2;
                                        Object k2 = it$iv$iv2.getKey();
                                        Map map11 = map10;
                                        boolean bl22 = false;
                                        JsonElement e = (JsonElement)entry6.getValue();
                                        if (!JsonElementKt.getJsonPrimitive((JsonElement)e).isString()) {
                                            String string18 = "Failed requirement.";
                                            throw new IllegalArgumentException(string18.toString());
                                        }
                                        String string19 = JsonElementKt.getJsonPrimitive((JsonElement)e).getContent();
                                        map11.put(k2, string19);
                                    }
                                    Map map12 = destination$iv$iv$iv2;
                                    map8.put(k, map12);
                                }
                                Map map13 = destination$iv$iv$iv;
                                map6 = buildForOs.getPackage().getDotDesktopExtraEntries();
                                if (!Intrinsics.areEqual((Object)buildForOs.getAddToOpenWith(), (Object)true)) {
                                    v32 = null;
                                } else {
                                    Set set2 = buildForOs.getFileExtensions();
                                    if (set2 == null) {
                                        set2 = SetsKt.emptySet();
                                    }
                                    v32 = fileAssociationsSupport = new FileAssociationsSupport(set2, buildForOs.getArgsForOpenWith());
                                }
                                if ((object13 = buildForOs.getIntelliJPlatform()) == null || (object13 = ((IntelliJPlatformData)object13).getStartupWmClass()) == null) {
                                    object13 = buildForOs.getStartupWmClass();
                                }
                                object15 = object13;
                                IntelliJPlatformData intelliJPlatformData2 = buildForOs.getIntelliJPlatform();
                                IntelliJBuildProperties intelliJBuildProperties = intelliJPlatformData2 != null ? FeedConvertorKt.toBuildProperties(intelliJPlatformData2) : null;
                                AdditionalInstallAction additionalInstallAction3 = buildForOs.getAfterInstall();
                                if (additionalInstallAction3 == null) {
                                    additionalInstallAction3 = additionalInstallAction2 = new AdditionalInstallAction(null, 1, null);
                                }
                                if ((additionalInstallAction = buildForOs.getBeforeUninstall()) == null) {
                                    additionalInstallAction = new AdditionalInstallAction(null, 1, null);
                                }
                                object16 = additionalInstallAction;
                                String string20 = buildForOs.getPackage().getIconPath();
                                collection2.add(new Distribution(toolPlatform, archFilter, applicationPackageType, n4, string16, list9, (EmbeddedClient)object14, string17, l, authenticator, list8, map13, map6, fileAssociationsSupport, (String)object15, intelliJBuildProperties, additionalInstallAction2, (AdditionalInstallAction)object16, string20));
                            }
                            collection2 = (List)destination$iv$iv7;
                            DefaultConstructorMarker defaultConstructorMarker = null;
                            List list10 = CollectionsKt.sortedWith((Iterable)collection2, distributionsComparator);
                            RemoteDevelopment remoteDevelopment3 = remoteDevelopment;
                            ReSharperData reSharperData2 = reSharperData;
                            LocalDateTime localDateTime5 = localDateTime3;
                            LocalDateTime localDateTime6 = localDateTime4;
                            WhatsNew whatsNew4 = whatsNew3;
                            String string21 = string15;
                            object8.add(new Build(string21, whatsNew4, localDateTime6, localDateTime5, reSharperData2, remoteDevelopment3, list10, defaultConstructorMarker));
                        }
                        object8 = (List)destination$iv$iv6;
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        Object object17 = object8;
                        RemoteFeedItemLicensing remoteFeedItemLicensing2 = remoteFeedItemLicensing;
                        WhatsNew whatsNew5 = whatsNew2;
                        String string22 = string14;
                        ApplicationMajorVersion applicationMajorVersion2 = applicationMajorVersion;
                        ApplicationQuality applicationQuality2 = applicationQuality;
                        int n5 = n3;
                        String string23 = string12;
                        object9.add(new ToolVersion(string23, n5, applicationQuality2, applicationMajorVersion2, string22, whatsNew5, remoteFeedItemLicensing2, (List)object17, defaultConstructorMarker));
                    }
                    Iterable list$iv$iv5 = (List)destination$iv$iv5;
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv5);
                }
                list2 = (List)destination$iv$iv4;
                string6 = string;
                string7 = string2;
                string8 = string3;
                list6 = list3;
                vendor2 = vendor;
                string9 = string4;
                n2 = n;
                localDateTime2 = localDateTime;
                string10 = string5;
                activation2 = activation;
                list7 = list4;
                licenseAgreement2 = licenseAgreement;
                bl7 = bl;
                productOverview2 = productOverview;
                intelliJToolProperties2 = intelliJToolProperties;
                list5 = list2;
            }
            Iterable $this$flatMap$iv = appTypeToPatches.getOrDefault(ApplicationType.box-impl(appType), CollectionsKt.emptyList());
            list2 = list5;
            intelliJToolProperties = intelliJToolProperties2;
            productOverview = productOverview2;
            bl = bl7;
            licenseAgreement = licenseAgreement2;
            list4 = list7;
            activation = activation2;
            string5 = string10;
            localDateTime = localDateTime2;
            n = n2;
            string4 = string9;
            vendor = vendor2;
            list3 = list6;
            string3 = string8;
            string2 = string7;
            string = string6;
            boolean $i$f$map5 = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv10 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
            boolean $i$f$mapTo5 = false;
            for (Map.Entry item$iv$iv5 : $this$mapTo$iv$iv2) {
                void it;
                RemotePatchItem list$iv$iv5 = (RemotePatchItem)((Object)item$iv$iv5);
                collection = destination$iv$iv10;
                boolean bl23 = false;
                collection.add(new Patch(it.getBuildFrom-Y_E1uuk(), it.getBuildTo-Y_E1uuk(), it.getOs(), it.getType(), it.getUrl(), it.getSize(), it.getAuth(), it.getChecksums(), it.getCommand(), it.getAsserts(), null));
            }
            collection = (List)destination$iv$iv10;
            DefaultConstructorMarker defaultConstructorMarker = null;
            boolean bl24 = latestBuildOfBestQuality.getDeprecated();
            UninstallOptions uninstallOptions = latestBuildOfBestQuality.getUninstall();
            Collection<Patch> collection3 = collection;
            List list11 = list2;
            IntelliJToolProperties intelliJToolProperties3 = intelliJToolProperties;
            ProductOverview productOverview3 = productOverview;
            boolean bl25 = bl;
            LicenseAgreement licenseAgreement3 = licenseAgreement;
            List<SupportedLanguage> list12 = list4;
            Activation activation3 = activation;
            String string24 = string5;
            LocalDateTime localDateTime7 = localDateTime;
            int n6 = n;
            String string25 = string4;
            Vendor vendor3 = vendor;
            List<SupersededApplication> list13 = list3;
            String string26 = string3;
            String string27 = string2;
            String string28 = string;
            Tool tool = new Tool(string28, string27, string26, list13, vendor3, string25, n6, localDateTime7, string24, activation3, list12, licenseAgreement3, bl25, productOverview3, intelliJToolProperties3, list11, (List)collection3, uninstallOptions, bl24, defaultConstructorMarker);
            object5.add(tool);
        }
        List tools2 = (List)destination$iv$iv2;
        $this$map$iv2 = $this$toV2.getEnterprisePluginHashes();
        Set set3 = CollectionsKt.toHashSet((Iterable)$this$toV2.getServices());
        Set set4 = CollectionsKt.toHashSet((Iterable)tools2);
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        element$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        Object destination$iv$iv$iv = destination$iv$iv2;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            feedItems = (Map.Entry)element$iv$iv$iv;
            Object object18 = destination$iv$iv$iv;
            boolean bl = false;
            $this$map$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object18;
            boolean bl26 = false;
            HashSet hashSet = CollectionsKt.toHashSet((Iterable)((Iterable)it.getValue()));
            object.put(k, hashSet);
        }
        Object object19 = object = destination$iv$iv$iv;
        Set set5 = set3;
        Set set6 = set4;
        return new FeedV2(set6, set5, (Map<PluginId, ? extends Set<String>>)object19);
    }

    private static final RemoteFeedItem findLatestOfBestQuality(List<RemoteFeedItem> $this$findLatestOfBestQuality) {
        Iterable iterable = $this$findLatestOfBestQuality;
        Comparator<RemoteFeedItem> comparator = feedItemsComparator;
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"feedItemsComparator");
        return (RemoteFeedItem)CollectionsKt.minWithOrThrow((Iterable)iterable, comparator);
    }

    private static final Integer feedItemsComparator$lambda$0(RemoteFeedItem it) {
        Intrinsics.checkNotNull((Object)it);
        return RemoteFeedItemKt.qualityOrder(it);
    }

    private static final Integer feedItemsComparator$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer majorVersionThenQualityComparator$lambda$0(Pair it) {
        return ((ApplicationMajorVersion)it.getFirst()).getOrder();
    }

    private static final Integer majorVersionThenQualityComparator$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer majorVersionThenQualityComparator$lambda$2(Pair it) {
        return -((ApplicationQuality)it.getSecond()).getOrder();
    }

    private static final Integer majorVersionThenQualityComparator$lambda$3(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$order(ArchFilter archFilter) {
        return FeedConvertorKt.order(archFilter);
    }

    static {
        Function1 function1 = feedItemsComparator.2.INSTANCE;
        feedItemsComparator = Comparator.comparing(arg_0 -> FeedConvertorKt.feedItemsComparator$lambda$1(FeedConvertorKt::feedItemsComparator$lambda$0, arg_0)).reversed().thenComparing(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }).reversed();
        distributionsComparator = new Comparator(){

            public final int compare(T a, T b) {
                Distribution it = (Distribution)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(FeedConvertorKt.access$order(it.getArchFilter()));
                it = (Distribution)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(FeedConvertorKt.access$order(it.getArchFilter())));
            }
        };
        majorVersionThenQualityComparator = Comparator.comparing(arg_0 -> FeedConvertorKt.majorVersionThenQualityComparator$lambda$1(FeedConvertorKt::majorVersionThenQualityComparator$lambda$0, arg_0)).thenComparing(arg_0 -> FeedConvertorKt.majorVersionThenQualityComparator$lambda$3(FeedConvertorKt::majorVersionThenQualityComparator$lambda$2, arg_0)).reversed();
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchFilter.values().length];
            try {
                nArray[ArchFilter.ONLY_X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchFilter.ONLY_ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchFilter.ANY_ARCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

