/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.feed.ApplicationFeedDownloaderKt;
import com.jetbrains.toolbox.feed.ApplicationFeedJSONLoader;
import com.jetbrains.toolbox.feed.ConcurrentDownloadSession;
import com.jetbrains.toolbox.feed.Context;
import com.jetbrains.toolbox.feed.FeedDescriptor;
import com.jetbrains.toolbox.feed.FeedHolder;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.FeedProperties;
import com.jetbrains.toolbox.feed.FeedResult;
import com.jetbrains.toolbox.feed.InternalFeedProvider;
import com.jetbrains.toolbox.feed.ParsedFeedInternal;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nApplicationFeedDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationFeedDownloader.kt\ncom/jetbrains/toolbox/feed/ConcurrentDownloadSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Semaphore.kt\nkotlinx/coroutines/sync/SemaphoreKt\n*L\n1#1,394:1\n1563#2:395\n1634#2,3:396\n1869#2,2:406\n1#3:399\n81#4,6:400\n*S KotlinDebug\n*F\n+ 1 ApplicationFeedDownloader.kt\ncom/jetbrains/toolbox/feed/ConcurrentDownloadSession\n*L\n183#1:395\n183#1:396,3\n328#1:406,2\n201#1:400,6\n*E\n"})
final class ConcurrentDownloadSession {
    @NotNull
    private final Map<FeedLocation, FeedHolder> prevFeedData;
    @NotNull
    private final Iterable<FeedLocation> newFeeds;
    @NotNull
    private final Context context;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ApplicationFeedJSONLoader applicationFeedJSONLoader;
    @NotNull
    private final InternalFeedProvider internalFeedProvider;
    @NotNull
    private final Clock clock;
    @NotNull
    private final HashSet<FeedLocation> downloadStarted;
    @NotNull
    private final ConcurrentLinkedQueue<Deferred<FeedResult>> downloads;
    @NotNull
    private final ConcurrentHashMap<FeedLocation, ParsedFeedInternal> result;
    @NotNull
    private final Semaphore semaphore;

    public ConcurrentDownloadSession(@NotNull Map<FeedLocation, FeedHolder> prevFeedData, @NotNull Iterable<FeedLocation> newFeeds, @NotNull Context context2, @NotNull StorageManager storageManager, @NotNull ApplicationFeedJSONLoader applicationFeedJSONLoader, @NotNull InternalFeedProvider internalFeedProvider, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(prevFeedData, (String)"prevFeedData");
        Intrinsics.checkNotNullParameter(newFeeds, (String)"newFeeds");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)applicationFeedJSONLoader, (String)"applicationFeedJSONLoader");
        Intrinsics.checkNotNullParameter((Object)internalFeedProvider, (String)"internalFeedProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.prevFeedData = prevFeedData;
        this.newFeeds = newFeeds;
        this.context = context2;
        this.storageManager = storageManager;
        this.applicationFeedJSONLoader = applicationFeedJSONLoader;
        this.internalFeedProvider = internalFeedProvider;
        this.clock = clock;
        this.downloadStarted = new HashSet();
        this.downloads = new ConcurrentLinkedQueue();
        this.result = new ConcurrentHashMap();
        this.semaphore = SemaphoreKt.Semaphore$default((int)24, (int)0, (int)2, null);
    }

    @NotNull
    public final Map<FeedLocation, FeedHolder> getPrevFeedData() {
        return this.prevFeedData;
    }

    @NotNull
    public final Iterable<FeedLocation> getNewFeeds() {
        return this.newFeeds;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public final ApplicationFeedJSONLoader getApplicationFeedJSONLoader() {
        return this.applicationFeedJSONLoader;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Deferred<FeedResult>> getDownloads() {
        return this.downloads;
    }

    @NotNull
    public final ConcurrentHashMap<FeedLocation, ParsedFeedInternal> getResult() {
        return this.result;
    }

    @Nullable
    public final Object process(boolean speculative, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(speculative, this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $speculative;
            final /* synthetic */ ConcurrentDownloadSession this$0;
            {
                this.$speculative = $speculative;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        count = new Ref.IntRef();
                        if (this.$speculative) {
                            var4_5 = this.this$0.getPrevFeedData().keySet();
                            var5_6 = this.this$0;
                            $i$f$forEach = false;
                            var7_9 = $this$forEach$iv.iterator();
                            while (var7_9.hasNext()) {
                                location = element$iv = var7_9.next();
                                $i$a$-forEach-ConcurrentDownloadSession$process$2$1 = false;
                                var5_6.startDownload((CoroutineScope)$this$coroutineScope, location);
                                var11_13 = count.element;
                                count.element = var11_13 + 1;
                            }
                            $this$forEach$iv = this.this$0.getNewFeeds();
                            var5_6 = this.this$0;
                            $i$f$forEach = false;
                            var7_9 = $this$forEach$iv.iterator();
                            while (var7_9.hasNext()) {
                                it = element$iv = var7_9.next();
                                $i$a$-forEach-ConcurrentDownloadSession$process$2$2 = false;
                                if (var5_6.getPrevFeedData().containsKey(it)) continue;
                                var5_6.startDownload((CoroutineScope)$this$coroutineScope, it);
                                var11_13 = count.element;
                                count.element = var11_13 + 1;
                            }
                        } else {
                            $this$forEach$iv = this.this$0.getNewFeeds();
                            var5_6 = this.this$0;
                            $i$f$forEach = false;
                            var7_9 = $this$forEach$iv.iterator();
                            while (var7_9.hasNext()) {
                                it = element$iv = var7_9.next();
                                $i$a$-forEach-ConcurrentDownloadSession$process$2$3 = false;
                                var5_6.startDownload((CoroutineScope)$this$coroutineScope, it);
                                var11_13 = count.element;
                                count.element = var11_13 + 1;
                            }
                        }
                        Logger.INSTANCE.info("Concurrent feed download started, begin with " + count.element + " URLs");
lbl48:
                        // 3 sources

                        while (this.this$0.getDownloads().poll() != null) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)count);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(next);
                            this.label = 1;
                            v0 = next.await((Continuation)this);
                            if (v0 == var12_3) {
                                return var12_3;
                            }
                            ** GOTO lbl63
                        }
                        break;
                    }
                    case 1: {
                        next = (Deferred<FeedResult>)this.L$2;
                        count = (Ref.IntRef)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl63:
                        // 2 sources

                        if (!((feedResult = (FeedResult)v0) instanceof FeedResult.OK)) ** GOTO lbl48
                        feed = ((FeedResult.OK)feedResult).getFeed();
                        ((Map)this.this$0.getResult()).put(feedResult.getFeedLocation(), feed);
                        ** GOTO lbl48
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void startDownload(@NotNull CoroutineScope scope2, @NotNull FeedLocation feedLocation) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)feedLocation, (String)"feedLocation");
        this.downloadStarted.add(feedLocation);
        Object object = this.prevFeedData.get(feedLocation);
        if (object != null && (object = ((FeedHolder)object).toList()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FeedDescriptor feedDescriptor = (FeedDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getETag());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List prevTags = list2;
        Object object2 = prevTags;
        List it = object2;
        boolean bl = false;
        Object object3 = !((Collection)it).isEmpty() ? object2 : null;
        String recentETags = object3 != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object3), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null;
        Object $this$startDownload_u24lambda_u242 = object2 = new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build()).url(feedLocation.getUrl()).header("User-Agent", Build.INSTANCE.getUserAgent());
        boolean bl2 = false;
        String string = recentETags;
        if (string != null) {
            String it2 = string;
            boolean bl3 = false;
            ((Request.Builder)$this$startDownload_u24lambda_u242).header("If-None-Match", it2);
        }
        Request request2 = ((Request.Builder)object2).build();
        Call call2 = this.context.getSession().getHttpClient().newCall(request2);
        this.downloads.add((Deferred<FeedResult>)BuildersKt.async$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FeedResult>, Object>(this, scope2, feedLocation, request2, call2, recentETags, null){
            int label;
            final /* synthetic */ ConcurrentDownloadSession this$0;
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ FeedLocation $feedLocation;
            final /* synthetic */ Request $request;
            final /* synthetic */ Call $call;
            final /* synthetic */ String $recentETags;
            {
                this.this$0 = $receiver;
                this.$scope = $scope;
                this.$feedLocation = $feedLocation;
                this.$request = $request;
                this.$call = $call;
                this.$recentETags = $recentETags;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ConcurrentDownloadSession.access$processFeed(this.this$0, this.$scope, this.$feedLocation, this.$request, this.$call, this.$recentETags, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FeedResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object processFeed(CoroutineScope scope, FeedLocation feedLocation, Request request, Call call, String eTags, Continuation<? super FeedResult> $completion) {
        if (!($completion instanceof processFeed.1)) ** GOTO lbl-1000
        var14_7 = $completion;
        if ((var14_7.label & -2147483648) != 0) {
            var14_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConcurrentDownloadSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConcurrentDownloadSession.access$processFeed(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.semaphore;
                $i$f$withPermit = 0;
                $continuation.L$0 = scope;
                $continuation.L$1 = feedLocation;
                $continuation.L$2 = request;
                $continuation.L$3 = call;
                $continuation.L$4 = eTags;
                $continuation.L$5 = $this$withPermit$iv;
                $continuation.I$0 = $i$f$withPermit;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var15_9) {
                    return var15_9;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$withPermit = $continuation.I$0;
                $this$withPermit$iv = (Semaphore)$continuation.L$5;
                eTags = (String)$continuation.L$4;
                call = (Call)$continuation.L$3;
                request = (Request)$continuation.L$2;
                feedLocation = (FeedLocation)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 3 sources

                $i$a$-withPermit-ConcurrentDownloadSession$processFeed$2 = 0;
                concurrencyLevel = 24 - this.semaphore.getAvailablePermits();
                Logger.INSTANCE.debug("Updating feed " + feedLocation.getUrl() + ", using eTag values: [" + eTags + "], current concurrency: " + concurrencyLevel);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)scope);
                $continuation.L$1 = feedLocation;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)call);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)eTags);
                $continuation.L$5 = $this$withPermit$iv;
                $continuation.I$0 = $i$f$withPermit;
                $continuation.I$1 = $i$a$-withPermit-ConcurrentDownloadSession$processFeed$2;
                $continuation.I$2 = concurrencyLevel;
                $continuation.label = 2;
                v1 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)ApplicationFeedDownloaderKt.access$getDownloadTimeout$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FeedResult>, Object>(this, call, request, feedLocation, scope, null){
                    Object L$1;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ ConcurrentDownloadSession this$0;
                    final /* synthetic */ Call $call;
                    final /* synthetic */ Request $request;
                    final /* synthetic */ FeedLocation $feedLocation;
                    final /* synthetic */ CoroutineScope $scope;
                    {
                        this.this$0 = $receiver;
                        this.$call = $call;
                        this.$request = $request;
                        this.$feedLocation = $feedLocation;
                        this.$scope = $scope;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (CoroutineScope)this.L$0;
                        var26_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                startedAt = this.this$0.getClock().now();
                                this.L$0 = $this$withTimeoutOrNull;
                                this.L$1 = startedAt;
                                this.label = 1;
                                v0 = DownloadSessionUtilKt.await(this.$call, (Continuation<? super Response>)((Continuation)this));
                                ** if (v0 != var26_3) goto lbl15
lbl14:
                                // 1 sources

                                return var26_3;
lbl15:
                                // 1 sources

                                ** GOTO lbl22
                            }
                            case 1: {
                                startedAt = (Instant)this.L$1;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl22:
                                    // 2 sources

                                    var5_5 /* !! */  = (Response)v0;
                                }
                                catch (CancellationException c) {
                                    throw c;
                                }
                                catch (IOException t) {
                                    var8_10 = t;
                                    if (var8_10 instanceof ConnectException) {
                                        v1 = "Connection to " + this.$request.url() + " failed: " + t.getMessage();
                                    } else if (var8_10 instanceof UnknownHostException) {
                                        v1 = "Host " + this.$request.url() + " not found: " + t.getMessage();
                                    } else if (var8_10 instanceof SocketTimeoutException) {
                                        v1 = "Connection to " + this.$request.url() + " timed out: " + t.getMessage();
                                    } else {
                                        v1 = t.getMessage();
                                        if (v1 == null) {
                                            v1 = "Unknown IO error " + (CoroutineScope)$this$withTimeoutOrNull;
                                        }
                                    }
                                    message = v1;
                                    Logger.INSTANCE.warn("Unable to download feed from " + this.$feedLocation.getUrl() + ": " + message);
                                    if (Intrinsics.areEqual((Object)t.getMessage(), (Object)"Failed to authenticate with proxy")) {
                                        this.this$0.getContext().getStatus().setSuppressError(true);
                                    }
                                    v2 = this.this$0.getPrevFeedData().get(this.$feedLocation);
                                    v3 = prevFeed = v2 != null ? v2.getFeed() : null;
                                    if (prevFeed != null) {
                                        Logger.INSTANCE.warn("Using previous feed for " + this.$feedLocation.getUrl() + " due to network error: " + message);
                                        v4 = new FeedResult.OK(this.$feedLocation, prevFeed);
                                    } else {
                                        v4 = new FeedResult.Failed(this.$feedLocation);
                                    }
                                    return v4;
                                }
                                catch (Throwable t) {
                                    return new FeedResult.Failed(this.$feedLocation);
                                }
                                response = var5_5 /* !! */ ;
                                var5_5 /* !! */  = response;
                                var6_9 = this.$feedLocation;
                                var7_13 = this.this$0;
                                var8_11 = this.$scope;
                                var9_15 = null;
                                try {
                                    it /* !! */  = var5_5 /* !! */ ;
                                    $i$a$-use-ConcurrentDownloadSession$processFeed$2$1$1 = false;
                                    if (!response.isSuccessful()) ** GOTO lbl119
                                    try {
                                        v5 /* !! */  = response.body();
                                        if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .byteStream()) == null) ** GOTO lbl106
                                        var14_20 = v5 /* !! */ ;
                                        var15_24 = null;
                                        try {
                                            inputStream = (InputStream)var14_20;
                                            $i$a$-use-ConcurrentDownloadSession$processFeed$2$1$1$1 = false;
                                            eTag = Response.header$default(response, "ETag", null, 2, null);
                                            v6 = var7_13.getPrevFeedData().get(var6_9);
                                            prevFeed = v6 != null ? v6.getFeed() : null;
                                            parsedApplicationFeedJSON = var7_13.getApplicationFeedJSONLoader().parse(var6_9.getUrl(), (InputStream)inputStream, eTag);
                                            var7_13.getContext().getStatus().setSuccessful(true);
                                            v7 = prevFeed;
                                            if (v7 != null) {
                                                it = v7;
                                                $i$a$-let-ConcurrentDownloadSession$processFeed$2$1$1$1$prevTime$1 = false;
                                                v8 = ApplicationFeedDownloaderKt.access$parseInstantSafe(it.getItems().getFeedGenerationTime());
                                            } else {
                                                v8 = null;
                                            }
                                            prevTime = v8;
                                            actualTime = ApplicationFeedDownloaderKt.access$parseInstantSafe(parsedApplicationFeedJSON.getFeedGenerationTime());
                                            if (prevTime != null && actualTime != null && prevTime.compareTo(actualTime) > 0) {
                                                Logger.INSTANCE.warn("Server response for " + var6_9.getUrl() + " is outdated: cached generation time [" + prevTime + "], server time [" + actualTime + "]");
                                                v9 = prevFeed;
                                            } else {
                                                v9 = new ParsedFeedInternal(var7_13.getClock().now(), eTag, parsedApplicationFeedJSON);
                                            }
                                            feed = v9;
                                            ConcurrentDownloadSession.access$includeNested(var7_13, var8_11, feed);
                                            inputStream = new FeedResult.OK(var6_9, feed);
                                        }
                                        catch (Throwable $i$a$-use-ConcurrentDownloadSession$processFeed$2$1$1$1) {
                                            var15_24 = $i$a$-use-ConcurrentDownloadSession$processFeed$2$1$1$1;
                                            throw $i$a$-use-ConcurrentDownloadSession$processFeed$2$1$1$1;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)var14_20, (Throwable)var15_24);
                                        }
                                        v10 = (FeedResult)inputStream;
                                        ** GOTO lbl107
lbl106:
                                        // 1 sources

                                        v10 = new FeedResult.NoContent(var6_9);
lbl107:
                                        // 2 sources

                                        var12_47 = v10;
                                    }
                                    catch (Throwable t) {
                                        var25_51 = this;
                                        $i$f$currentCoroutineContext = false;
                                        JobKt.ensureActive((CoroutineContext)this.getContext());
                                        Logger.INSTANCE.warn(t, "Unable to parse feed from '" + var6_9.getUrl() + "': " + t.getMessage());
                                        var12_47 = new FeedResult.Failed(var6_9);
                                    }
                                    v11 = var12_47;
                                    ** GOTO lbl190
lbl119:
                                    // 1 sources

                                    switch (response.code()) {
                                        case 304: {
                                            eTag = Response.header$default(response, "ETag", null, 2, null);
                                            data = var7_13.getPrevFeedData().get(var6_9);
                                            v12 = data;
                                            if (v12 == null || (v12 = v12.toList()) == null) ** GOTO lbl136
                                            $this$firstOrNull$iv = (Iterable)v12;
                                            $i$f$firstOrNull = false;
                                            for (T element$iv : $this$firstOrNull$iv) {
                                                it = (FeedDescriptor)element$iv;
                                                $i$a$-firstOrNull-ConcurrentDownloadSession$processFeed$2$1$1$descriptor$1 = false;
                                                if (!Intrinsics.areEqual((Object)it.getETag(), (Object)eTag)) continue;
                                                v13 = element$iv;
                                                ** GOTO lbl134
                                            }
                                            v13 = null;
lbl134:
                                            // 2 sources

                                            v14 = v13;
                                            ** GOTO lbl137
lbl136:
                                            // 1 sources

                                            v14 = null;
lbl137:
                                            // 2 sources

                                            descriptor = v14;
                                            v15 = data;
                                            v16 = prevFeed = v15 != null ? v15.getFeed() : null;
                                            if (descriptor == null || prevFeed == null) {
                                                Logger.INSTANCE.warn("ETag mismatch " + var6_9.getUrl() + " [" + eTag + "]: " + response.message());
                                                v11 = new FeedResult.Failed(var6_9);
                                                break;
                                            }
                                            if (!Intrinsics.areEqual((Object)prevFeed.getETag(), (Object)eTag)) {
                                                v17 = prevFeed;
                                            } else {
                                                prevTime = ApplicationFeedDownloaderKt.access$parseInstantSafe(prevFeed.getItems().getFeedGenerationTime());
                                                actualTime = descriptor.getFeedGenerationTime();
                                                if (prevTime != null && actualTime != null && prevTime.compareTo(actualTime) < 0) {
                                                    Logger.INSTANCE.warn("Cached feed for " + var6_9.getUrl() + " is outdated, but server eTag matches: " + eTag + ", time: " + Duration.toString-impl((long)var7_13.getClock().now().minus-5sfh64U(startedAt)));
                                                    v17 = prevFeed;
                                                } else {
                                                    Logger.INSTANCE.debug("Use cached feed for " + var6_9.getUrl() + ", eTag matches: " + eTag + ", time: " + Duration.toString-impl((long)var7_13.getClock().now().minus-5sfh64U(startedAt)));
                                                    v17 = new ParsedFeedInternal(var7_13.getClock().now(), eTag, prevFeed.getItems());
                                                }
                                            }
                                            feed = v17;
                                            var7_13.getContext().getStatus().setSuccessful(true);
                                            ConcurrentDownloadSession.access$includeNested(var7_13, var8_11, feed);
                                            v11 = new FeedResult.OK(var6_9, feed);
                                            break;
                                        }
                                        case 451: {
                                            var7_13.getContext().getStatus().setSuppressError(true);
                                            v11 = new FeedResult.Censored(var6_9);
                                            break;
                                        }
                                        default: {
                                            v18 = var7_13.getPrevFeedData().get(var6_9);
                                            v19 = prevFeed = v18 != null ? v18.getFeed() : null;
                                            if (prevFeed != null) {
                                                data = response.code();
                                                v20 = 500 <= data ? data < 600 : false;
                                                if (v20) {
                                                    Logger.INSTANCE.warn("Using previous feed for " + var6_9.getUrl() + " due to server error, code " + response.code());
                                                    v11 = new FeedResult.OK(var6_9, prevFeed);
                                                    break;
                                                }
                                            }
                                            Logger.INSTANCE.warn("Unable to download feed from " + var6_9.getUrl() + ": " + response.message());
                                            if (response.code() == 403 && var6_9.getShouldSkipUpdateWhenUnauthorized()) {
                                                $this$update$iv = var7_13.getStorageManager().getStorage();
                                                $i$f$update = false;
                                                do {
                                                    prevValue$iv = $this$update$iv.getValue();
                                                    it = (Storage)prevValue$iv;
                                                    $i$a$-update-ConcurrentDownloadSession$processFeed$2$1$1$2 = false;
                                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Storage.copy-sSrm3y0$default(it, false, false, null, null, null, null, null, null, false, var7_13.getClock().now().plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS)).toEpochMilliseconds(), false, null, null, false, null, 32255, null))));
                                                v11 = new FeedResult.Forbidden(var6_9);
                                                break;
                                            }
                                            v11 = new FeedResult.Failed(var6_9);
                                        }
                                    }
lbl190:
                                    // 2 sources

                                    var10_16 = v11;
                                }
                                catch (Throwable var11_18) {
                                    var9_15 = var11_18;
                                    throw var11_18;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var5_5 /* !! */ , (Throwable)var9_15);
                                }
                                return var10_16;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super FeedResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var15_9) goto lbl54
lbl53:
                // 1 sources

                return var15_9;
lbl54:
                // 1 sources

                ** GOTO lbl69
            }
            case 2: {
                concurrencyLevel = $continuation.I$2;
                $i$a$-withPermit-ConcurrentDownloadSession$processFeed$2 = $continuation.I$1;
                $i$f$withPermit = $continuation.I$0;
                $this$withPermit$iv = (Semaphore)$continuation.L$5;
                eTags = (String)$continuation.L$4;
                call = (Call)$continuation.L$3;
                request = (Request)$continuation.L$2;
                feedLocation = (FeedLocation)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl69:
                    // 2 sources

                    if ((v2 = (FeedResult)v1) == null) {
                        v2 = new FeedResult.TimedOut(feedLocation);
                    }
                    var11_17 = v2;
                }
                catch (Throwable var12_18) {
                    throw var12_18;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                return var11_17;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void includeNested(CoroutineScope scope2, ParsedFeedInternal feed2) {
        List list2;
        List $this$includeNested_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$includeNested_u24lambda_u240.addAll((Collection)feed2.getItems().getIncludedFeeds());
        if (FeedProperties.get-impl(feed2.getItems().getProperties-Q7u2Iew(), "use_jb_cdn") != null) {
            $this$includeNested_u24lambda_u240.addAll((Collection)this.internalFeedProvider.getInternalFeedLocations());
        }
        List feeds = CollectionsKt.build((List)list2);
        Iterable $this$forEach$iv = feeds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FeedLocation includedFeed = (FeedLocation)element$iv;
            boolean bl2 = false;
            if (this.downloadStarted.contains(includedFeed)) continue;
            this.startDownload(scope2, includedFeed);
        }
    }

    public static final /* synthetic */ Object access$processFeed(ConcurrentDownloadSession $this, CoroutineScope scope2, FeedLocation feedLocation, Request request2, Call call2, String eTags, Continuation $completion) {
        return $this.processFeed(scope2, feedLocation, request2, call2, eTags, (Continuation<? super FeedResult>)$completion);
    }

    public static final /* synthetic */ void access$includeNested(ConcurrentDownloadSession $this, CoroutineScope scope2, ParsedFeedInternal feed2) {
        $this.includeNested(scope2, feed2);
    }
}

