/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.ApplicationFeedJSONLoader;
import com.jetbrains.toolbox.feed.ApplicationPackageType;
import com.jetbrains.toolbox.feed.Capabilities;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.FeedV1Json;
import com.jetbrains.toolbox.feed.JsonFeedParser;
import com.jetbrains.toolbox.feed.LinkUpdater;
import com.jetbrains.toolbox.feed.RawFeedV1Decoder;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.SignatureManager;
import java.io.InputStream;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class ApplicationFeedJSONLoader {
    @NotNull
    private final JsonFeedParser feedParser;
    @NotNull
    private final RawFeedV1Decoder decoder;

    public ApplicationFeedJSONLoader(@NotNull SignatureManager signatures, @NotNull Capabilities capabilities, @NotNull LinkUpdater linkUpdater) {
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)linkUpdater, (String)"linkUpdater");
        this.feedParser = new JsonFeedParser((Function1<? super JsonFeedParser, Unit>)((Function1)arg_0 -> ApplicationFeedJSONLoader.feedParser$lambda$0(capabilities, linkUpdater, arg_0)));
        this.decoder = new RawFeedV1Decoder(signatures, this.feedParser);
    }

    @NotNull
    public final FeedV1Json parse(@NotNull String urlToLog, @NotNull InputStream data2, @Nullable String eTag) {
        Intrinsics.checkNotNullParameter((Object)urlToLog, (String)"urlToLog");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FeedV1Json parsed = this.decoder.decode(data2).getResult();
        Logger.INSTANCE.debug("Parsed feed from " + urlToLog + ": feed generation time: " + parsed.getFeedGenerationTime() + ", eTag: " + eTag + ", includes: " + parsed.getIncludedFeeds().size() + ", items: " + parsed.getFeedItems().size() + ", services: " + parsed.getServices().size() + ", patches: " + parsed.getPatches().size() + ", enterprisePluginHashes for plugins: " + CollectionsKt.joinToString$default((Iterable)parsed.getEnterprisePluginHashes().keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        return parsed;
    }

    public static /* synthetic */ FeedV1Json parse$default(ApplicationFeedJSONLoader applicationFeedJSONLoader, String string, InputStream inputStream, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return applicationFeedJSONLoader.parse(string, inputStream, string2);
    }

    private static final Unit feedParser$lambda$0(Capabilities $capabilities, LinkUpdater $linkUpdater, JsonFeedParser $this$JsonFeedParser) {
        Intrinsics.checkNotNullParameter((Object)$this$JsonFeedParser, (String)"$this$JsonFeedParser");
        $this$JsonFeedParser.setCapabilities($capabilities);
        $this$JsonFeedParser.setOsFilter((Function1<? super String, Boolean>)((Function1)feedParser.1.1.INSTANCE));
        $this$JsonFeedParser.setFeedFilter((Function1<? super RemoteFeedItem, Boolean>)((Function1)ApplicationFeedJSONLoader::feedParser$lambda$0$0));
        $this$JsonFeedParser.setLocationMapper((Function1<? super FeedLocation, FeedLocation>)((Function1)new Function1<FeedLocation, FeedLocation>((Object)$linkUpdater){

            public final FeedLocation invoke(FeedLocation p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LinkUpdater)this.receiver).updateIfNeeded(p0);
            }
        }));
        $this$JsonFeedParser.setFeedMapper((Function1<? super RemoteFeedItem, RemoteFeedItem>)((Function1)new Function1<RemoteFeedItem, RemoteFeedItem>((Object)$linkUpdater){

            public final RemoteFeedItem invoke(RemoteFeedItem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LinkUpdater)this.receiver).updateIfNeeded(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final boolean feedParser$lambda$0$0(RemoteFeedItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPackage().getType() != ApplicationPackageType.Unknown;
    }
}

