/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feature.mcp.ui;

import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import com.jetbrains.toolbox.feature.mcp.config.McpServerTemplate;
import com.jetbrains.toolbox.feature.mcp.config.McpServerTemplateConfig;
import com.jetbrains.toolbox.feature.mcp.config.McpServerTemplateInfo;
import com.jetbrains.toolbox.feature.mcp.config.UserMcpServer;
import com.jetbrains.toolbox.feature.mcp.dxt.DxtServerId;
import com.jetbrains.toolbox.feature.mcp.ui.components.ServersCardsKt;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.ui.components.layout.views.ViewKt;
import com.jetbrains.toolbox.ui.components.layout.views.ViewTitle;
import com.jetbrains.toolbox.ui.rhizome.UiRenderModule;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class McpServerCardScreenRenderer
implements UiRenderModule {
    @Override
    public void render(@NotNull Object[] data2, @Nullable Composer $composer, int $changed) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            $composer = $composer.startRestartGroup(-1832163555);
            ComposerKt.sourceInformation($composer, "C(render):McpServerCardScreenRenderer.kt#7q2fxc");
            int $dirty = $changed;
            $composer.startMovableGroup(227415374, data2.length);
            $dirty |= $composer.changed(data2.length) ? 4 : 0;
            int n = data2.length;
            for (int j = 0; j < n; ++j) {
                Object value2 = data2[j];
                $dirty |= $composer.changedInstance(value2) ? 4 : 0;
            }
            $composer.endMovableGroup();
            if (($dirty & 0xE) == 0) {
                $dirty |= 2;
            }
            if ($composer.shouldExecute(($dirty & 3) != 2, $dirty & 1)) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart(-1832163555, $dirty, -1, "com.jetbrains.toolbox.feature.mcp.ui.McpServerCardScreenRenderer.render (McpServerCardScreenRenderer.kt:19)");
                }
                Object object = data2[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String serverTemplateId = DxtServerId.constructor-impl((String)object);
                Object object2 = data2[1];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean isTemplate = (Boolean)object2;
                if (isTemplate) {
                    $composer.startReplaceGroup(-1539895308);
                    ComposerKt.sourceInformation($composer, "27@1383L454,25@1285L552");
                    McpServerTemplate template = McpServerTemplate.Companion.mcpServerTemplate-S0X3QYU(serverTemplateId);
                    Object object3 = template;
                    if (object3 == null || (object3 = ((McpServerTemplate)object3).getInfo()) == null || (object3 = ((McpServerTemplateInfo)object3).getTitle()) == null) {
                        McpServerTemplate mcpServerTemplate = template;
                        object3 = mcpServerTemplate != null ? mcpServerTemplate.getTemplateId-C0259a0() : "Unknown";
                    }
                    Object name2 = object3;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"title", (Object)name2)};
                    ViewKt.View(new ViewTitle(LocalizableStringExKt.trl("{{title}} MCP server", pairArray), false, null, null, null, null, 62, null), null, null, false, null, null, null, null, (Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit>)((Function3)ComposableLambdaKt.rememberComposableLambda(2074448472, true, (arg_0, arg_1, arg_2) -> McpServerCardScreenRenderer.render$lambda$0(template, arg_0, arg_1, arg_2), $composer, 54)), $composer, 0x6000000, 254);
                    $composer.endReplaceGroup();
                } else {
                    $composer.startReplaceGroup(-1539148301);
                    ComposerKt.sourceInformation($composer, "54@2304L101,52@2206L199");
                    UserMcpServer server = UserMcpServer.Companion.userMcpServer-S0X3QYU(serverTemplateId);
                    if (server == null) {
                        $composer.startReplaceGroup(-1539055146);
                        ComposerKt.sourceInformation($composer, "44@1969L14");
                        ServersCardsKt.NotFoundCard($composer, 0);
                        $composer.endReplaceGroup();
                        $composer.endReplaceGroup();
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
                        if (scopeUpdateScope != null) {
                            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> McpServerCardScreenRenderer.render$lambda$1(this, data2, $changed, arg_0, arg_1)));
                        }
                        return;
                    }
                    $composer.startReplaceGroup(-1541000923);
                    $composer.endReplaceGroup();
                    McpServerTemplate template = server.findTemplate();
                    if (template == null) {
                        String string = "Custom servers not supported yet";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    String string = template.getInfo().getTitle();
                    if (string == null) {
                        string = template.getTemplateId-C0259a0();
                    }
                    String name3 = string;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"title", (Object)name3)};
                    ViewKt.View(new ViewTitle(LocalizableStringExKt.trl("{{title}} MCP server", pairArray), false, null, null, null, null, 62, null), null, null, false, null, null, null, null, (Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit>)((Function3)ComposableLambdaKt.rememberComposableLambda(-2131834769, true, (arg_0, arg_1, arg_2) -> McpServerCardScreenRenderer.render$lambda$2(server, template, arg_0, arg_1, arg_2), $composer, 54)), $composer, 0x6000000, 254);
                    $composer.endReplaceGroup();
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block14;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> McpServerCardScreenRenderer.render$lambda$3(this, data2, $changed, arg_0, arg_1)));
        }
    }

    private static final Unit render$lambda$0(McpServerTemplate $template, ColumnScope $this$View, Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)$this$View, (String)"$this$View");
        ComposerKt.sourceInformation($composer, "C:McpServerCardScreenRenderer.kt#7q2fxc");
        if ($composer.shouldExecute(($changed & 0x11) != 16, $changed & 1)) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart(2074448472, $changed, -1, "com.jetbrains.toolbox.feature.mcp.ui.McpServerCardScreenRenderer.render.<anonymous> (McpServerCardScreenRenderer.kt:28)");
            }
            if ($template == null) {
                $composer.startReplaceGroup(-389959248);
                ComposerKt.sourceInformation($composer, "29@1427L14");
                ServersCardsKt.NotFoundCard($composer, 0);
                $composer.endReplaceGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                return Unit.INSTANCE;
            }
            $composer.startReplaceGroup(-391365718);
            $composer.endReplaceGroup();
            McpServerTemplateConfig templateConfig = $template.getConfig();
            if (templateConfig instanceof McpServerTemplateConfig.Stdio) {
                $composer.startReplaceGroup(-389800249);
                ComposerKt.sourceInformation($composer, "34@1588L73");
                ServersCardsKt.StdioTemplateFullCard-YShVZk0($template.getTemplateId-C0259a0(), $template.getInfo(), (McpServerTemplateConfig.Stdio)templateConfig, $composer, 0);
                $composer.endReplaceGroup();
            } else if (templateConfig instanceof McpServerTemplateConfig.Remote) {
                $composer.startReplaceGroup(-389654456);
                ComposerKt.sourceInformation($composer, "37@1735L72");
                ServersCardsKt.HttpTemplateFullCard-YShVZk0($template.getTemplateId-C0259a0(), $template.getInfo(), (McpServerTemplateConfig.Remote)templateConfig, $composer, 0);
                $composer.endReplaceGroup();
            } else {
                $composer.startReplaceGroup(680159763);
                $composer.endReplaceGroup();
                throw new NoWhenBranchMatchedException();
            }
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
        } else {
            $composer.skipToGroupEnd();
        }
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$1(McpServerCardScreenRenderer $tmp0_rcvr, Object[] $data, int $$changed, Composer $composer, int $force) {
        $tmp0_rcvr.render($data, $composer, RecomposeScopeImplKt.updateChangedFlags($$changed | 1));
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2(UserMcpServer $server, McpServerTemplate $template, ColumnScope $this$View, Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)$this$View, (String)"$this$View");
        ComposerKt.sourceInformation($composer, "C55@2314L83:McpServerCardScreenRenderer.kt#7q2fxc");
        if ($composer.shouldExecute(($changed & 0x11) != 16, $changed & 1)) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart(-2131834769, $changed, -1, "com.jetbrains.toolbox.feature.mcp.ui.McpServerCardScreenRenderer.render.<anonymous> (McpServerCardScreenRenderer.kt:55)");
            }
            ServersCardsKt.ServerFullCard($server, $template, $composer, 0);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
        } else {
            $composer.skipToGroupEnd();
        }
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$3(McpServerCardScreenRenderer $tmp2_rcvr, Object[] $data, int $$changed, Composer $composer, int $force) {
        $tmp2_rcvr.render($data, $composer, RecomposeScopeImplKt.updateChangedFlags($$changed | 1));
        return Unit.INSTANCE;
    }
}

