/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feature.mcp.host;

import com.jetbrains.toolbox.feature.mcp.client.McpClient;
import com.jetbrains.toolbox.feature.mcp.client.McpClientConnection;
import com.jetbrains.toolbox.feature.mcp.client.McpClientResource;
import com.jetbrains.toolbox.feature.mcp.client.McpClientTool;
import com.jetbrains.toolbox.feature.mcp.config.UserMcpServer;
import com.jetbrains.toolbox.feature.mcp.host.McpHost;
import com.jetbrains.toolbox.feature.mcp.host.McpHostServerLink;
import fleet.kernel.rete.QueriesKt;
import fleet.kernel.rete.Query;
import io.modelcontextprotocol.kotlin.sdk.Resource;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nquery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 query.kt\ncom/jetbrains/toolbox/feature/mcp/host/QueryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1617#2,9:101\n1869#2:110\n1870#2:112\n1626#2:113\n1#3:111\n*S KotlinDebug\n*F\n+ 1 query.kt\ncom/jetbrains/toolbox/feature/mcp/host/QueryKt\n*L\n91#1:101,9\n91#1:110\n91#1:112\n91#1:113\n91#1:111\n*E\n"})
public final class QueryKt {
    @NotNull
    public static final Query<Object, UserMcpServer> activeUserMcpServers() {
        return QueriesKt.filter(QueriesKt.each(UserMcpServer.Companion), QueryKt::activeUserMcpServers$lambda$0);
    }

    @Nullable
    public static final UserMcpServer userMcpServer(@NotNull McpClientConnection $this$userMcpServer) {
        Intrinsics.checkNotNullParameter((Object)$this$userMcpServer, (String)"<this>");
        McpHostServerLink mcpHostServerLink = McpHostServerLink.Companion.hostServerLink($this$userMcpServer);
        return mcpHostServerLink != null ? mcpHostServerLink.getUserServer() : null;
    }

    @NotNull
    public static final Map<String, McpClientResource> resources(@NotNull McpHost host) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<McpClient> clients = QueryKt.clients(host);
        int disambiguationCounter = 0;
        Map $this$resources_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (McpClient client : clients) {
            for (Resource resource2 : client.getResources()) {
                McpClientResource mcpClientResource;
                McpClientResource existing = (McpClientResource)$this$resources_u24lambda_u240.get(resource2.getUri());
                if (existing == null) {
                    mcpClientResource = $this$resources_u24lambda_u240.put(resource2.getUri(), new McpClientResource(client, resource2));
                    continue;
                }
                int n = disambiguationCounter;
                disambiguationCounter = n + 1;
                int resourceId = n;
                String resourceUri = "jetbrains://mcp/resource/" + resourceId;
                mcpClientResource = $this$resources_u24lambda_u240.put(resourceUri, new McpClientResource(client, resource2));
            }
        }
        return MapsKt.build((Map)map2);
    }

    @NotNull
    public static final Map<String, McpClientTool> tools(@NotNull McpHost host) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<McpClient> clients = QueryKt.clients(host);
        Map $this$tools_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (McpClient entry : clients) {
            for (Tool tool : entry.getTools()) {
                PersistentList<McpClientTool> persistentList = (PersistentList<McpClientTool>)$this$tools_u24lambda_u240.get(tool.getName());
                if (persistentList == null) {
                    persistentList = ExtensionsKt.persistentListOf();
                }
                PersistentList<McpClientTool> existing = persistentList;
                $this$tools_u24lambda_u240.put(tool.getName(), existing.add(new McpClientTool(entry, tool)));
            }
        }
        Map multiMap = MapsKt.build((Map)map2);
        Map $this$tools_u24lambda_u241 = map2 = MapsKt.createMapBuilder();
        boolean bl2 = false;
        for (Map.Entry entry : multiMap.entrySet()) {
            String toolName = (String)entry.getKey();
            PersistentList tools2 = (PersistentList)entry.getValue();
            if (!(!((Collection)tools2).isEmpty())) {
                throw new IllegalStateException("Check failed.");
            }
            if (tools2.size() == 1) {
                if ($this$tools_u24lambda_u241.put(toolName, CollectionsKt.single((List)tools2)) == null) continue;
                throw new IllegalStateException("Check failed.");
            }
            for (McpClientTool clientTool : tools2) {
                String nameWithPrefix = clientTool.getClient().getConnection().getToolNamePrefix() + toolName;
                if (multiMap.containsKey(nameWithPrefix)) {
                    PersistentList persistentList = (PersistentList)multiMap.get(nameWithPrefix);
                    boolean bl3 = persistentList != null ? persistentList.size() == 1 : false;
                    if (bl3) {
                        Logger.INSTANCE.warn("Tool names '" + toolName + "' and '" + nameWithPrefix + "' are already taken. The tool will not be available. Description: " + clientTool.getTool().getDescription());
                        continue;
                    }
                }
                if ($this$tools_u24lambda_u241.put(nameWithPrefix, clientTool) == null) continue;
                throw new IllegalStateException("Check failed.");
            }
        }
        return MapsKt.build((Map)map2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<McpClient> clients(McpHost host) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = McpHostServerLink.Companion.hostServerLinks(host);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            McpClient it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            McpHostServerLink link = (McpHostServerLink)element$iv$iv;
            boolean bl2 = false;
            McpClientConnection mcpClientConnection = link.getClientConnection();
            if ((mcpClientConnection != null ? mcpClientConnection.getClient() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String projectPath-CD0_5dk(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-tools-model-ProjectId$-$this$projectPath$0");
        return string;
    }

    private static final boolean activeUserMcpServers$lambda$0(UserMcpServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isActive();
    }
}

