/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.extension.registration.strategy;

import com.jetbrains.toolbox.extension.registration.strategy.RegistrationStrategy;
import com.jetbrains.toolbox.interop.Win32Registry;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class UpdateRegistryStrategy
implements RegistrationStrategy {
    @NotNull
    private final Win32Registry win32Registry;
    @NotNull
    private final String key;

    public UpdateRegistryStrategy(@NotNull Win32Registry win32Registry, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.win32Registry = win32Registry;
        this.key = key;
    }

    @Override
    public void onRegister(@NotNull Path manifestFile) {
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Logger.INSTANCE.debug("Adding manifest file to the Windows Registry: HKEY_CURRENT_USER\\" + this.key + "='" + manifestFile + "'");
        Win32Registry.writeValue$default(this.win32Registry, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, this.key, "", manifestFile.toString(), false, 16, null);
    }

    @Override
    public void onDeregister(@NotNull Path manifestFile) {
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Logger.INSTANCE.debug("Removing manifest from the Windows Registry: HKEY_CURRENT_USER\\" + this.key);
        this.win32Registry.deleteKeyRecursively(Win32Registry.Hive.HKCU.INSTANCE, this.key);
    }
}

