/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.environment;

import com.jetbrains.toolbox.environment.EnvironmentDescriptorManager;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorProvider;
import com.jetbrains.toolbox.environment.model.EnvironmentDescriptor;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentDescriptorManagerImpl
implements EnvironmentDescriptorManager {
    @NotNull
    private final EnvironmentDescriptorProvider environmentDescriptorProvider;

    public EnvironmentDescriptorManagerImpl(@NotNull EnvironmentDescriptorProvider environmentDescriptorProvider) {
        Intrinsics.checkNotNullParameter((Object)environmentDescriptorProvider, (String)"environmentDescriptorProvider");
        this.environmentDescriptorProvider = environmentDescriptorProvider;
    }

    @Override
    @NotNull
    public StateFlow<EnvironmentDescriptor> getEnvironmentDescriptor() {
        return this.environmentDescriptorProvider.getDescriptor();
    }

    @Override
    @Nullable
    public <R> Object withEnvironmentDescriptor(@NotNull Function1<? super EnvironmentDescriptor, ? extends R> block, @NotNull Continuation<? super R> $completion) {
        return block.invoke(this.environmentDescriptorProvider.getDescriptor().getValue());
    }
}

