/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.settings.vsc;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseVsCodeSettingsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseVsCodeSettingsLocator.kt\ncom/jetbrains/toolbox/enterprise/settings/vsc/EnterpriseVsCodeSettingsLocator\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n*L\n1#1,85:1\n66#2:86\n52#2,4:88\n60#2,10:94\n56#2,3:104\n71#2,3:107\n52#2,4:113\n60#2,10:119\n56#2,18:129\n67#3:87\n68#3:92\n80#3:110\n165#3:111\n81#3:112\n82#3:117\n78#4:93\n46#4:118\n*S KotlinDebug\n*F\n+ 1 EnterpriseVsCodeSettingsLocator.kt\ncom/jetbrains/toolbox/enterprise/settings/vsc/EnterpriseVsCodeSettingsLocator\n*L\n30#1:86\n30#1:88,4\n30#1:94,10\n30#1:104,3\n30#1:107,3\n54#1:113,4\n54#1:119,10\n54#1:129,18\n30#1:87\n30#1:92\n54#1:110\n54#1:111\n54#1:112\n54#1:117\n31#1:93\n55#1:118\n*E\n"})
public final class EnterpriseVsCodeSettingsLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final JsonObject emptySettings;
    @NotNull
    private final String subdirectoryName;
    @NotNull
    private final Path userSettingsPath;
    @NotNull
    private static final Lazy<Json> json$delegate = LazyKt.lazy(EnterpriseVsCodeSettingsLocator::json_delegate$lambda$0);

    private EnterpriseVsCodeSettingsLocator(OS.Type osType, String appType, FileSystem fileSystem) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)osType), (String)"osType");
        Intrinsics.checkNotNullParameter((Object)appType, (String)"appType");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.emptySettings = new JsonObject(MapsKt.emptyMap());
        String string2 = appType;
        if (ApplicationType.equals-impl0(string2, WellKnownApplications.INSTANCE.getVSCode-UtVBrGo())) {
            string = "Code";
        } else if (ApplicationType.equals-impl0(string2, WellKnownApplications.INSTANCE.getVSCodium-UtVBrGo())) {
            string = "VSCodium";
        } else {
            throw new RuntimeException("Unknown VSCode-like app type " + ApplicationType.toString-impl(appType));
        }
        this.subdirectoryName = string;
        this.userSettingsPath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)(switch (WhenMappings.$EnumSwitchMapping$0[osType.ordinal()]) {
            case 1 -> System.getProperty("user.home") + "/Library/Application Support/" + this.subdirectoryName + "/User/settings.json";
            case 2 -> System.getProperty("user.home") + "/.config/" + this.subdirectoryName + "/User/settings.json";
            case 3 -> System.getenv("APPDATA") + "\\" + this.subdirectoryName + "\\User\\settings.json";
            default -> throw new NoWhenBranchMatchedException();
        }), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final JsonObject getCurrentSettings() {
        if (!this.fileSystem.exists(this.userSettingsPath)) {
            return this.emptySettings;
        }
        try {
            JsonObject jsonObject;
            Throwable thrown$iv$iv;
            block18: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.userSettingsPath;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromBufferedSource$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$_get_currentSettings__u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Json json2 = EnterpriseVsCodeSettingsLocator.Companion.getJson();
                    BufferedSource source$iv = $this$_get_currentSettings__u24lambda_u240;
                    boolean $i$f$decodeFromBufferedSource = false;
                    $this$decodeFromBufferedSource$iv.getSerializersModule();
                    JsonObject data2 = (JsonObject)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)JsonObject.Companion.serializer()), (BufferedSource)source$iv);
                    Logger.INSTANCE.debug("Retrieved VsCode settings from file: " + this.userSettingsPath);
                    jsonObject = data2;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        jsonObject = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            JsonObject result$iv$iv = jsonObject;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return result$iv$iv;
            throw throwable;
        }
        catch (SerializationException e) {
            Logger.INSTANCE.warn("Could not decode VsCode settings from '" + this.userSettingsPath + "', reason: " + e.getMessage());
            return this.emptySettings;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Could not read VsCode settings from '" + this.userSettingsPath + "'");
            return this.emptySettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeSettings(@NotNull JsonObject newSettings) {
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block18: {
                void $this$iv;
                FileSystem parent;
                if (!this.fileSystem.exists(this.userSettingsPath) && (parent = this.userSettingsPath.parent()) != null) {
                    this.fileSystem.createDirectories((Path)parent);
                }
                parent = this.fileSystem;
                Path file$iv = this.userSettingsPath;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void value$iv;
                    void $this$encodeToBufferedSink$iv;
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$writeSettings_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Json json2 = EnterpriseVsCodeSettingsLocator.Companion.getJson();
                    JsonObject jsonObject = newSettings;
                    BufferedSink sink$iv = $this$writeSettings_u24lambda_u240;
                    boolean $i$f$encodeToBufferedSink = false;
                    $this$encodeToBufferedSink$iv.getSerializersModule();
                    OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)JsonObject.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Logger.INSTANCE.debug("Saved VsCode settings to '" + this.userSettingsPath + "'");
            return;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Could not write VsCode settings to '" + this.userSettingsPath + "'");
        }
    }

    private static final Json json_delegate$lambda$0() {
        return JsonKt.Json$default(null, EnterpriseVsCodeSettingsLocator::json_delegate$lambda$0$0, (int)1, null);
    }

    private static final Unit json_delegate$lambda$0$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setAllowComments(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    public /* synthetic */ EnterpriseVsCodeSettingsLocator(OS.Type osType, String appType, FileSystem fileSystem, DefaultConstructorMarker $constructor_marker) {
        this(osType, appType, fileSystem);
    }

    public static final class Companion {
        private Companion() {
        }

        private final Json getJson() {
            Lazy lazy = json$delegate;
            return (Json)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

