/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.notifications;

import com.jetbrains.toolbox.enterprise.rest.LoadedPluginInfo;
import com.jetbrains.toolbox.feed.PluginId;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class LoadedPlugins {
    private LoadedPlugins() {
    }

    @Nullable
    public final <T> T mapOrDefault(@Nullable T t2, @NotNull Function1<? super Map<PluginId, LoadedPluginInfo>, ? extends T> operation) {
        Object object;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        LoadedPlugins loadedPlugins = this;
        if (loadedPlugins instanceof Known) {
            object = operation.invoke(((Known)this).getLoadedPlugins());
        } else if (Intrinsics.areEqual((Object)loadedPlugins, (Object)Unknown.INSTANCE)) {
            object = t2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (T)object;
    }

    public /* synthetic */ LoadedPlugins(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Known
    extends LoadedPlugins {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<PluginId, LoadedPluginInfo> loadedPlugins;
        private final long apiVersion;

        public Known(@NotNull Map<PluginId, LoadedPluginInfo> loadedPlugins, long apiVersion) {
            Intrinsics.checkNotNullParameter(loadedPlugins, (String)"loadedPlugins");
            super(null);
            this.loadedPlugins = loadedPlugins;
            this.apiVersion = apiVersion;
        }

        @NotNull
        public final Map<PluginId, LoadedPluginInfo> getLoadedPlugins() {
            return this.loadedPlugins;
        }

        public final long getApiVersion() {
            return this.apiVersion;
        }

        @NotNull
        public String toString() {
            return "Known(loadedPlugins=" + this.loadedPlugins + ", apiVersion=" + this.apiVersion + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.loadedPlugins).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.apiVersion);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Known)) {
                return false;
            }
            Known known = (Known)other;
            if (!Intrinsics.areEqual(this.loadedPlugins, known.loadedPlugins)) {
                return false;
            }
            return this.apiVersion == known.apiVersion;
        }

        @SourceDebugExtension(value={"SMAP\nEnterpriseIntelliJToolLoadedPluginsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseIntelliJToolLoadedPluginsClient.kt\ncom/jetbrains/toolbox/enterprise/notifications/LoadedPlugins$Known$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n463#2:103\n413#2:104\n1252#3,4:105\n*S KotlinDebug\n*F\n+ 1 EnterpriseIntelliJToolLoadedPluginsClient.kt\ncom/jetbrains/toolbox/enterprise/notifications/LoadedPlugins$Known$Companion\n*L\n85#1:103\n85#1:104\n85#1:105,4\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class Unknown
    extends LoadedPlugins {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Unknown";
        }

        public int hashCode() {
            return -951393756;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown cfr_ignored_0 = (Unknown)other;
            return true;
        }
    }
}

