/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.enterprise.configuration.EnterpriseToolInstanceUpdater;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseToolConfigurationStep;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseVmOptionsConfigurationStep;
import com.jetbrains.toolbox.enterprise.rest.VmOptionsV2;
import com.jetbrains.toolbox.enterprise.vmoptions.EnterpriseVmOptionsChangesCalculator;
import com.jetbrains.toolbox.enterprise.vmoptions.EnterpriseVmOptionsManager;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.JobKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseVmOptionsConfigurationStep
implements EnterpriseToolConfigurationStep {
    @NotNull
    private final EnterpriseVmOptionsManager enterpriseVmOptionsManager;
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final VmOptionsV2 vmOptions;
    @NotNull
    private final EnterpriseVmOptionsChangesCalculator.Result vmOptionsChanges;
    @NotNull
    private final EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater;
    @NotNull
    private final LocalizableString displayName;

    public EnterpriseVmOptionsConfigurationStep(@NotNull EnterpriseVmOptionsManager enterpriseVmOptionsManager, @NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull VmOptionsV2 vmOptions, @NotNull EnterpriseVmOptionsChangesCalculator.Result vmOptionsChanges, @NotNull EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater) {
        Intrinsics.checkNotNullParameter((Object)enterpriseVmOptionsManager, (String)"enterpriseVmOptionsManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)vmOptionsChanges, (String)"vmOptionsChanges");
        Intrinsics.checkNotNullParameter((Object)enterpriseToolInstanceUpdater, (String)"enterpriseToolInstanceUpdater");
        this.enterpriseVmOptionsManager = enterpriseVmOptionsManager;
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.vmOptions = vmOptions;
        this.vmOptionsChanges = vmOptionsChanges;
        this.enterpriseToolInstanceUpdater = enterpriseToolInstanceUpdater;
        this.displayName = LocalizableStringExKt.trl("Applying VM options\u2026");
    }

    @Override
    @NotNull
    public LocalizableString getDisplayName() {
        return this.displayName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        block18: {
            block19: {
                if (!($completion instanceof execute.1)) ** GOTO lbl-1000
                var10_3 = $completion;
                if ((var10_3.label & -2147483648) != 0) {
                    var10_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        /* synthetic */ Object result;
                        final /* synthetic */ EnterpriseVmOptionsConfigurationStep this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.execute(null, (Continuation<? super ToolInstance>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
                        if (v0 == null || (v0 = v0.getConfigPath()) == null) {
                            return toolInstance;
                        }
                        configPath = v0;
                        toolName = InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool());
                        result = toolInstance;
                        var6_11 = this.vmOptionsChanges;
                        if (!(var6_11 instanceof EnterpriseVmOptionsChangesCalculator.Result.MissingVmOptionsFile)) ** GOTO lbl22
                        result = this.enterpriseToolInstanceUpdater.updateToolInstanceWithoutEnterpriseVmOptions(result);
                        break block18;
lbl22:
                        // 1 sources

                        if (!(var6_11 instanceof EnterpriseVmOptionsChangesCalculator.Result.Changes)) break;
                        Logger.INSTANCE.info("Applying TBE VM options to " + toolName);
                        v1 = ((EnterpriseVmOptionsChangesCalculator.Result.Changes)this.vmOptionsChanges).getVmOptions();
                        v2 = this.enterpriseConfigManager.getConfig().getValue();
                        Intrinsics.checkNotNull((Object)v2);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configPath);
                        $continuation.L$2 = toolName;
                        $continuation.L$3 = result;
                        $continuation.label = 1;
                        v3 = this.enterpriseVmOptionsManager.applyVmOptions(result, v1, this.vmOptions, ((EnterpriseConfig)v2).getConfigPath(), (Continuation<? super ToolInstance>)$continuation);
                        ** if (v3 != var11_5) goto lbl37
lbl36:
                        // 1 sources

                        return var11_5;
lbl37:
                        // 1 sources

                        ** GOTO lbl47
                    }
                    case 1: {
                        result = (ToolInstance)$continuation.L$3;
                        toolName = (String)$continuation.L$2;
                        configPath = (Path)$continuation.L$1;
                        toolInstance = (ToolInstance)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl47:
                            // 2 sources

                            var7_12 = (ToolInstance)v3;
                        }
                        catch (Exception e) {
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            Logger.INSTANCE.warn((Throwable)e, "Failed to apply TBE VM options for " + toolName);
                            var7_12 = result;
                        }
                        result = var7_12;
                        break block18;
                    }
                }
                if (!(var6_11 instanceof EnterpriseVmOptionsChangesCalculator.Result.ChangesInPredefinedOptions)) break block19;
                Logger.INSTANCE.info("Applying predefined TBE VM options to " + toolName);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configPath);
                $continuation.L$2 = toolName;
                $continuation.L$3 = result;
                $continuation.label = 2;
                v4 = this.enterpriseVmOptionsManager.setPredefinedVmOptions(result, (Path)configPath, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var11_5) goto lbl67
lbl66:
                // 1 sources

                return var11_5;
lbl67:
                // 1 sources

                ** GOTO lbl81
                {
                    case 2: {
                        result = (ToolInstance)$continuation.L$3;
                        toolName = (String)$continuation.L$2;
                        configPath = (Path)$continuation.L$1;
                        toolInstance = (ToolInstance)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
                        }
                        catch (Exception e) {
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            Logger.INSTANCE.warn((Throwable)e, "Failed to apply predefined TBE VM options for " + toolName);
                        }
lbl81:
                        // 3 sources

                        result = this.enterpriseToolInstanceUpdater.updateToolInstanceWithEnterpriseVmOptions(result, this.vmOptions.getEnterpriseVmOptions());
                        break block18;
                    }
                }
            }
            if (var6_11 instanceof EnterpriseVmOptionsChangesCalculator.Result.NoChanges) {
                result = this.enterpriseToolInstanceUpdater.updateToolInstanceWithEnterpriseVmOptions(result, this.vmOptions.getEnterpriseVmOptions());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

