/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseToolConfigurationStep;
import com.jetbrains.toolbox.tools.LaunchRestrictionManager;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseInitialConfigurationEndedStep
implements EnterpriseToolConfigurationStep {
    @NotNull
    private final String channelId;
    @NotNull
    private final LaunchRestrictionManager launchRestrictionManager;

    private EnterpriseInitialConfigurationEndedStep(String channelId, LaunchRestrictionManager launchRestrictionManager) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)launchRestrictionManager, (String)"launchRestrictionManager");
        this.channelId = channelId;
        this.launchRestrictionManager = launchRestrictionManager;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        Logger.INSTANCE.info("Enterprise initial configuration ended for " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
        this.launchRestrictionManager.allowLaunch-R5oYZt4(this.channelId, LaunchRestrictionManager.LaunchProhibitionReason.CONFIGURING_BY_ENTERPRISE);
        return toolInstance;
    }

    public /* synthetic */ EnterpriseInitialConfigurationEndedStep(String channelId, LaunchRestrictionManager launchRestrictionManager, DefaultConstructorMarker $constructor_marker) {
        this(channelId, launchRestrictionManager);
    }
}

