/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.comms;

import com.intellij.station.comms.common.api.ServiceMetaInfo;
import com.jetbrains.toolbox.enterprise.EnterpriseIntelliJAuthManager;
import com.jetbrains.toolbox.enterprise.EnterpriseIntelliJAuthResponse;
import com.jetbrains.toolbox.enterprise.comms.EnterpriseAuthMetaInfo;
import com.jetbrains.toolbox.station.comms.services.DiscoveryService;
import com.jetbrains.toolbox.station.comms.services.IdeConnection;
import com.jetbrains.toolbox.station.comms.services.StationRestServiceHandler;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnterpriseAuthServiceHandler
extends StationRestServiceHandler<EnterpriseAuthMetaInfo.Request, EnterpriseIntelliJAuthResponse> {
    @NotNull
    private final EnterpriseIntelliJAuthManager authManager;

    public EnterpriseAuthServiceHandler(@NotNull DiscoveryService discoveryService, @NotNull EnterpriseIntelliJAuthManager authManager) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)authManager, (String)"authManager");
        super(discoveryService);
        this.authManager = authManager;
    }

    @Override
    @Nullable
    public Object handle(@NotNull EnterpriseAuthMetaInfo.Request request2, @NotNull IdeConnection fromIde, @NotNull Continuation<? super EnterpriseIntelliJAuthResponse> $completion) {
        return this.authManager.grabEnterpriseToken(request2.getRequireNew(), $completion);
    }

    @Override
    @NotNull
    public ServiceMetaInfo<EnterpriseAuthMetaInfo.Request, EnterpriseIntelliJAuthResponse> getMetaInfo() {
        return EnterpriseAuthMetaInfo.INSTANCE;
    }
}

