/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerKt;
import com.jetbrains.toolbox.accounts.ToolboxEnterpriseAccount;
import com.jetbrains.toolbox.accounts.ToolboxEnterpriseAccountProvider;
import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.integration.UrlHandler;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import java.net.URI;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EnterpriseReauthenticationProtocolHandler
implements ProtocolHandler {
    @NotNull
    private final AccountManager accountManager;
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final UrlHandler urlHandler;

    public EnterpriseReauthenticationProtocolHandler(@NotNull AccountManager accountManager, @NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull UrlHandler urlHandler) {
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)urlHandler, (String)"urlHandler");
        this.accountManager = accountManager;
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.urlHandler = urlHandler;
    }

    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((Intrinsics.areEqual((Object)uri.getHost(), (Object)"toolbox") && Intrinsics.areEqual((Object)uri.getPath(), (Object)"/enterprise/reauthenticate") ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        Object object = (EnterpriseConfig)this.enterpriseConfigManager.getConfig().getValue();
        if (object == null || (object = ((EnterpriseConfig)object).getMachineConfig()) == null) {
            return Unit.INSTANCE;
        }
        Object solidConfig = object;
        ToolboxEnterpriseAccountProvider enterpriseAccountProvider = AccountManagerKt.getEnterprise(this.accountManager);
        ToolboxEnterpriseAccount toolboxEnterpriseAccount = (ToolboxEnterpriseAccount)enterpriseAccountProvider.getActiveAccount().getValue();
        boolean bl = toolboxEnterpriseAccount != null ? !toolboxEnterpriseAccount.getExpired() : false;
        if (bl) {
            Logger.INSTANCE.info("The current account is authenticated");
            return Unit.INSTANCE;
        }
        Logger.INSTANCE.info("Initiating authentication process");
        this.urlHandler.openUrl(ToolboxEnterpriseAccountProvider.initiateLogin$default(enterpriseAccountProvider, (TbeMachineConfig)solidConfig, null, 2, null));
        return Unit.INSTANCE;
    }
}

