/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.educational.remdev;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWebsocketBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebsocketBridge.kt\ncom/jetbrains/toolbox/educational/remdev/WebsocketBridge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class WebsocketBridge {
    @Nullable
    private Thread currentTask;
    @Nullable
    private ServerSocket serverSocket;

    /*
     * WARNING - void declaration
     */
    public final int startBridge(@NotNull String relayServer, @NotNull String internalHost) {
        void $this$startBridge_u24lambda_u241;
        Thread thread2;
        Intrinsics.checkNotNullParameter((Object)relayServer, (String)"relayServer");
        Intrinsics.checkNotNullParameter((Object)internalHost, (String)"internalHost");
        Logger.INSTANCE.info("Starting the bridge");
        this.terminate();
        Pair pair = WebsocketBridge.startSocket$default(this, 40022, 0, 2, null);
        ServerSocket socket = (ServerSocket)pair.component1();
        int port = ((Number)pair.component2()).intValue();
        this.serverSocket = socket;
        Thread thread3 = thread2 = new Thread(() -> WebsocketBridge.startBridge$lambda$0(this, relayServer, internalHost));
        WebsocketBridge websocketBridge = this;
        boolean bl = false;
        $this$startBridge_u24lambda_u241.start();
        websocketBridge.currentTask = thread2;
        Thread.sleep(2000L);
        return port;
    }

    public final void terminate() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket != null) {
            serverSocket.close();
        }
        Thread thread2 = this.currentTask;
        if (thread2 != null) {
            thread2.interrupt();
        }
        this.serverSocket = null;
        this.currentTask = null;
    }

    private final Pair<ServerSocket, Integer> startSocket(int startingPort, int maxRange) {
        int port = startingPort;
        ServerSocket socket = null;
        while (socket == null && port - startingPort < maxRange) {
            try {
                socket = new ServerSocket(port);
            }
            catch (BindException e) {
                Logger.INSTANCE.warn("Port " + port + " is not available, trying " + (port + 1) + "...");
                ++port;
            }
        }
        ServerSocket serverSocket = socket;
        if (serverSocket == null) {
            throw new RuntimeException("Unable to allocate a port");
        }
        return new Pair(serverSocket, (Object)port);
    }

    static /* synthetic */ Pair startSocket$default(WebsocketBridge websocketBridge, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 20;
        }
        return websocketBridge.startSocket(n, n2);
    }

    private final WebSocketClient connectToWebsocket(String relayServer, String internalHost, OutputStream outputStream) {
        String uri = relayServer + "/" + internalHost;
        Logger.INSTANCE.info("Connecting to " + uri);
        URI uRI = new URI(uri);
        WebSocketClient wsClient2 = new WebSocketClient(outputStream, uRI){
            final /* synthetic */ OutputStream $outputStream;
            {
                this.$outputStream = $outputStream;
                super($super_call_param$1);
            }

            public void onMessage(ByteBuffer bytes2) {
                Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                this.$outputStream.write(bytes2.array());
                this.$outputStream.flush();
                super.onMessage(bytes2);
            }

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message2) {
            }

            public void onClose(int code, String reason, boolean remote) {
                Logger.INSTANCE.trace("WS client closed");
            }

            public void onError(Exception e) {
                Object[] objectArray = new Object[]{e};
                Logger.INSTANCE.error("WS client error", objectArray);
            }
        };
        wsClient2.connectBlocking();
        return wsClient2;
    }

    private static final void startBridge$lambda$0(WebsocketBridge this$0, String $relayServer, String $internalHost) {
        while (this$0.serverSocket != null) {
            ServerSocket serverSocket = this$0.serverSocket;
            if (serverSocket != null ? serverSocket.isClosed() : false) break;
            try {
                ServerSocket serverSocket2 = this$0.serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket2);
                Socket clientSocket = serverSocket2.accept();
                Logger.INSTANCE.trace("Client connected");
                new Thread(() -> WebsocketBridge.startBridge$lambda$0$0(clientSocket, this$0, $relayServer, $internalHost)).start();
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error(t2, "Connection error");
            }
        }
    }

    private static final void startBridge$lambda$0$0(Socket $clientSocket, WebsocketBridge this$0, String $relayServer, String $internalHost) {
        Logger.INSTANCE.trace("Starting new thread for proxying");
        InputStream inputStream = $clientSocket.getInputStream();
        OutputStream outputStream = $clientSocket.getOutputStream();
        Intrinsics.checkNotNull((Object)outputStream);
        WebSocketClient wsClient2 = this$0.connectToWebsocket($relayServer, $internalHost, outputStream);
        Logger.INSTANCE.trace("Websocket connected");
        byte[] buffer = new byte[1024];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead != -1) {
            try {
                wsClient2.send(ByteBuffer.wrap(buffer, 0, bytesRead));
            }
            catch (WebsocketNotConnectedException e) {
                Logger.INSTANCE.debug("Reconnecting...");
                wsClient2 = this$0.connectToWebsocket($relayServer, $internalHost, outputStream);
                wsClient2.send(ByteBuffer.wrap(buffer, 0, bytesRead));
            }
            catch (Throwable t2) {
                Logger.INSTANCE.warn(t2, "Unexpected bridge error");
            }
            bytesRead = inputStream.read(buffer);
        }
        $clientSocket.close();
        Logger.INSTANCE.trace("Client disconnected: " + $clientSocket.getRemoteSocketAddress());
    }
}

