/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.educational;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.IntelliJToolProperties;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloadData;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloadResult;
import com.jetbrains.toolbox.intellij.plugins.ToolPluginDownloader;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import java.util.Map;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MarketplacePluginLoader {
    @NotNull
    private final ToolPluginDownloader toolPluginDownloader;
    @NotNull
    private final StateFlow<Map<ApplicationType, ToolWithVersions>> availableTools;

    public MarketplacePluginLoader(@NotNull ToolPluginDownloader toolPluginDownloader, @NotNull StateFlow<? extends Map<ApplicationType, ToolWithVersions>> availableTools2) {
        Intrinsics.checkNotNullParameter((Object)toolPluginDownloader, (String)"toolPluginDownloader");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        this.toolPluginDownloader = toolPluginDownloader;
        this.availableTools = availableTools2;
    }

    @Nullable
    public final Object loadLatestCompatiblePlugin-1EbxqOw(@NotNull ToolInstance toolInstance, @NotNull String string, @NotNull String channel, @NotNull Continuation<? super PluginDownloadResult> $completion) {
        Map tools2 = (Map)this.availableTools.getValue();
        ToolWithVersions toolWithVersions = (ToolWithVersions)tools2.get(ApplicationType.box-impl(toolInstance.getTool().getToolId-UtVBrGo()));
        if (toolWithVersions == null) {
            String message2 = "Failed to find tool with `" + ApplicationType.toString-impl(toolInstance.getTool().getToolId-UtVBrGo()) + "` among available tools";
            Logger.INSTANCE.warn(message2);
            return new PluginDownloadResult.Error(message2);
        }
        IntelliJToolProperties intelliJProperties = toolWithVersions.getTool().getIntelliJProperties();
        if (intelliJProperties == null) {
            String message3 = "Loading plugin for non-IntelliJ tools is not supported";
            Logger.INSTANCE.warn(message3);
            return new PluginDownloadResult.Error(message3);
        }
        String productCode = intelliJProperties.getProductCode-fnix534();
        String buildNumber = toolInstance.getTool().getBuildNumber-Y_E1uuk();
        HttpUrl downloadUrl = new HttpUrl.Builder().scheme("https").host("plugins.jetbrains.com").addPathSegment("pluginManager").addQueryParameter("action", "download").addQueryParameter("id", string).addQueryParameter("build", productCode + "-" + buildNumber).addQueryParameter("channel", channel).build();
        return this.toolPluginDownloader.downloadZippedPlugin(new PluginDownloadData(string, downloadUrl, null, null, false, 24, null), null, $completion);
    }
}

