/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.dotDesktopFiles;

import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopFileChannelExtension;
import com.jetbrains.toolbox.dotDesktopFiles.UtilKt;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import java.util.Map;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDotDesktopFileUninstallHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotDesktopFileUninstallHandler.kt\ncom/jetbrains/toolbox/dotDesktopFiles/DotDesktopFileUninstallHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class DotDesktopFileUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final Path dotDesktopFileCommonPath;
    @NotNull
    private final Path dotDesktopIconsCachePath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Function0<Unit> updateIconCache;
    @NotNull
    private final Function1<Path, Unit> updateMimeTypesDb;

    public DotDesktopFileUninstallHandler(@NotNull Path dotDesktopFileCommonPath, @NotNull Path dotDesktopIconsCachePath, @NotNull FileSystem fileSystem, @NotNull Function0<Unit> updateIconCache, @NotNull Function1<? super Path, Unit> updateMimeTypesDb) {
        Intrinsics.checkNotNullParameter((Object)dotDesktopFileCommonPath, (String)"dotDesktopFileCommonPath");
        Intrinsics.checkNotNullParameter((Object)dotDesktopIconsCachePath, (String)"dotDesktopIconsCachePath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(updateIconCache, (String)"updateIconCache");
        Intrinsics.checkNotNullParameter(updateMimeTypesDb, (String)"updateMimeTypesDb");
        this.dotDesktopFileCommonPath = dotDesktopFileCommonPath;
        this.dotDesktopIconsCachePath = dotDesktopIconsCachePath;
        this.fileSystem = fileSystem;
        this.updateIconCache = updateIconCache;
        this.updateMimeTypesDb = updateMimeTypesDb;
    }

    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        DotDesktopFileChannelExtension dotDesktopFileChannelExtension = UtilKt.getDotDesktopFileChannelExtension(toolInstance.getChannel());
        if (dotDesktopFileChannelExtension == null || (dotDesktopFileChannelExtension = dotDesktopFileChannelExtension.getDotDesktopFileName()) == null) {
            return UninstallResult.NotSupported.INSTANCE;
        }
        DotDesktopFileChannelExtension dotDesktopFileName = dotDesktopFileChannelExtension;
        Path dotDesktopFilePath = this.dotDesktopFileCommonPath.resolve((Path)dotDesktopFileName);
        if (this.fileSystem.exists(dotDesktopFilePath)) {
            Path iconPath;
            Map<String, String> dotDesktopFile = UtilKt.parseDotDesktopFile(this.fileSystem, dotDesktopFilePath);
            String string = dotDesktopFile.get("Icon");
            Path path2 = iconPath = string != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
            if (iconPath != null && PathExtensionsKt.contains(this.dotDesktopIconsCachePath, iconPath)) {
                try {
                    this.fileSystem.delete(iconPath);
                    this.updateIconCache.invoke();
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Can't remove icon file: '" + iconPath + "', skipping removing it");
                }
            }
            try {
                this.fileSystem.delete(dotDesktopFilePath);
                if (dotDesktopFile.get("MimeType") != null) {
                    Path path3 = dotDesktopFilePath.parent();
                    if (path3 != null) {
                        Path it = path3;
                        boolean bl = false;
                        this.updateMimeTypesDb.invoke((Object)it);
                    }
                }
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Can't remove desktop file: '" + dotDesktopFilePath + "', skipping removing it");
                return UninstallResult.Success.INSTANCE;
            }
        }
        return UninstallResult.Success.INSTANCE;
    }
}

