/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.diskUsage;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.diskUsage.CategoryDiskUsage;
import com.jetbrains.toolbox.diskUsage.CategoryDiskUsageKt;
import com.jetbrains.toolbox.diskUsage.DirectoryDiskUsage;
import com.jetbrains.toolbox.diskUsage.DiskUsage;
import com.jetbrains.toolbox.diskUsage.DiskUsageManager;
import com.jetbrains.toolbox.diskUsage.DiskUsageManagerImpl;
import com.jetbrains.toolbox.diskUsage.LeftoverIDEDirectoryProvider;
import com.jetbrains.toolbox.diskUsage.LeftoverTool;
import com.jetbrains.toolbox.manager.CacheManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.tools.model.ChannelBackupEntry;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.datetime.Instant;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDiskUsageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskUsageManagerImpl.kt\ncom/jetbrains/toolbox/diskUsage/DiskUsageManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1208#2,2:235\n1236#2,4:237\n1563#2:274\n1634#2,3:275\n1563#2:278\n1634#2,3:279\n1869#2,2:282\n1563#2:296\n1634#2,3:297\n827#2:300\n855#2,2:301\n1869#2,2:303\n1563#2:305\n1634#2,3:306\n1869#2,2:309\n116#3,11:241\n116#3,11:253\n116#3,8:264\n125#3:273\n126#3:284\n116#3,11:285\n375#4:252\n375#4:311\n1#5:272\n*S KotlinDebug\n*F\n+ 1 DiskUsageManagerImpl.kt\ncom/jetbrains/toolbox/diskUsage/DiskUsageManagerImpl\n*L\n60#1:235,2\n60#1:237,4\n139#1:274\n139#1:275,3\n142#1:278\n142#1:279,3\n145#1:282,2\n171#1:296\n171#1:297,3\n173#1:300\n173#1:301,2\n180#1:303,2\n194#1:305\n194#1:306,3\n197#1:309,2\n63#1:241,11\n105#1:253,11\n122#1:264,8\n122#1:273\n122#1:284\n162#1:285,11\n97#1:252\n205#1:311\n*E\n"})
public final class DiskUsageManagerImpl
implements DiskUsageManager {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final LeftoverIDEDirectoryProvider leftoverIDEDirectoryProvider;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final MutableStateFlow<DiskUsageManager.Status> _status;
    @NotNull
    private final StateFlow<DiskUsageManager.Status> status;
    @NotNull
    private final MutableStateFlow<DiskUsage> _state;
    @NotNull
    private final StateFlow<DiskUsage> state;
    @NotNull
    private final Mutex fileSystemOperationLock;
    @NotNull
    private final Map<Path, DirectoryDiskUsage> diskUsageByPath;

    /*
     * WARNING - void declaration
     */
    public DiskUsageManagerImpl(@NotNull FileSystem fileSystem, @NotNull DownloadManager downloadManager, @NotNull LeftoverIDEDirectoryProvider leftoverIDEDirectoryProvider, @NotNull ToolManager toolManager, @NotNull CacheManager<DiskUsage> cacheManager, @NotNull CoroutineScope coroutineScope) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)leftoverIDEDirectoryProvider, (String)"leftoverIDEDirectoryProvider");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter(cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileSystem = fileSystem;
        this.downloadManager = downloadManager;
        this.leftoverIDEDirectoryProvider = leftoverIDEDirectoryProvider;
        this.toolManager = toolManager;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskUsageManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 3 sources

                        while (true) {
                            this.label = 2;
                            v1 = this.this$0.cleanUpDownloadCache(false, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl23
                            break;
                        }
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        this.label = 3;
                        v2 = this.this$0.cleanUpBackups(false, (Continuation<? super Unit>)((Continuation)this));
                        if (v2 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl32
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        this.label = 4;
                        v3 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), (Continuation)((Continuation)this));
                        if (v3 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl40
                    }
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl40:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this._status = StateFlowKt.MutableStateFlow((Object)DiskUsageManager.Status.Idle.INSTANCE);
        this.status = FlowKt.asStateFlow(this._status);
        this._state = cacheManager.getCache();
        this.state = FlowKt.asStateFlow(this._state);
        this.fileSystemOperationLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        Iterable iterable = ((DiskUsage)this._state.getValue()).knownDirectoryDiskUsages();
        DiskUsageManagerImpl diskUsageManagerImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var10_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DirectoryDiskUsage directoryDiskUsage = (DirectoryDiskUsage)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getPath(), element$iv$iv);
        }
        diskUsageManagerImpl.diskUsageByPath = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    private final Path getDownloadCacheDirectory() {
        return this.downloadManager.getDownloadDirectory();
    }

    @Override
    @NotNull
    public StateFlow<DiskUsageManager.Status> getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public StateFlow<DiskUsage> getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object update(boolean ignoreCache, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ DiskUsageManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.update(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.fileSystemOperationLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.Z$0 = ignoreCache;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                ignoreCache = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-DiskUsageManagerImpl$update$2 = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.Z$0 = ignoreCache;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-DiskUsageManagerImpl$update$2;
                $continuation.label = 2;
                v1 = this.updateUnsafe(ignoreCache != false, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var11_5) goto lbl41
lbl40:
                // 1 sources

                return var11_5;
lbl41:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                $i$a$-withLock$default-DiskUsageManagerImpl$update$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                ignoreCache = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl52:
                    // 2 sources

                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var8_13) {
                    throw var8_13;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object updateUnsafe(boolean ignoreCache, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateUnsafe.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ DiskUsageManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DiskUsageManagerImpl.access$updateUnsafe(this.this$0, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this._status.setValue((Object)DiskUsageManager.Status.Scanning.INSTANCE);
                $continuation.Z$0 = ignoreCache;
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, ignoreCache != false, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ DiskUsageManagerImpl this$0;
                    final /* synthetic */ boolean $ignoreCache;
                    {
                        this.this$0 = $receiver;
                        this.$ignoreCache = $ignoreCache;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$coroutineScope;
                                ResultKt.throwOnFailure((Object)$result);
                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$ignoreCache, null){
                                    int label;
                                    final /* synthetic */ DiskUsageManagerImpl this$0;
                                    final /* synthetic */ boolean $ignoreCache;
                                    {
                                        this.this$0 = $receiver;
                                        this.$ignoreCache = $ignoreCache;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                DiskUsage it;
                                                DiskUsage nextValue$iv;
                                                Object prevValue$iv;
                                                ResultKt.throwOnFailure((Object)$result);
                                                DirectoryDiskUsage downloadCacheDiskUsage = DiskUsageManagerImpl.access$getDiskUsage(this.this$0, DiskUsageManagerImpl.access$getDownloadCacheDirectory(this.this$0), this.$ignoreCache);
                                                MutableStateFlow $this$update$iv = DiskUsageManagerImpl.access$get_state$p(this.this$0);
                                                boolean $i$f$update = false;
                                                do {
                                                    prevValue$iv = $this$update$iv.getValue();
                                                    it = (DiskUsage)prevValue$iv;
                                                    boolean bl = false;
                                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = DiskUsage.copy-9_BiRXY$default(it, downloadCacheDiskUsage, null, null, 6, null))));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$ignoreCache, null){
                                    int label;
                                    final /* synthetic */ DiskUsageManagerImpl this$0;
                                    final /* synthetic */ boolean $ignoreCache;
                                    {
                                        this.this$0 = $receiver;
                                        this.$ignoreCache = $ignoreCache;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var35_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                v0 = DiskUsageManagerImpl.access$getLeftoverIDEDirectoryProvider$p(this.this$0).getLeftoverIDEDirectoryPaths((Continuation<? super Map<LeftoverTool, ? extends Set<Path>>>)((Continuation)this));
                                                if (v0 == var35_2) {
                                                    return var35_2;
                                                }
                                                ** GOTO lbl13
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl13:
                                                // 2 sources

                                                var4_4 = leftoverIDEDirectoryPaths = (Map)v0;
                                                var5_5 = this.this$0;
                                                var6_7 = this.$ignoreCache;
                                                $i$f$mapValues = false;
                                                var8_11 = $this$mapValues$iv;
                                                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                                                $i$f$mapValuesTo = false;
                                                var11_15 = $this$mapValuesTo$iv$iv.entrySet();
                                                destination$iv$iv$iv = destination$iv$iv;
                                                $i$f$associateByTo = false;
                                                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                                    var16_20 = (Map.Entry)element$iv$iv$iv;
                                                    var17_21 = destination$iv$iv$iv;
                                                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                                                    var19_23 = (Map.Entry)element$iv$iv$iv;
                                                    var33_37 = it$iv$iv.getKey();
                                                    var32_36 = var17_21;
                                                    $i$a$-mapValues-DiskUsageManagerImpl$updateUnsafe$2$2$leftoverIDEDiskUsage$1 = false;
                                                    directoryDiskUsages = (Set)var19_23.getValue();
                                                    $this$map$iv = directoryDiskUsages;
                                                    $i$f$map = false;
                                                    var24_28 = $this$map$iv;
                                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                    $i$f$mapTo = false;
                                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                        var29_33 = (Path)item$iv$iv;
                                                        var30_34 = destination$iv$iv;
                                                        $i$a$-map-DiskUsageManagerImpl$updateUnsafe$2$2$leftoverIDEDiskUsage$1$1 = false;
                                                        var30_34.add(DiskUsageManagerImpl.access$getDiskUsage(var5_5, (Path)it, var6_7 != false));
                                                    }
                                                    var34_38 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                                    var32_36.put(var33_37, var34_38);
                                                }
                                                leftoverIDEDiskUsage = CategoryDiskUsageKt.toCategoryDiskUsage(destination$iv$iv$iv);
                                                $this$update$iv = DiskUsageManagerImpl.access$get_state$p(this.this$0);
                                                $i$f$update = false;
                                                do {
                                                    prevValue$iv = $this$update$iv.getValue();
                                                    it = (DiskUsage)prevValue$iv;
                                                    $i$a$-update-DiskUsageManagerImpl$updateUnsafe$2$2$1 = false;
                                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = DiskUsage.copy-9_BiRXY$default(it, null, leftoverIDEDiskUsage, null, 5, null))));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$ignoreCache, null){
                                    int label;
                                    final /* synthetic */ DiskUsageManagerImpl this$0;
                                    final /* synthetic */ boolean $ignoreCache;
                                    {
                                        this.this$0 = $receiver;
                                        this.$ignoreCache = $ignoreCache;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                DiskUsage it;
                                                DiskUsage nextValue$iv;
                                                Object prevValue$iv;
                                                void $this$associateByTo$iv$iv$iv;
                                                void $this$mapValuesTo$iv$iv;
                                                void $this$mapValues$iv;
                                                Map.Entry<K, V> entry$iv2;
                                                Map backupPaths;
                                                Map map2;
                                                Object object;
                                                void $this$mapTo$iv$iv;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Map $this$map$iv = (Map)DiskUsageManagerImpl.access$getToolManager$p(this.this$0).getModel().getValue();
                                                boolean $i$f$map = false;
                                                Map map3 = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                                                boolean $i$f$mapTo = false;
                                                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                                                while (iterator2.hasNext()) {
                                                    void $this$mapTo$iv$iv2;
                                                    void $this$map$iv2;
                                                    Map.Entry<K, V> item$iv$iv;
                                                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                                                    object = destination$iv$iv;
                                                    boolean bl = false;
                                                    String channelId = ((ChannelId)entry.getKey()).unbox-impl();
                                                    ChannelState channelState2 = (ChannelState)entry.getValue();
                                                    Iterable iterable = channelState2.getChannel().getBackupOptions().getEntries();
                                                    ChannelId channelId2 = ChannelId.box-impl(channelId);
                                                    boolean $i$f$map2 = false;
                                                    map2 = $this$map$iv2;
                                                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                                    boolean $i$f$mapTo2 = false;
                                                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                                                        void it2;
                                                        ChannelBackupEntry channelBackupEntry = (ChannelBackupEntry)item$iv$iv2;
                                                        Collection collection = destination$iv$iv2;
                                                        boolean bl2 = false;
                                                        collection.add(it2.getDirectory());
                                                    }
                                                    object.add(TuplesKt.to((Object)channelId2, (Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2))));
                                                }
                                                Map $this$filterValues$iv = backupPaths = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                                                boolean $i$f$filterValues22 = false;
                                                LinkedHashMap<K, V> result$iv22 = new LinkedHashMap<K, V>();
                                                for (Map.Entry<K, V> entry$iv2 : $this$filterValues$iv.entrySet()) {
                                                    Set it3 = (Set)entry$iv2.getValue();
                                                    boolean bl = false;
                                                    boolean bl3 = !((Collection)it3).isEmpty();
                                                    if (!bl3) continue;
                                                    result$iv22.put(entry$iv2.getKey(), entry$iv2.getValue());
                                                }
                                                $this$filterValues$iv = result$iv22;
                                                DiskUsageManagerImpl $i$f$filterValues22 = this.this$0;
                                                boolean result$iv22 = this.$ignoreCache;
                                                boolean $i$f$mapValues = false;
                                                entry$iv2 = $this$mapValues$iv;
                                                Map destination$iv$iv3 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                                                boolean $i$f$mapValuesTo = false;
                                                Iterable bl = $this$mapValuesTo$iv$iv.entrySet();
                                                Map destination$iv$iv$iv = destination$iv$iv3;
                                                boolean $i$f$associateByTo = false;
                                                for (E element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                                    void $this$mapTo$iv$iv3;
                                                    void it$iv$iv;
                                                    Map.Entry $i$f$map2 = (Map.Entry)element$iv$iv$iv;
                                                    map2 = destination$iv$iv$iv;
                                                    boolean bl4 = false;
                                                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                                    K k = it$iv$iv.getKey();
                                                    object = map2;
                                                    boolean bl5 = false;
                                                    Set directories = (Set)entry.getValue();
                                                    Iterable $this$map$iv3 = directories;
                                                    boolean $i$f$map3 = false;
                                                    Iterable bl2 = $this$map$iv3;
                                                    Collection destination$iv$iv4 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                                    boolean $i$f$mapTo3 = false;
                                                    for (T item$iv$iv : $this$mapTo$iv$iv3) {
                                                        void it4;
                                                        Path path2 = (Path)item$iv$iv;
                                                        Collection collection = destination$iv$iv4;
                                                        boolean bl6 = false;
                                                        collection.add(DiskUsageManagerImpl.access$getDiskUsage($i$f$filterValues22, (Path)it4, result$iv22));
                                                    }
                                                    Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
                                                    object.put(k, set2);
                                                }
                                                Map<T, Set<DirectoryDiskUsage>> backupDiskUsage = CategoryDiskUsageKt.toCategoryDiskUsage(destination$iv$iv$iv);
                                                MutableStateFlow $this$update$iv = DiskUsageManagerImpl.access$get_state$p(this.this$0);
                                                boolean $i$f$update = false;
                                                do {
                                                    prevValue$iv = $this$update$iv.getValue();
                                                    it = (DiskUsage)prevValue$iv;
                                                    boolean bl7 = false;
                                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = DiskUsage.copy-9_BiRXY$default(it, null, null, backupDiskUsage, 3, null))));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                return Boxing.boxBoolean((boolean)DiskUsageManagerImpl.access$getDiskUsageByPath$p(this.this$0).keySet().retainAll((Collection)((DiskUsage)DiskUsageManagerImpl.access$get_state$p(this.this$0).getValue()).knownDirectoryPaths()));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var7_5) goto lbl20
lbl19:
                // 1 sources

                return var7_5;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                ignoreCache = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    $i$f$currentCoroutineContext = false;
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    Logger.INSTANCE.error((Throwable)e, "Failed to update disk usage");
                    ** GOTO lbl41
                }
lbl27:
                // 2 sources

                this._status.setValue((Object)DiskUsageManager.Status.Idle.INSTANCE);
                ** GOTO lbl41
            }
            {
                finally {
                    this._status.setValue((Object)DiskUsageManager.Status.Idle.INSTANCE);
                }
            }
lbl41:
            // 2 sources

            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object cleanUpDownloadCache(boolean force, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[SWITCH], 12[CASE]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object cleanUpLeftoverDirectories(@Nullable LeftoverTool tool, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE], 8[SWITCH]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object cleanUpBackups(boolean includeOwned, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cleanUpBackups.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ DiskUsageManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cleanUpBackups(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.fileSystemOperationLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.Z$0 = includeOwned;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                includeOwned = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-DiskUsageManagerImpl$cleanUpBackups$2 = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.Z$0 = includeOwned;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-DiskUsageManagerImpl$cleanUpBackups$2;
                $continuation.label = 2;
                v1 = this.cleanUpBackupsUnsafe(includeOwned != false, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var11_5) goto lbl41
lbl40:
                // 1 sources

                return var11_5;
lbl41:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                $i$a$-withLock$default-DiskUsageManagerImpl$cleanUpBackups$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                includeOwned = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.Z$0 = includeOwned;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-DiskUsageManagerImpl$cleanUpBackups$2;
                $continuation.label = 3;
                v2 = this.updateUnsafe(false, (Continuation<? super Unit>)$continuation);
                ** if (v2 != var11_5) goto lbl60
lbl59:
                // 1 sources

                return var11_5;
lbl60:
                // 1 sources

                ** GOTO lbl71
            }
            case 3: {
                $i$a$-withLock$default-DiskUsageManagerImpl$cleanUpBackups$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                includeOwned = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl71:
                    // 2 sources

                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var8_13) {
                    throw var8_13;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object cleanUpBackupsUnsafe(boolean includeOwned, Continuation<? super Unit> $completion) {
        try {
            Collection<FileSize> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List orphanBackupDirectories;
            Object $this$filterNot$iv;
            MutableStateFlow<DiskUsageManager.Status> mutableStateFlow;
            void $this$mapTo$iv$iv2;
            List ownedBackupDiskUsages = CollectionsKt.flatten((Iterable)CategoryDiskUsage.getValues-impl(((DiskUsage)this._state.getValue()).getBackups-fheeFXw()));
            Iterable $this$map$iv2 = ownedBackupDiskUsages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            MutableStateFlow<DiskUsageManager.Status> destination$iv$iv = (MutableStateFlow<DiskUsageManager.Status>)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DirectoryDiskUsage directoryDiskUsage = (DirectoryDiskUsage)item$iv$iv;
                mutableStateFlow = destination$iv$iv;
                boolean bl = false;
                mutableStateFlow.add((DiskUsageManager.Status)it.getPath());
            }
            Set ownedBackupPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List list2 = this.fileSystem.listOrNull(StandardPaths.INSTANCE.getToolboxBackupDir());
            if (list2 != null) {
                void $this$filterNotTo$iv$iv;
                $this$filterNot$iv = list2;
                boolean $i$f$filterNot = false;
                Object object = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl = false;
                    if (ownedBackupPaths.contains(it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                v1 = (List)destination$iv$iv2;
            } else {
                v1 = orphanBackupDirectories = CollectionsKt.emptyList();
            }
            if (!((Collection)orphanBackupDirectories).isEmpty()) {
                this._status.setValue((Object)new DiskUsageManager.Status.Cleaning(DiskUsageManager.Status.Cleaning.Target.BACKUP_DIRECTORIES, orphanBackupDirectories.size(), null, null));
                Iterable $this$forEach$iv = orphanBackupDirectories;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    try {
                        this.fileSystem.deleteRecursively(it);
                    }
                    catch (IOException e) {
                        Logger.INSTANCE.warn("Couldn't delete orphan backup directory '" + it);
                    }
                }
            }
            if (!includeOwned) {
                Unit $this$forEach$iv = Unit.INSTANCE;
                return $this$forEach$iv;
            }
            Iterable $this$forEach$iv = ownedBackupDiskUsages;
            int n = ownedBackupDiskUsages.size();
            DiskUsageManager.Status.Cleaning.Target target = DiskUsageManager.Status.Cleaning.Target.BACKUP_DIRECTORIES;
            mutableStateFlow = this._status;
            boolean $i$f$map2 = false;
            $this$filterNot$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DirectoryDiskUsage bl = (DirectoryDiskUsage)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(FileSize.box-impl(it.getSize-WN0b6rc()));
            }
            collection = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            FileSize fileSize = FileSize.box-impl(FileSystemExtKt.sum((Iterable<FileSize>)collection));
            int n2 = n;
            DiskUsageManager.Status.Cleaning.Target target2 = target;
            mutableStateFlow.setValue((Object)new DiskUsageManager.Status.Cleaning(target2, n2, fileSize, defaultConstructorMarker));
            $this$forEach$iv = ownedBackupDiskUsages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DirectoryDiskUsage backupDiskUsage = (DirectoryDiskUsage)element$iv;
                boolean bl = false;
                try {
                    this.fileSystem.deleteRecursively(backupDiskUsage.getPath());
                }
                catch (IOException e) {
                    Logger.INSTANCE.warn("Couldn't delete backup directory '" + backupDiskUsage.getPath() + "': " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            boolean $i$f$currentCoroutineContext = false;
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            Logger.INSTANCE.error((Throwable)e, "Error while cleaning up backup directories");
        }
        finally {
            this._status.setValue((Object)DiskUsageManager.Status.Idle.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    private final DirectoryDiskUsage getDiskUsage(Path directory, boolean ignoreCache) {
        DirectoryDiskUsage cachedInfo;
        if (!ignoreCache && (cachedInfo = this.diskUsageByPath.get(directory)) != null && Intrinsics.areEqual((Object)this.getLastModified(directory), (Object)cachedInfo.getLastModifiedAt())) {
            Logger.INSTANCE.debug("Skipping not modified directory " + directory);
            return cachedInfo;
        }
        return this.doCalculateAndCacheDiskUsage(directory);
    }

    private final Instant getLastModified(Path path2) {
        Instant instant;
        Object object = this.fileSystem.metadataOrNull(path2);
        if (object != null && (object = object.getLastModifiedAtMillis()) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            instant = Instant.Companion.fromEpochMilliseconds(it);
        } else {
            instant = null;
        }
        return instant;
    }

    private final DirectoryDiskUsage doCalculateAndCacheDiskUsage(Path directory) {
        Logger.INSTANCE.info("Calculating directory size at " + directory);
        long l = FileSystemExtKt.calculateSizeRecursively(this.fileSystem, directory);
        Instant instant = this.getLastModified(directory);
        if (instant == null) {
            instant = Instant.Companion.getDISTANT_PAST();
        }
        DirectoryDiskUsage result2 = new DirectoryDiskUsage(directory, l, instant, null);
        Logger.INSTANCE.info("Calculating directory size at " + directory + " done: " + FileSize.toString-impl(result2.getSize-WN0b6rc()));
        this.diskUsageByPath.put(directory, result2);
        return result2;
    }

    public static final /* synthetic */ Object access$updateUnsafe(DiskUsageManagerImpl $this, boolean ignoreCache, Continuation $completion) {
        return $this.updateUnsafe(ignoreCache, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ DirectoryDiskUsage access$getDiskUsage(DiskUsageManagerImpl $this, Path directory, boolean ignoreCache) {
        return $this.getDiskUsage(directory, ignoreCache);
    }

    public static final /* synthetic */ Path access$getDownloadCacheDirectory(DiskUsageManagerImpl $this) {
        return $this.getDownloadCacheDirectory();
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(DiskUsageManagerImpl $this) {
        return $this._state;
    }

    public static final /* synthetic */ LeftoverIDEDirectoryProvider access$getLeftoverIDEDirectoryProvider$p(DiskUsageManagerImpl $this) {
        return $this.leftoverIDEDirectoryProvider;
    }

    public static final /* synthetic */ ToolManager access$getToolManager$p(DiskUsageManagerImpl $this) {
        return $this.toolManager;
    }

    public static final /* synthetic */ Map access$getDiskUsageByPath$p(DiskUsageManagerImpl $this) {
        return $this.diskUsageByPath;
    }
}

