/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.Point;
import com.jetbrains.toolbox.Rect;
import com.jetbrains.toolbox.Size;
import com.jetbrains.toolbox.desktop.DisplaySize;
import com.jetbrains.toolbox.desktop.WindowsShowPoint;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/jetbrains/toolbox/desktop/UtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n11561#2:130\n11896#2,3:131\n295#3,2:134\n1#4:136\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/jetbrains/toolbox/desktop/UtilKt\n*L\n31#1:130\n31#1:131,3\n34#1:134,2\n*E\n"})
public final class UtilKt {
    @Nullable
    public static final Rect calcScreenRectForPoint(@NotNull Point point) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        DisplaySize displaySize = UtilKt.getDisplaySize(point);
        Rectangle screen = displaySize.component1();
        Insets insets = displaySize.component2();
        Rectangle rectangle = screen;
        if (rectangle != null) {
            Rectangle it = rectangle;
            boolean bl = false;
            rect = new Rect(new Point(it.x + insets.left, it.y + insets.top), new Size(it.width - insets.left - insets.right, it.height - insets.top - insets.bottom));
        } else {
            rect = null;
        }
        Rect screenRect = rect;
        return screenRect;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplaySize getDisplaySize(@NotNull Point location) {
        DisplaySize displaySize;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            Object object;
            Rectangle bounds;
            block10: {
                block9: {
                    GraphicsConfiguration graphicsConfiguration;
                    GraphicsConfiguration graphicsConfiguration2;
                    Object v1;
                    List allScreens;
                    block8: {
                        void $this$mapTo$iv$iv;
                        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                        Intrinsics.checkNotNullExpressionValue((Object)graphicsDeviceArray, (String)"getScreenDevices(...)");
                        Object[] $this$map$iv = graphicsDeviceArray;
                        boolean $i$f$map = false;
                        Object[] objectArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            GraphicsDevice graphicsDevice = (GraphicsDevice)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getDefaultConfiguration());
                        }
                        allScreens = (List)destination$iv$iv;
                        Logger.INSTANCE.info("Available screens " + CollectionsKt.joinToString$default((Iterable)allScreens, null, null, null, (int)0, null, UtilKt::getDisplaySize$lambda$1, (int)31, null));
                        Iterable $this$firstOrNull$iv = allScreens;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            GraphicsConfiguration gc = (GraphicsConfiguration)element$iv;
                            boolean bl = false;
                            if (!gc.getBounds().contains(location.getX(), location.getY())) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    if ((graphicsConfiguration2 = (GraphicsConfiguration)v1) == null) {
                        graphicsConfiguration2 = (GraphicsConfiguration)CollectionsKt.first((List)allScreens);
                    }
                    GraphicsConfiguration graphicsConfiguration3 = graphicsConfiguration = graphicsConfiguration2;
                    bounds = graphicsConfiguration3 != null ? graphicsConfiguration3.getBounds() : null;
                    object = graphicsConfiguration;
                    if (object == null) break block9;
                    GraphicsConfiguration it = object;
                    boolean bl = false;
                    Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(it);
                    object = insets;
                    if (insets != null) break block10;
                }
                object = new Insets(0, 0, 0, 0);
            }
            Object insets = object;
            Logger.INSTANCE.info("Display size " + bounds + " with insets " + (Insets)insets + " for " + location);
            displaySize = new DisplaySize(bounds, (Insets)insets);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Cannot get display size");
            displaySize = new DisplaySize(null, new Insets(0, 0, 0, 0));
        }
        return displaySize;
    }

    @Nullable
    public static final Rect getDisplaySize(@NotNull Point location, boolean includeInsets) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        DisplaySize displaySize = UtilKt.getDisplaySize(location);
        Rectangle rect2 = displaySize.component1();
        Insets displayInsets = displaySize.component2();
        Rectangle rectangle = rect2;
        if (rectangle != null) {
            Insets insets;
            Rectangle it = rectangle;
            boolean bl = false;
            Insets it2 = insets = displayInsets;
            boolean bl2 = false;
            Insets insets2 = !includeInsets ? insets : null;
            if (insets2 == null) {
                insets2 = new Insets(0, 0, 0, 0);
            }
            Insets insets3 = insets2;
            rect = new Rect(it.x + insets3.left, it.y + insets3.top, (int)it.getMaxX() - insets3.right, (int)it.getMaxY() - insets3.bottom);
        } else {
            rect = null;
        }
        return rect;
    }

    @NotNull
    public static final Point getShowPointByInsets() {
        Object object;
        block5: {
            block4: {
                Point point = UtilKt.getMouseLocation();
                if (point == null) {
                    point = Point.Companion.getZero();
                }
                DisplaySize displaySize = UtilKt.getDisplaySize(point);
                Rectangle displaySize2 = displaySize.component1();
                Insets displayInsets = displaySize.component2();
                object = displaySize2;
                if (object == null) break block4;
                Rectangle it = object;
                boolean bl = false;
                WindowsShowPoint showPoint = displayInsets.top > 0 ? WindowsShowPoint.TOP_RIGHT : (displayInsets.bottom > 0 || displayInsets.right > 0 ? WindowsShowPoint.BOTTOM_RIGHT : (displayInsets.left > 0 ? WindowsShowPoint.BOTTOM_LEFT : WindowsShowPoint.BOTTOM_RIGHT));
                Logger.INSTANCE.debug(() -> UtilKt.getShowPointByInsets$lambda$0$0(showPoint));
                Point point2 = showPoint.getOnScreen(it, displayInsets);
                object = point2;
                if (point2 != null) break block5;
            }
            object = Point.Companion.getZero();
        }
        return object;
    }

    @Nullable
    public static final Point getMouseLocation() {
        Point point;
        try {
            Point point2;
            Object object = MouseInfo.getPointerInfo();
            if (object != null && (object = ((PointerInfo)object).getLocation()) != null) {
                Object it = object;
                boolean bl = false;
                point2 = new Point(((java.awt.Point)it).x, ((java.awt.Point)it).y);
            } else {
                point2 = null;
            }
            point = point2;
        }
        catch (Throwable throwable) {
            point = null;
        }
        return point;
    }

    public static final void invokeLaterIfNeeded(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (UtilKt.isHeadless()) {
            Logger.INSTANCE.warn("Skipping action due to headless environment");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            action.invoke();
        } else {
            SwingUtilities.invokeLater(() -> UtilKt.invokeLaterIfNeeded$lambda$0(action));
        }
    }

    public static final boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static final void setAppIcon(@Nullable BufferedImage image) {
        try {
            if (!Taskbar.isTaskbarSupported()) {
                return;
            }
            Taskbar taskbar = Taskbar.getTaskbar();
            if (taskbar.isSupported(Taskbar.Feature.ICON_IMAGE)) {
                taskbar.setIconImage(image);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e);
        }
    }

    private static final CharSequence getDisplaySize$lambda$1(GraphicsConfiguration it) {
        String string = it.getBounds().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getShowPointByInsets$lambda$0$0(WindowsShowPoint $showPoint) {
        return "Tray icon show point: " + $showPoint;
    }

    private static final void invokeLaterIfNeeded$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

