/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.TrayIconRefProvider;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.desktop.GlobalHotkeyHelper;
import com.jetbrains.toolbox.desktop.hotkeys.Hotkey;
import com.jetbrains.toolbox.desktop.hotkeys.PresentersKt;
import com.jetbrains.toolbox.desktop.input.ConversionsKt;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.window.GlobalHotkeyEntity;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import fleet.kernel.rete.QueriesKt;
import fleet.kernel.rete.ReteKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class GlobalHotkeyHelper {
    @NotNull
    public static final GlobalHotkeyHelper INSTANCE = new GlobalHotkeyHelper();
    @NotNull
    private static final Lazy interop$delegate = LazyKt.lazy(GlobalHotkeyHelper::interop_delegate$lambda$0);

    private GlobalHotkeyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object handleGlobalHotkeys(@NotNull StatisticsManager statisticsManager, @NotNull TrayIconRefProvider trayIconRefProvider, @NotNull Continuation<?> $completion) {
        if (!($completion instanceof handleGlobalHotkeys.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ GlobalHotkeyHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleGlobalHotkeys(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Initializing global hotkeys");
                $continuation.L$0 = statisticsManager;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)trayIconRefProvider);
                $continuation.label = 1;
                v0 = FlowExtensionsKt.firstNotNull((Flow)trayIconRefProvider.getTrayIconPtr(), $continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                trayIconRefProvider = (TrayIconRefProvider)$continuation.L$1;
                statisticsManager = (StatisticsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                iconPtr = (Pointer)v0;
                native = this.getInterop().initGlobalHotkey(iconPtr);
                if (native == null) {
                    throw new IllegalStateException("Global hotkey initialization failed".toString());
                }
                callbacks = new HashSet<HotkeyCallback>();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)statisticsManager);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)trayIconRefProvider);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)iconPtr);
                $continuation.L$3 = native;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(callbacks);
                $continuation.label = 2;
                v1 = ReteKt.collect(QueriesKt.query((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleGlobalHotkeys$lambda$0(), ()Ljava/util/Set;)()), (Function3)new Function3<CoroutineScope, Set<? extends GlobalHotkeyEntity>, Continuation<? super Unit>, Object>(native, callbacks, statisticsManager, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Pointer $native;
                    final /* synthetic */ HashSet<HotkeyCallback> $callbacks;
                    final /* synthetic */ StatisticsManager $statisticsManager;
                    {
                        this.$native = $native;
                        this.$callbacks = $callbacks;
                        this.$statisticsManager = $statisticsManager;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        Set set2 = (Set)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$forEach$iv;
                                void hotkeys;
                                ResultKt.throwOnFailure((Object)$result);
                                Logger.INSTANCE.info("Unregistering previous global hotkey");
                                GlobalHotkeyHelper.access$getInterop(GlobalHotkeyHelper.INSTANCE).unregisterGlobalHotkeys(this.$native);
                                this.$callbacks.clear();
                                Iterable iterable = (Iterable)hotkeys;
                                HashSet<HotkeyCallback> hashSet = this.$callbacks;
                                Pointer pointer = this.$native;
                                StatisticsManager statisticsManager = this.$statisticsManager;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    GlobalHotkeyEntity hotkey = (GlobalHotkeyEntity)element$iv;
                                    boolean bl = false;
                                    FusEnums.GlobalShortcutActions fusEntry = hotkey.getFusEntry();
                                    String shortcut = hotkey.getShortcut();
                                    Function0<Unit> callback = hotkey.getCallback();
                                    if (StringsKt.isBlank((CharSequence)shortcut)) {
                                        Logger.INSTANCE.info(() -> handleGlobalHotkeys.3.invokeSuspend$lambda$0$0(fusEntry));
                                        continue;
                                    }
                                    Logger.INSTANCE.info("Registering global hotkey " + shortcut + " for " + fusEntry);
                                    HotkeyCallback nativeCallback = () -> handleGlobalHotkeys.3.invokeSuspend$lambda$0$1(statisticsManager, fusEntry, shortcut, callback);
                                    hashSet.add(nativeCallback);
                                    Hotkey parsedHotkey = PresentersKt.fromString(Hotkey.Companion, shortcut);
                                    if (parsedHotkey != null) {
                                        Logger.INSTANCE.debug("Registering structured hotkey for " + shortcut);
                                        int keyCode = ConversionsKt.toPlatformVirtualKeyCode-_OrBMRk(parsedHotkey.getKey-JStblYU());
                                        int modifiers = ConversionsKt.toPlatformModifiers-bhbtf8A(parsedHotkey.getModifiers-QCdsWFY());
                                        GlobalHotkeyHelper.access$getInterop(GlobalHotkeyHelper.INSTANCE).registerGlobalHotkey(pointer, keyCode, modifiers, nativeCallback);
                                        continue;
                                    }
                                    Logger.INSTANCE.warn("Failed to parse hotkey string: " + shortcut);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Object invoke(CoroutineScope p1, Set<GlobalHotkeyEntity> p2, Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }

                    private static final String invokeSuspend$lambda$0$0(FusEnums.GlobalShortcutActions $fusEntry) {
                        return "Global hotkey for " + $fusEntry + " is not set";
                    }

                    private static final void invokeSuspend$lambda$0$1(StatisticsManager $statisticsManager, FusEnums.GlobalShortcutActions $fusEntry, String $shortcut, Function0 $callback) {
                        $statisticsManager.getLogger().log(Fus.Counters.WindowManagement.INSTANCE.getGlobalShortcut(), $fusEntry, $shortcut);
                        $callback.invoke();
                    }
                }, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var10_6) goto lbl41
lbl40:
                // 1 sources

                return var10_6;
lbl41:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                callbacks = (HashSet<HotkeyCallback>)$continuation.L$4;
                native = (Pointer)$continuation.L$3;
                iconPtr = (Pointer)$continuation.L$2;
                trayIconRefProvider = (TrayIconRefProvider)$continuation.L$1;
                statisticsManager = (StatisticsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)statisticsManager);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)trayIconRefProvider);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)iconPtr);
                $continuation.L$3 = native;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(callbacks);
                $continuation.label = 3;
                v2 = DelayKt.awaitCancellation((Continuation)$continuation);
                ** if (v2 != var10_6) goto lbl61
lbl60:
                // 1 sources

                return var10_6;
lbl61:
                // 1 sources

                ** GOTO lbl72
            }
            case 3: {
                callbacks = (HashSet)$continuation.L$4;
                native = (Pointer)$continuation.L$3;
                iconPtr = (Pointer)$continuation.L$2;
                trayIconRefProvider = (TrayIconRefProvider)$continuation.L$1;
                statisticsManager = (StatisticsManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl72:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
                catch (Throwable var7_12) {
                    Logger.INSTANCE.info("Destroying global hotkeys handler");
                    this.getInterop().destroyGlobalHotkey(native);
                    throw var7_12;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final GlobalHotkeyInterop getInterop() {
        Lazy lazy = interop$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (GlobalHotkeyInterop)object;
    }

    private static final Set handleGlobalHotkeys$lambda$0() {
        return GlobalHotkeyEntity.Companion.all();
    }

    private static final GlobalHotkeyInterop interop_delegate$lambda$0() {
        GlobalHotkeyInterop globalHotkeyInterop;
        try {
            globalHotkeyInterop = (GlobalHotkeyInterop)Native.load((String)"jetbrains-toolbox-interop", GlobalHotkeyInterop.class);
        }
        catch (Throwable e) {
            Logger.INSTANCE.error(e, "Failed to load jetbrains-toolbox-interop");
            globalHotkeyInterop = new GlobalHotkeyInterop(){

                public Pointer initGlobalHotkey(Pointer trayIcon) {
                    Intrinsics.checkNotNullParameter((Object)trayIcon, (String)"trayIcon");
                    return null;
                }

                public void registerGlobalHotkey(Pointer globalHotkeys, int keyCode, int modifiers, HotkeyCallback callback) {
                    Intrinsics.checkNotNullParameter((Object)globalHotkeys, (String)"globalHotkeys");
                    Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                }

                public void unregisterGlobalHotkeys(Pointer globalHotkeys) {
                    Intrinsics.checkNotNullParameter((Object)globalHotkeys, (String)"globalHotkeys");
                }

                public void destroyGlobalHotkey(Pointer globalHotkeys) {
                    Intrinsics.checkNotNullParameter((Object)globalHotkeys, (String)"globalHotkeys");
                }
            };
        }
        return globalHotkeyInterop;
    }

    public static final /* synthetic */ GlobalHotkeyInterop access$getInterop(GlobalHotkeyHelper $this) {
        return $this.getInterop();
    }

    private static interface GlobalHotkeyInterop
    extends Library {
        @Nullable
        public Pointer initGlobalHotkey(@NotNull Pointer var1);

        public void registerGlobalHotkey(@NotNull Pointer var1, int var2, int var3, @NotNull HotkeyCallback var4);

        public void unregisterGlobalHotkeys(@NotNull Pointer var1);

        public void destroyGlobalHotkey(@NotNull Pointer var1);
    }

    public static interface HotkeyCallback
    extends Callback {
    }
}

