/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.desktop.DarwinPThread;
import com.jetbrains.toolbox.desktop.QosClass;
import java.awt.Dimension;
import java.awt.Point;
import java.util.concurrent.CancellationException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nadjustEdtPriority.kt\nKotlin\n*S Kotlin\n*F\n+ 1 adjustEdtPriority.kt\ncom/jetbrains/toolbox/desktop/AdjustEdtPriorityKt\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,91:1\n7#2,7:92\n*S KotlinDebug\n*F\n+ 1 adjustEdtPriority.kt\ncom/jetbrains/toolbox/desktop/AdjustEdtPriorityKt\n*L\n53#1:92,7\n*E\n"})
public final class AdjustEdtPriorityKt {
    private static final void setUserInteractiveQosClassForCurrentThread() {
        block4: {
            Object object;
            boolean $i$f$catching = false;
            try {
                boolean bl = false;
                QosClass qos = QosClass.UserInteractive;
                int ret = DarwinPThread.Companion.getInstance().pthread_set_qos_class_self_np(qos.getPriority$desktop(), 0);
                if (ret != 0) {
                    Thread self = Thread.currentThread();
                    Logger.INSTANCE.warn("Unable to set QoS class " + qos.name() + " for thread #" + self.getId() + " (" + self.getName() + ") (error code: " + ret + ")");
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
            Object object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            Logger.INSTANCE.error((Throwable)it);
        }
    }

    public static final void adjustEdtPriority() {
        SwingUtilities.invokeLater(AdjustEdtPriorityKt::adjustEdtPriority$lambda$0);
    }

    public static final void keepEventQueue(@NotNull CoroutineScope coroutineScope) {
        JFrame jFrame;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        JFrame $this$keepEventQueue_u24lambda_u240 = jFrame = new JFrame();
        boolean bl = false;
        $this$keepEventQueue_u24lambda_u240.setDefaultCloseOperation(1);
        $this$keepEventQueue_u24lambda_u240.setSize(new Dimension(0, 0));
        $this$keepEventQueue_u24lambda_u240.setLocation(new Point(-1000000, -1000000));
        $this$keepEventQueue_u24lambda_u240.setVisible(false);
        JFrame frame = jFrame;
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> AdjustEdtPriorityKt.keepEventQueue$lambda$1(frame, arg_0));
    }

    private static final void adjustEdtPriority$lambda$0() {
        if (OS.INSTANCE.isMac()) {
            AdjustEdtPriorityKt.setUserInteractiveQosClassForCurrentThread();
        } else if (OS.INSTANCE.isWindows()) {
            Thread.currentThread().setPriority(10);
        }
    }

    private static final Unit keepEventQueue$lambda$1(JFrame $frame, Throwable it) {
        $frame.dispose();
        return Unit.INSTANCE;
    }
}

