/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.security;

import com.jetbrains.toolbox.common.security.CloningMessageDigest;
import java.io.Closeable;
import java.security.MessageDigest;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nsha.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sha.kt\ncom/jetbrains/toolbox/common/security/ShaKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n66#2:43\n52#2,4:45\n60#2,10:50\n56#2,3:60\n71#2,3:63\n67#3:44\n68#3:49\n1#4:66\n*S KotlinDebug\n*F\n+ 1 sha.kt\ncom/jetbrains/toolbox/common/security/ShaKt\n*L\n21#1:43\n21#1:45,4\n21#1:50,10\n21#1:60,3\n21#1:63,3\n21#1:44\n21#1:49\n*E\n"})
public final class ShaKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final CloningMessageDigest SHA256$delegate;
    @NotNull
    private static final CloningMessageDigest SHA512$delegate;

    @NotNull
    public static final MessageDigest getSHA256() {
        return SHA256$delegate.getValue(null, $$delegatedProperties[0]);
    }

    @NotNull
    public static final MessageDigest getSHA512() {
        return SHA512$delegate.getValue(null, $$delegatedProperties[1]);
    }

    @NotNull
    public static final byte[] sha256(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        byte[] byArray = ShaKt.getSHA256().digest(data2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] sha256(@NotNull FileSystem $this$sha256, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ShaKt.computeDigest(ShaKt.getSHA256(), $this$sha256, file);
    }

    @NotNull
    public static final byte[] sha512(@NotNull FileSystem $this$sha512, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$sha512, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ShaKt.computeDigest(ShaKt.getSHA512(), $this$sha512, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final byte[] computeDigest(@NotNull MessageDigest $this$computeDigest, @NotNull FileSystem fileSystem, @NotNull Path file) {
        Unit unit;
        Throwable thrown$iv$iv;
        MessageDigest digest;
        block16: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$computeDigest, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            byte[] buffer = new byte[0x100000];
            digest = $this$computeDigest;
            FileSystem fileSystem2 = fileSystem;
            Path file$iv = file;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                int bytesRead;
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$computeDigest_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                while ((bytesRead = $this$computeDigest_u24lambda_u240.read(buffer)) > 0) {
                    digest.update(buffer, 0, bytesRead);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final String sha256base64(@NotNull String $this$sha256base64) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256base64, (String)"<this>");
        String string = $this$sha256base64;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = ShaKt.sha256(byArray);
        return Base64.encode$default((Base64)Base64.Default.getUrlSafe(), (byte[])hash, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String fingerprint(@NotNull byte[] bytes2) {
        void $this$fingerprint_u24lambda_u240;
        HexFormat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        HexFormat.Builder builder2 = builder = new HexFormat.Builder();
        byte[] byArray = bytes2;
        boolean bl = false;
        $this$fingerprint_u24lambda_u240.setUpperCase(true);
        HexFormat.BytesHexFormat.Builder $this$fingerprint_u24lambda_u240_u240 = $this$fingerprint_u24lambda_u240.getBytes();
        boolean bl2 = false;
        $this$fingerprint_u24lambda_u240_u240.setByteSeparator(" ");
        return HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)builder.build());
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(ShaKt.class, "SHA256", "getSHA256()Ljava/security/MessageDigest;", 1))), Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(ShaKt.class, "SHA512", "getSHA512()Ljava/security/MessageDigest;", 1)))};
        $$delegatedProperties = kPropertyArray;
        SHA256$delegate = new CloningMessageDigest("SHA-256");
        SHA512$delegate = new CloningMessageDigest("SHA-512");
    }
}

