/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.platform;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SystemRequirements {
    public long getCpuCores();

    public long getTotalMemoryBytes();

    public long getFreeDiskSpaceBytes();

    public static final class Remote
    implements SystemRequirements {
        @NotNull
        public static final Remote INSTANCE = new Remote();
        private static final long cpuCores = 4L;
        private static final long totalMemoryBytes = 0x200000000L;
        private static final long freeDiskSpaceBytes = 0x280000000L;

        private Remote() {
        }

        @Override
        public long getCpuCores() {
            return cpuCores;
        }

        @Override
        public long getTotalMemoryBytes() {
            return totalMemoryBytes;
        }

        @Override
        public long getFreeDiskSpaceBytes() {
            return freeDiskSpaceBytes;
        }

        @NotNull
        public String toString() {
            return "Remote";
        }

        public int hashCode() {
            return -902820835;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Remote)) {
                return false;
            }
            Remote cfr_ignored_0 = (Remote)other;
            return true;
        }
    }
}

