/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.mime;

import com.jetbrains.toolbox.common.mime.DefaultMediaTypesKt;
import com.jetbrains.toolbox.common.mime.FileNameMatcher;
import com.jetbrains.toolbox.common.mime.MediaType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileMatcherManager {
    @NotNull
    public static final FileMatcherManager INSTANCE = new FileMatcherManager();
    @NotNull
    private static final Map<String, MediaType> extensionCache = new LinkedHashMap();
    @NotNull
    private static final Map<String, MediaType> nameCache = new LinkedHashMap();
    @NotNull
    private static final Map<String, MediaType> nameWithoutExtensionCache = new LinkedHashMap();

    private FileMatcherManager() {
    }

    @Nullable
    public final MediaType getMediaType(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MediaType mediaType = extensionCache.get(StringsKt.substringAfterLast((String)file.name(), (char)'.', (String)""));
        if (mediaType == null && (mediaType = nameCache.get(file.name())) == null) {
            mediaType = nameWithoutExtensionCache.get(StringsKt.substringBeforeLast$default((String)file.name(), (char)'.', null, (int)2, null));
        }
        return mediaType;
    }

    public final void registerMediaTypeFileMatchers$common(@NotNull FileNameMatcher[] fileNameMatchers, @NotNull MediaType mediaType, int priority) {
        Intrinsics.checkNotNullParameter((Object)fileNameMatchers, (String)"fileNameMatchers");
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        for (FileNameMatcher fileNameMatcher : fileNameMatchers) {
            FileNameMatcher fileNameMatcher2 = fileNameMatcher;
            if (fileNameMatcher2 instanceof FileNameMatcher.Extension) {
                extensionCache.put(((FileNameMatcher.Extension)fileNameMatcher).getExtension(), mediaType);
                continue;
            }
            if (fileNameMatcher2 instanceof FileNameMatcher.Name) {
                nameCache.put(((FileNameMatcher.Name)fileNameMatcher).getFileName(), mediaType);
                continue;
            }
            if (fileNameMatcher2 instanceof FileNameMatcher.NameWithoutExtension) {
                nameWithoutExtensionCache.put(((FileNameMatcher.NameWithoutExtension)fileNameMatcher).getNameWithoutExtension(), mediaType);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    static {
        DefaultMediaTypesKt.initDefaultNameMatchers(INSTANCE);
    }
}

