/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public abstract class Compressor
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BiPredicate<? super String, ? super Path> myFilter;

    protected Compressor() {
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file, long timestamp2) {
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String cleanedName = Compressor.Companion.sanitizeEntryName(entryName);
        if (this.accept(cleanedName, file)) {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
            this.addFile(file, basicFileAttributes, cleanedName, timestamp2);
        }
    }

    public static /* synthetic */ void addFile$default(Compressor compressor, String string, Path path2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFile");
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        compressor.addFile(string, path2, l);
    }

    public final void addFile(@NotNull String entryName, @NotNull byte[] content2, long timestamp2) {
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String cleanedName = Compressor.Companion.sanitizeEntryName(entryName);
        if (this.accept(cleanedName, null)) {
            this.writeFileEntry(cleanedName, new ByteArrayInputStream(content2), content2.length, Compressor.Companion.timestamp(timestamp2), 0, null);
        }
    }

    public static /* synthetic */ void addFile$default(Compressor compressor, String string, byte[] byArray, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFile");
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        compressor.addFile(string, byArray, l);
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content2, long timestamp2) {
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String cleanedName = Compressor.Companion.sanitizeEntryName(entryName);
        if (this.accept(cleanedName, null)) {
            this.writeFileEntry(cleanedName, content2, -1L, Compressor.Companion.timestamp(timestamp2), 0, null);
        }
    }

    public final void addDirectory(@NotNull String entryName, long timestamp2) {
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        String cleanedName = Compressor.Companion.sanitizeEntryName(entryName);
        if (this.accept(cleanedName, null)) {
            this.writeDirectoryEntry(cleanedName, Compressor.Companion.timestamp(timestamp2));
        }
    }

    public final void addDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Compressor.addDirectory$default(this, "", directory, 0L, 4, null);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory, long timestampInMillis) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.addRecursively(((CharSequence)prefix).length() == 0 ? "" : Compressor.Companion.sanitizeEntryName(prefix), directory, timestampInMillis);
    }

    public static /* synthetic */ void addDirectory$default(Compressor compressor, String string, Path path2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDirectory");
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        compressor.addDirectory(string, path2, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean accept(String entryName, Path file) {
        if (this.myFilter == null) return true;
        BiPredicate<? super String, ? super Path> biPredicate = this.myFilter;
        Intrinsics.checkNotNull(biPredicate);
        if (!biPredicate.test(entryName, file)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(Path file, BasicFileAttributes attrs, String name2, long explicitTimestamp) {
        Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream source = (InputStream)closeable;
            boolean bl = false;
            long timestamp2 = explicitTimestamp == -1L ? attrs.lastModifiedTime().toMillis() : explicitTimestamp;
            String symlinkTarget = attrs.isSymbolicLink() ? ((Object)Files.readSymbolicLink(file)).toString() : null;
            Intrinsics.checkNotNull((Object)source);
            this.writeFileEntry(name2, source, attrs.size(), timestamp2, Compressor.Companion.mode(file), symlinkTarget);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addRecursively(String prefix, Path root, long timestampMs) {
        boolean traceEnabled = Logger.INSTANCE.isTraceEnabled();
        if (traceEnabled) {
            Logger.INSTANCE.trace("dir=" + root + " prefix=" + prefix);
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(root, prefix, this, traceEnabled, timestampMs){
            final /* synthetic */ Path $root;
            final /* synthetic */ String $prefix;
            final /* synthetic */ Compressor this$0;
            final /* synthetic */ boolean $traceEnabled;
            final /* synthetic */ long $timestampMs;
            {
                this.$root = $root;
                this.$prefix = $prefix;
                this.this$0 = $receiver;
                this.$traceEnabled = $traceEnabled;
                this.$timestampMs = $timestampMs;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                FileVisitResult fileVisitResult;
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                String name2 = dir == this.$root ? this.$prefix : this.entryName(dir);
                if (((CharSequence)name2).length() == 0) {
                    fileVisitResult = FileVisitResult.CONTINUE;
                } else if (Compressor.access$accept(this.this$0, name2, dir)) {
                    if (this.$traceEnabled) {
                        Logger.INSTANCE.trace("  " + dir + " -> " + name2 + "/");
                    }
                    this.this$0.writeDirectoryEntry(name2, this.$timestampMs == -1L ? attrs.lastModifiedTime().toMillis() : this.$timestampMs);
                    fileVisitResult = FileVisitResult.CONTINUE;
                } else {
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                }
                return fileVisitResult;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                String name2 = this.entryName(file);
                if (Compressor.access$accept(this.this$0, name2, file)) {
                    if (this.$traceEnabled) {
                        Logger.INSTANCE.trace("  " + file + " -> " + name2 + (String)(attrs.isSymbolicLink() ? " symlink" : " size=" + attrs.size()));
                    }
                    Compressor.access$addFile(this.this$0, file, attrs, name2, this.$timestampMs);
                }
                return FileVisitResult.CONTINUE;
            }

            private final String entryName(Path fileOrDir) {
                String relativeName = com.jetbrains.toolbox.common.io.Compressor$Companion.access$sanitizeEntryName(Compressor.Companion, ((Object)this.$root.relativize(fileOrDir)).toString());
                return ((CharSequence)this.$prefix).length() == 0 ? relativeName : this.$prefix + "/" + relativeName;
            }
        });
        Logger.INSTANCE.trace(".");
    }

    protected abstract void writeDirectoryEntry(@NotNull String var1, long var2);

    protected abstract void writeFileEntry(@NotNull String var1, @NotNull InputStream var2, long var3, long var5, int var7, @Nullable String var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAllFromZip(@NotNull InputStream inputStream, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Closeable closeable = new ZipInputStream(inputStream);
        Throwable throwable = null;
        try {
            ZipInputStream zipStream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                char[] cArray = new char[]{'/', '\\'};
                String path2 = StringsKt.trim((String)string, (char[])cArray);
                if (StringsKt.contains$default((CharSequence)path2, (CharSequence)"..", (boolean)false, (int)2, null)) continue;
                String[] stringArray = new String[]{path2};
                String newEntryName = StringsKt.replace$default((String)((Object)Path.of(prefix, stringArray)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                long entryTime = entry.getLastModifiedTime().toMillis();
                if (entry.isDirectory()) {
                    this.addDirectory(newEntryName, entryTime);
                } else {
                    this.addFile(newEntryName, zipStream, entryTime);
                }
                entry = zipStream.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ boolean access$accept(Compressor $this, String entryName, Path file) {
        return $this.accept(entryName, file);
    }

    public static final /* synthetic */ void access$addFile(Compressor $this, Path file, BasicFileAttributes attrs, String name2, long explicitTimestamp) {
        $this.addFile(file, attrs, name2, explicitTimestamp);
    }

    @SourceDebugExtension(value={"SMAP\nZipCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipCompressor.kt\ncom/jetbrains/toolbox/common/io/Compressor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1#2:220\n1803#3,3:221\n*S KotlinDebug\n*F\n+ 1 ZipCompressor.kt\ncom/jetbrains/toolbox/common/io/Compressor$Companion\n*L\n187#1:221,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String sanitizeEntryName(String name2) {
            char[] cArray = new char[]{'/'};
            String entryName = StringsKt.trim((String)StringsKt.replace$default((String)name2, (char)'\\', (char)'/', (boolean)false, (int)4, null), (char[])cArray);
            if (!(((CharSequence)entryName).length() > 0)) {
                boolean bl = false;
                String string = "Invalid entry name: " + name2;
                throw new IllegalArgumentException(string.toString());
            }
            return entryName;
        }

        private final long timestamp(long timestamp2) {
            return timestamp2 == -1L ? System.currentTimeMillis() : timestamp2;
        }

        /*
         * WARNING - void declaration
         */
        private final int mode(Path file) {
            PosixFileAttributeView attrs = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                void $this$fold$iv;
                Set<PosixFilePermission> set2 = attrs.readAttributes().permissions();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"permissions(...)");
                Iterable iterable = set2;
                int initial$iv = 0;
                boolean $i$f$fold = false;
                int accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void b;
                    PosixFilePermission posixFilePermission = (PosixFilePermission)((Object)element$iv);
                    int a = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = a | 1 << 8 - b.ordinal();
                }
                return accumulator$iv;
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Zip
    extends Compressor {
        @NotNull
        private final ZipOutputStream myStream;

        private Zip(ZipOutputStream myStream) {
            this.myStream = myStream;
        }

        public Zip(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this(new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]))));
        }

        public Zip(@NotNull OutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            this(new ZipOutputStream(stream));
        }

        @NotNull
        public final Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        @Override
        protected void writeDirectoryEntry(@NotNull String name2, long timestamp2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ZipEntry e = new ZipEntry(name2 + "/");
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp2);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(@NotNull String name2, @NotNull InputStream source, long length, long timestamp2, int mode, @Nullable String symlinkTarget) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            ZipEntry e = new ZipEntry(name2);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp2);
            this.myStream.putNextEntry(e);
            if (length != 0L) {
                ByteStreamsKt.copyTo$default((InputStream)source, (OutputStream)this.myStream, (int)0, (int)2, null);
            }
            this.myStream.closeEntry();
        }

        @Override
        public void close() {
            this.myStream.close();
        }
    }
}

