/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.ai;

import com.jetbrains.toolbox.common.ai.TextGenerationSpeed$;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.DurationSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
public final class TextGenerationSpeed
implements Comparable<TextGenerationSpeed> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double characters;
    private final long observation;
    private final double charactersPerSecond;
    private final double charactersPerMillisecond;
    @NotNull
    private static final TextGenerationSpeed ZERO = new TextGenerationSpeed(0.0, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MILLISECONDS), null);

    private TextGenerationSpeed(double characters, long observation) {
        this.characters = characters;
        this.observation = observation;
        this.charactersPerSecond = this.characters / Duration.toDouble-impl((long)this.observation, (DurationUnit)DurationUnit.SECONDS);
        this.charactersPerMillisecond = this.characters / Duration.toDouble-impl((long)this.observation, (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public final double per-LRDsOJo(long l) {
        return Duration.toDouble-impl((long)l, (DurationUnit)DurationUnit.SECONDS) * this.charactersPerSecond;
    }

    public final long per-5sfh64U(int characters) {
        return DurationKt.toDuration((double)((double)characters / this.charactersPerSecond), (DurationUnit)DurationUnit.SECONDS);
    }

    @NotNull
    public final TextGenerationSpeed times(double multiplier) {
        return new TextGenerationSpeed(this.characters * multiplier, Duration.times-UwyO8pc((long)this.observation, (double)multiplier), null);
    }

    @NotNull
    public final TextGenerationSpeed plus(@NotNull TextGenerationSpeed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TextGenerationSpeed(this.characters + other.characters, Duration.plus-LRDsOJo((long)this.observation, (long)other.observation), null);
    }

    @Override
    public int compareTo(@NotNull TextGenerationSpeed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Double.compare(this.charactersPerSecond, other.charactersPerSecond);
    }

    @NotNull
    public String toString() {
        return "TextGenerationSpeed(characters=" + this.characters + ", charactersPerSecond=" + this.charactersPerSecond + ", observation=" + Duration.toString-impl((long)this.observation) + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.characters);
        result2 = result2 * 31 + Duration.hashCode-impl((long)this.observation);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextGenerationSpeed)) {
            return false;
        }
        TextGenerationSpeed textGenerationSpeed = (TextGenerationSpeed)other;
        if (Double.compare(this.characters, textGenerationSpeed.characters) != 0) {
            return false;
        }
        return Duration.equals-impl0((long)this.observation, (long)textGenerationSpeed.observation);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$common(TextGenerationSpeed self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeDoubleElement(serialDesc, 0, self.characters);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)DurationSerializer.INSTANCE, (Object)Duration.box-impl((long)self.observation));
    }

    private /* synthetic */ TextGenerationSpeed(int seen0, double characters, Duration observation, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.characters = characters;
        this.observation = observation.unbox-impl();
        this.charactersPerSecond = this.characters / Duration.toDouble-impl((long)this.observation, (DurationUnit)DurationUnit.SECONDS);
        this.charactersPerMillisecond = this.characters / Duration.toDouble-impl((long)this.observation, (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public /* synthetic */ TextGenerationSpeed(double characters, long observation, DefaultConstructorMarker $constructor_marker) {
        this(characters, observation);
    }

    public /* synthetic */ TextGenerationSpeed(int seen0, double characters, Duration observation, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
        this(seen0, characters, observation, serializationConstructorMarker);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextGenerationSpeed getZERO() {
            return ZERO;
        }

        @NotNull
        public final TextGenerationSpeed calculate-dWUq8MI(@NotNull String text2, long l, @Nullable TextGenerationSpeed previous, double weight) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            TextGenerationSpeed current = new TextGenerationSpeed(text2.length(), l, null);
            return previous == null ? current : previous.times(weight).plus(current);
        }

        @NotNull
        public final KSerializer<TextGenerationSpeed> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

