/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.core.ConfigurationParser;
import org.tinylog.core.TinylogLoggingProvider;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.ContextProvider;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.writers.Writer;

public class ToolboxLoggingProvider
implements LoggingProvider {
    private final TinylogLoggingProvider original = new TinylogLoggingProvider();
    private final Map<String, Level> customLevels = ConfigurationParser.getCustomLevels();
    @NotNull
    private Level myLevel = ConfigurationParser.parse((String)Configuration.get((String)"toolboxLevel"), (Level)Level.INFO);

    @NotNull
    public Level getLevel() {
        return this.myLevel;
    }

    public void setLevel(Level myLevel) {
        this.myLevel = myLevel;
    }

    public Level getMinimumLevel() {
        return Level.TRACE;
    }

    public Level getMinimumLevel(String tag) {
        return Level.TRACE;
    }

    public ContextProvider getContextProvider() {
        return this.original.getContextProvider();
    }

    public boolean isEnabled(int depth, String tag, Level level) {
        Level activeLevel = this.customLevels.isEmpty() ? this.myLevel : this.getLevel(RuntimeProvider.getCallerClassName((int)(depth + 1)));
        return activeLevel.ordinal() <= level.ordinal();
    }

    public Writer[] getConfiguredWritersForDefaultTagAndErrorLevel(int tagIndex, @NotNull Level logLevel) throws NoSuchFieldException, IllegalAccessException {
        Field writersField = TinylogLoggingProvider.class.getDeclaredField("writers");
        writersField.setAccessible(true);
        Collection[][] writers = (Collection[][])writersField.get(this.original);
        if (writers == null) {
            throw new IllegalStateException("No tags are configured");
        }
        if (tagIndex >= writers.length) {
            throw new IllegalStateException("Tag index " + tagIndex + "is out of bounds for " + writers.length + " tags");
        }
        Collection[] writerByTag = writers[tagIndex];
        if (writerByTag == null || writerByTag.length == 0) {
            throw new IllegalStateException("Tag " + tagIndex + " is not configured");
        }
        Collection errorWriterCollection = writerByTag[logLevel.ordinal()];
        return errorWriterCollection.toArray(new Writer[0]);
    }

    private Level getLevel(String className) {
        Level customLevel;
        String key = className;
        while ((customLevel = this.customLevels.get(key)) == null) {
            int index = key.lastIndexOf(46);
            if (index == -1) {
                return this.myLevel;
            }
            key = key.substring(0, index);
        }
        return customLevel;
    }

    public void log(int depth, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        if (this.isEnabled(depth + 1, tag, level)) {
            this.original.log(depth + 1, tag, level, exception, formatter, obj, arguments);
        }
    }

    public void log(String loggerClassName, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        if (this.isEnabled(1, tag, level)) {
            this.original.log(loggerClassName, tag, level, exception, formatter, obj, arguments);
        }
    }

    public void shutdown() throws InterruptedException {
        this.original.shutdown();
    }
}

