/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.common.StateMachineImpl;
import com.jetbrains.toolbox.common.Transition;
import com.jetbrains.toolbox.common.TransitionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

public interface StateMachine<State, Event, QueueableEvent extends Event, MultiQueueableEvent extends QueueableEvent> {
    @NotNull
    public StateFlow<State> getState();

    @NotNull
    public SharedFlow<TransitionEvent<State, Event>> getEvents();

    public void process(@NotNull Event var1);

    public void queue(@NotNull QueueableEvent var1);

    @SourceDebugExtension(value={"SMAP\nStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachine.kt\ncom/jetbrains/toolbox/common/StateMachine$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
    public static final class Builder<State, Event, QueueableEvent extends Event, MultiQueueableEvent extends QueueableEvent> {
        @NotNull
        private final State initialState;
        @NotNull
        private final KClass<? extends MultiQueueableEvent> multiQueueableEventClass;
        @NotNull
        private final Map<KClass<? extends State>, Map<KClass<? extends Event>, Transition<State, Event, State>>> transitions;

        @PublishedApi
        public Builder(@NotNull State initialState, @NotNull KClass<? extends MultiQueueableEvent> multiQueueableEventClass) {
            Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
            Intrinsics.checkNotNullParameter(multiQueueableEventClass, (String)"multiQueueableEventClass");
            this.initialState = initialState;
            this.multiQueueableEventClass = multiQueueableEventClass;
            this.transitions = new LinkedHashMap();
        }

        @PublishedApi
        @NotNull
        public final StateMachine<State, Event, QueueableEvent, MultiQueueableEvent> build() {
            return new StateMachineImpl(this.transitions, this.initialState, this.multiQueueableEventClass);
        }

        @PublishedApi
        public final <S extends State> void state(@NotNull KClass<S> stateType, @NotNull Function1<? super StateBuilder<S, State, Event>, Unit> builder) {
            Intrinsics.checkNotNullParameter(stateType, (String)"stateType");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            if (!(!this.transitions.keySet().contains(stateType))) {
                boolean bl = false;
                String string = "State " + stateType.getSimpleName() + " is already defined";
                throw new IllegalStateException(string.toString());
            }
            Map map2 = new LinkedHashMap();
            this.transitions.put(stateType, map2);
            StateBuilder stateBuilder = new StateBuilder(stateType, map2);
            builder.invoke(stateBuilder);
        }
    }

    @SourceDebugExtension(value={"SMAP\nStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachine.kt\ncom/jetbrains/toolbox/common/StateMachine$StateBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
    public static final class StateBuilder<Source extends State, State, Event> {
        @NotNull
        private final KClass<Source> sourceType;
        @NotNull
        private final Map<KClass<? extends Event>, Transition<State, Event, State>> transitions;

        public StateBuilder(@NotNull KClass<Source> sourceType, @NotNull Map<KClass<? extends Event>, Transition<State, Event, State>> transitions2) {
            Intrinsics.checkNotNullParameter(sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter(transitions2, (String)"transitions");
            this.sourceType = sourceType;
            this.transitions = transitions2;
        }

        @PublishedApi
        public final <E extends Event> void on(@NotNull KClass<E> eventType, @NotNull Function2<? super Source, ? super E, ? extends State> transit) {
            Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
            Intrinsics.checkNotNullParameter(transit, (String)"transit");
            if (!(!this.transitions.keySet().contains(eventType))) {
                boolean bl = false;
                String string = "Transition from " + this.sourceType.getSimpleName() + " on " + eventType.getSimpleName() + " is already defined";
                throw new IllegalStateException(string.toString());
            }
            this.transitions.put(eventType, new Transition<Source, E, State>(transit));
        }
    }
}

