/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.ActionProgress;
import com.jetbrains.toolbox.common.Progress;
import com.jetbrains.toolbox.common.ProgressState;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nActionProgress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionProgress.kt\ncom/jetbrains/toolbox/common/ActionProgress\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,147:1\n230#2,5:148\n230#2,5:153\n230#2,5:158\n230#2,5:163\n230#2,5:168\n230#2,5:173\n230#2,5:178\n*S KotlinDebug\n*F\n+ 1 ActionProgress.kt\ncom/jetbrains/toolbox/common/ActionProgress\n*L\n76#1:148,5\n81#1:153,5\n87#1:158,5\n93#1:163,5\n99#1:168,5\n126#1:173,5\n144#1:178,5\n*E\n"})
public final class ActionProgress
implements Progress,
AutoCloseable {
    private final int id;
    @NotNull
    private final Lazy uniqueId$delegate;
    @NotNull
    private final MutableStateFlow<Float> _value;
    @NotNull
    private final StateFlow<Float> value;
    @NotNull
    private final MutableStateFlow<ProgressState> _state;
    @NotNull
    private final StateFlow<ProgressState> state;
    @NotNull
    private AtomicLong myCurrent;

    public ActionProgress(int id, @NotNull LocalizableString title2, @NotNull Progress.ProgressType type2, boolean cancelable, long totalSteps) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.id = id;
        this.uniqueId$delegate = LazyKt.lazy(ActionProgress::uniqueId_delegate$lambda$0);
        this._value = StateFlowKt.MutableStateFlow((Object)Float.valueOf(0.0f));
        this.value = FlowKt.asStateFlow(this._value);
        this._state = StateFlowKt.MutableStateFlow((Object)new ProgressState(title2, type2, totalSteps, cancelable, false, null, false, 112, null));
        this.state = FlowKt.asStateFlow(this._state);
        this.myCurrent = new AtomicLong(0L);
    }

    public /* synthetic */ ActionProgress(int n, LocalizableString localizableString, Progress.ProgressType progressType, boolean bl, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            progressType = Progress.ProgressType.NORMAL;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            l = 1L;
        }
        this(n, localizableString, progressType, bl, l);
    }

    public final int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public StateFlow<Float> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public StateFlow<ProgressState> getState() {
        return this.state;
    }

    public final long getCurrentStep() {
        return this.myCurrent.get();
    }

    public final long getTotalSteps() {
        return ((ProgressState)this.getState().getValue()).getTotalSteps();
    }

    @Override
    public void cancel(@NotNull LocalizableString title2) {
        ProgressState it;
        ProgressState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        MutableStateFlow<ProgressState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (ProgressState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, title2, null, 0L, false, true, null, false, 110, null))));
    }

    public final void reset(@NotNull Progress.ProgressType type2, long totalSteps, @NotNull LocalizableString title2, boolean cancelable) {
        ProgressState it;
        ProgressState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Logger.INSTANCE.info("Progress: " + LocalizableStringExKt.getRawValue(title2));
        this.myCurrent.set(0L);
        MutableStateFlow<ProgressState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (ProgressState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, title2, type2, totalSteps, cancelable, false, null, false, 112, null))));
        this.onProgress();
    }

    public final void update(@NotNull LocalizableString title2, boolean cancelable) {
        ProgressState it;
        ProgressState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Logger.INSTANCE.info("Progress: " + LocalizableStringExKt.getRawValue(title2));
        MutableStateFlow<ProgressState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (ProgressState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, title2, null, 0L, cancelable, false, null, false, 118, null))));
        this.onProgress();
    }

    public static /* synthetic */ void update$default(ActionProgress actionProgress, LocalizableString localizableString, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        actionProgress.update(localizableString, bl);
    }

    public final void totalSteps(long totalSteps) {
        if (totalSteps > 0L) {
            ProgressState it;
            ProgressState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<ProgressState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (ProgressState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, null, null, totalSteps, false, false, null, false, 123, null))));
            this.onProgress();
        }
    }

    public final void advance(long steps) {
        if (steps > 0L) {
            long current = this.myCurrent.addAndGet(steps);
            if (current > this.getTotalSteps()) {
                this.myCurrent.set(this.getTotalSteps());
            }
            this.onProgress();
        }
    }

    public final void update(long step) {
        long current = this.myCurrent.get();
        if (step > current) {
            this.myCurrent.compareAndSet(current, step);
            if (step > this.getTotalSteps()) {
                this.myCurrent.set(this.getTotalSteps());
            }
            this.onProgress();
        }
    }

    public final void error(@NotNull LocalizableString error2) {
        ProgressState it;
        ProgressState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        MutableStateFlow<ProgressState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (ProgressState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, null, null, 0L, false, false, error2, false, 95, null))));
        this.onProgress();
    }

    private final void onProgress() {
        if (this.getTotalSteps() > 0L) {
            this._value.tryEmit((Object)Float.valueOf(1.0f * (float)this.myCurrent.get() / (float)this.getTotalSteps()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object onCanceled(@NotNull Function1<? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onCanceled.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ActionProgress this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onCanceled(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = block;
                $continuation.label = 1;
                v0 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)this.getState()), (Function2)((Function2)new Function2<ProgressState, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        ProgressState progressState = (ProgressState)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((!it.isCanceled() || !it.isFinished() ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(ProgressState p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                block = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((ProgressState)this.getState().getValue()).isCanceled()) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)block);
                $continuation.label = 2;
                v1 = block.invoke((Object)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                block = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close() {
        ProgressState it;
        ProgressState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProgressState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (ProgressState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ProgressState.copy$default(it, null, null, 0L, false, false, null, true, 63, null))));
    }

    private static final Uuid uniqueId_delegate$lambda$0() {
        return Uuid.Companion.random();
    }
}

