/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.ui.widgets;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import com.jetbrains.toolbox.platform.llm.endpoints.interactiveRequests.InteractiveRequestedField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RequestedFieldControlDescriptor<T extends InteractiveRequestedField, V> {
    @NotNull
    private final T field;
    @NotNull
    private final Function1<V, String> validator;
    @NotNull
    private final MutableState<V> valueState;
    @NotNull
    private final MutableState<Function1<V, String>> validatorState;

    public RequestedFieldControlDescriptor(@NotNull T field, V defaultValue, @NotNull Function1<? super V, String> validator) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        this.field = field;
        this.validator = validator;
        this.valueState = SnapshotStateKt.mutableStateOf$default(defaultValue, null, 2, null);
        this.validatorState = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
    }

    public /* synthetic */ RequestedFieldControlDescriptor(InteractiveRequestedField interactiveRequestedField, Object object, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(interactiveRequestedField, object, function1);
    }

    @NotNull
    public final T getField() {
        return this.field;
    }

    @NotNull
    public final MutableState<V> getValueState() {
        return this.valueState;
    }

    @NotNull
    public final MutableState<Function1<V, String>> getValidatorState() {
        return this.validatorState;
    }

    public final void enableValidating() {
        this.validatorState.setValue(this.validator);
    }

    @Nullable
    public final String validate() {
        Function1<V, String> function1 = this.validatorState.getValue();
        return function1 != null ? (String)function1.invoke(this.valueState.getValue()) : null;
    }
}

