/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.ui;

import com.jetbrains.toolbox.ai.chat.ui.QuickAIChatService;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.desktop.TrayMenuExtraItem;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.manager.StatisticsManager;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class AiChatTrayMenuItem
implements TrayMenuExtraItem {
    @NotNull
    private final QuickAIChatService aiChatService;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final LocalizableString name;
    public static final int $stable = 8;

    public AiChatTrayMenuItem(@NotNull QuickAIChatService aiChatService, @NotNull StatisticsManager statisticsManager) {
        Intrinsics.checkNotNullParameter((Object)aiChatService, (String)"aiChatService");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        this.aiChatService = aiChatService;
        this.statisticsManager = statisticsManager;
        this.name = LocalizableStringExKt.trl("Open Quick Access");
    }

    @Override
    @NotNull
    public LocalizableString getName() {
        return this.name;
    }

    @Override
    public boolean getAvailable() {
        return this.aiChatService.isQuickChatEnabled();
    }

    @Override
    public void run() {
        this.aiChatService.showSpotlightPopup();
        this.statisticsManager.getLogger().log(Fus.Counters.WindowManagement.INSTANCE.getTrayIconAction(), FusEnums.TrayIconActions.CONTEXT_OPEN_QUICK_ACCESS);
    }
}

