/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.agentNetworkApiUtils;

import com.jetbrains.toolbox.agentNetworkApiUtils.AgentNetworkApiInfoProvider$VersionNumber$;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AgentNetworkApiInfoProvider {
    @NotNull
    public VersionNumber getVersion();

    @NotNull
    public VersionNumber getMinimalVersion();

    @Serializable
    public static final class VersionNumber
    implements Comparable<VersionNumber> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int number;
        @NotNull
        private final String date;
        @Nullable
        private final String agentVersion;

        public VersionNumber(int number, @NotNull String date, @Nullable String agentVersion) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.number = number;
            this.date = date;
            this.agentVersion = agentVersion;
        }

        public final int getNumber() {
            return this.number;
        }

        @Nullable
        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @NotNull
        public final String toUserFriendlyString() {
            return this.number + "-" + this.date + "-" + this.agentVersion;
        }

        @Override
        public int compareTo(@NotNull VersionNumber other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.number, (int)other.number);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof VersionNumber && Intrinsics.areEqual((Object)((VersionNumber)other).agentVersion, (Object)this.agentVersion);
        }

        public int hashCode() {
            int result2 = this.number;
            result2 = 31 * result2 + this.date.hashCode();
            String string = this.agentVersion;
            result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
            return result2;
        }

        @NotNull
        public final VersionNumber copy(int number, @NotNull String date, @Nullable String agentVersion) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new VersionNumber(number, date, agentVersion);
        }

        public static /* synthetic */ VersionNumber copy$default(VersionNumber versionNumber, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = versionNumber.number;
            }
            if ((n2 & 2) != 0) {
                string = versionNumber.date;
            }
            if ((n2 & 4) != 0) {
                string2 = versionNumber.agentVersion;
            }
            return versionNumber.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "VersionNumber(number=" + this.number + ", date=" + this.date + ", agentVersion=" + this.agentVersion + ")";
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$agent_network_api_utils(VersionNumber self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeIntElement(serialDesc, 0, self.number);
            output2.encodeStringElement(serialDesc, 1, self.date);
            if (output2.shouldEncodeElementDefault(serialDesc, 2) ? true : self.agentVersion != null) {
                output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.agentVersion);
            }
        }

        public /* synthetic */ VersionNumber(int seen0, int number, String date, String agentVersion, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)VersionNumber$$serializer.INSTANCE.getDescriptor());
            }
            this.number = number;
            this.date = date;
            this.agentVersion = (seen0 & 4) == 0 ? null : agentVersion;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<VersionNumber> serializer() {
                return (KSerializer)VersionNumber$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

