/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.oauth;

import com.jetbrains.toolbox.accounts.AuthConfiguration;
import com.jetbrains.toolbox.accounts.AuthorizationRejectionException;
import com.jetbrains.toolbox.accounts.oauth.InvalidCodeException;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Client;
import com.jetbrains.toolbox.accounts.oauth.OAuth2ClientImpl;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Response;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.common.JsonKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nOAuth2ClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2ClientImpl.kt\ncom/jetbrains/toolbox/accounts/oauth/OAuth2ClientImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 5 ErrorsHelper.kt\ncom/jetbrains/toolbox/ErrorsHelperKt\n*L\n1#1,135:1\n1#2:136\n126#3:137\n153#3,3:138\n126#3:152\n153#3,3:153\n7#4,7:141\n8#5,4:148\n*S KotlinDebug\n*F\n+ 1 OAuth2ClientImpl.kt\ncom/jetbrains/toolbox/accounts/oauth/OAuth2ClientImpl\n*L\n44#1:137\n44#1:138,3\n132#1:152\n132#1:153,3\n122#1:141,7\n126#1:148,4\n*E\n"})
public final class OAuth2ClientImpl
implements OAuth2Client {
    @NotNull
    private final String state;
    @NotNull
    private final String codeVerifier;
    @NotNull
    private final String codeChallenge;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AuthConfiguration authConfiguration;
    @NotNull
    private final String baseUrl;

    public OAuth2ClientImpl(@NotNull String state2, @NotNull String codeVerifier, @NotNull String codeChallenge, @NotNull Clock clock, @NotNull AuthConfiguration authConfiguration, @NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)codeChallenge, (String)"codeChallenge");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)authConfiguration, (String)"authConfiguration");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.state = state2;
        this.codeVerifier = codeVerifier;
        this.codeChallenge = codeChallenge;
        this.clock = clock;
        this.authConfiguration = authConfiguration;
        this.baseUrl = baseUrl;
    }

    public /* synthetic */ OAuth2ClientImpl(String string, String string2, String string3, Clock clock, AuthConfiguration authConfiguration, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string4 = authConfiguration.getBaseUrl();
        }
        this(string, string2, string3, clock, authConfiguration, string4);
    }

    @Override
    @NotNull
    public AuthConfiguration getAuthConfiguration() {
        return this.authConfiguration;
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @NotNull
    public String getAuthUrl() {
        return this.getAuthConfiguration().getAuthUrl() + "?" + this.toQueryString(this.getAuthParams());
    }

    private final Map<String, String> getAuthParams() {
        Map params2;
        block1: {
            params2 = new LinkedHashMap();
            params2.putAll(this.getAuthConfiguration().getAuthParams());
            String string = this.getAuthConfiguration().getRedirectUrl();
            if (string != null) {
                String redirectUri = string;
                boolean bl = false;
                params2.put("redirect_uri", redirectUri);
            }
            params2.put("state", this.state);
            params2.put(this.getAuthConfiguration().getCodeChallengeParamName(), this.codeChallenge);
            String string2 = this.getAuthConfiguration().getCodeChallengeMethod();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            params2.put("code_challenge_method", it);
        }
        return params2;
    }

    /*
     * WARNING - void declaration
     */
    private final String toQueryString(Map<String, String> params2) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = params2;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            collection.add(key + "=" + value2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @Nullable
    public Object fetchFromCode(@NotNull OAuth2Response response2, @NotNull Continuation<? super OAuth2Token> $completion) {
        String it;
        Map map2;
        String responseState = response2.getState();
        if (!Intrinsics.areEqual((Object)responseState, (Object)this.state)) {
            throw new InvalidCodeException("Incorrect OAuth2 state provided: expected `" + this.state + "` got `" + responseState + "`");
        }
        String error2 = response2.getError();
        String errorDescription = response2.getErrorDescription();
        CharSequence charSequence = error2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            if (Intrinsics.areEqual((Object)error2, (Object)"user has rejected the consent") || Intrinsics.areEqual((Object)errorDescription, (Object)"Scope request was rejected")) {
                throw new AuthorizationRejectionException("The authorization request was rejected. You are not logged in");
            }
            throw new IllegalStateException((errorDescription + ": " + response2.getErrorHint()).toString());
        }
        String string = response2.getCode();
        if (string == null) {
            throw new IllegalStateException("OAuth2 code is missing".toString());
        }
        String code = string;
        String responseRedirectUri = response2.getRedirectUri();
        String redirectUri = this.getAuthConfiguration().getRedirectUrl();
        if (responseRedirectUri != null && !Intrinsics.areEqual((Object)redirectUri, (Object)responseRedirectUri)) {
            throw new AuthorizationRejectionException("Invalid redirect was provided: " + responseRedirectUri);
        }
        Map $this$fetchFromCode_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        String string2 = this.getAuthConfiguration().getAuthHeader();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            $this$fetchFromCode_u24lambda_u240.put("Authorization", it);
        }
        String string3 = this.getAuthConfiguration().getRequestId();
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            $this$fetchFromCode_u24lambda_u240.put("X-Request-Id", it);
        }
        Map headers2 = MapsKt.build((Map)map2);
        return this.getToken(this.tokenParams(code), this.getAuthConfiguration().getTokenUrl(), headers2, $completion);
    }

    private final Map<String, String> tokenParams(String code) {
        Map params2;
        block0: {
            params2 = new LinkedHashMap();
            params2.putAll(this.getAuthConfiguration().getTokenParams());
            params2.put(this.getAuthConfiguration().getVerifierParamName(), this.codeVerifier);
            params2.put("code", code);
            params2.put("state", this.state);
            String string = this.getAuthConfiguration().getRedirectUrl();
            if (string == null) break block0;
            String redirectUri = string;
            boolean bl = false;
            params2.put("redirect_uri", redirectUri);
        }
        return params2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getToken(Map<String, String> data, String url, Map<String, String> headers, Continuation<? super OAuth2Token> $completion) {
        if (!($completion instanceof getToken.1)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ OAuth2ClientImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OAuth2ClientImpl.access$getToken(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                expirationNow = this.clock.now();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(data);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)headers);
                $continuation.L$3 = expirationNow;
                $continuation.label = 1;
                v0 = this.makeHttpRequest(url, data, headers, (Continuation<? super JsonObject>)$continuation);
                if (v0 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                expirationNow = (Instant)$continuation.L$3;
                headers = (Map)$continuation.L$2;
                url = (String)$continuation.L$1;
                data = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if (((Map)(json = (JsonObject)v0)).containsKey("error")) {
                    throw new IllegalStateException(("Failed to refresh OAuth2 token: " + JsonKt.asString$default((JsonElement)json.get((Object)"error"), null, 1, null)).toString());
                }
                v1 = result = (OAuth2Token)JsonKt.getJsonx().decodeFromJsonElement((DeserializationStrategy)OAuth2Token.Companion.serializer(), (JsonElement)json);
                v2 = null;
                v3 = null;
                v4 = null;
                v5 = null;
                v6 = null;
                v7 = null;
                v8 = null;
                v9 = null;
                v10 = null;
                v11 = result.getExpiresIn-FghU774();
                if (v11 != null) {
                    var8_11 = v11.unbox-impl();
                    var20_12 = v10;
                    var19_13 = v9;
                    var18_14 = v8;
                    var17_15 = v7;
                    var16_16 = v6;
                    var15_17 = v5;
                    var14_18 = v4;
                    var13_19 = v3;
                    var12_20 = v2;
                    var11_21 = v1;
                    $i$a$-let-OAuth2ClientImpl$getToken$2 = false;
                    var21_23 = expirationNow.plus-LRDsOJo((long)it);
                    v1 = var11_21;
                    v2 = var12_20;
                    v3 = var13_19;
                    v4 = var14_18;
                    v5 = var15_17;
                    v6 = var16_16;
                    v7 = var17_15;
                    v8 = var18_14;
                    v9 = var19_13;
                    v10 = var20_12;
                    v12 = var21_23;
                } else {
                    v12 = null;
                }
                return OAuth2Token.copy-I-hR9vI$default(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v12, null, 1535, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object makeHttpRequest(String url, Map<String, String> data, Map<String, String> headers, Continuation<? super JsonObject> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject toJsonObject(Map<String, String> $this$toJsonObject) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$toJsonObject;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)JsonElementKt.JsonPrimitive((String)((String)it.getValue()))));
        }
        Map map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return new JsonObject(map3);
    }

    private static final String makeHttpRequest$lambda$0(String $error) {
        return $error;
    }

    public static final /* synthetic */ Object access$getToken(OAuth2ClientImpl $this, Map data2, String url, Map headers2, Continuation $completion) {
        return $this.getToken(data2, url, headers2, (Continuation<? super OAuth2Token>)$completion);
    }

    public static final /* synthetic */ Object access$makeHttpRequest(OAuth2ClientImpl $this, String url, Map data2, Map headers2, Continuation $completion) {
        return $this.makeHttpRequest(url, data2, headers2, (Continuation<? super JsonObject>)$completion);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContentType.values().length];
            try {
                nArray[ContentType.FORM_URL_ENCODED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentType.JSON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

