/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.enterprise;

import com.jetbrains.toolbox.accounts.OAuthSecureToken;
import com.jetbrains.toolbox.accounts.RefreshConfigurationImpl;
import com.jetbrains.toolbox.accounts.ToolboxEnterpriseAccount;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.accounts.oauth.OAuthTokenRefresherImpl;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolboxEnterpriseTokenRefresher
extends OAuthTokenRefresherImpl<ToolboxEnterpriseAccount, OAuthSecureToken> {
    public ToolboxEnterpriseTokenRefresher(@NotNull BasicDownloadManager downloadManager, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super("JetBrains IDE Services", downloadManager, clock);
    }

    @Override
    @NotNull
    protected RefreshConfiguration createRefreshConfiguration(@NotNull ToolboxEnterpriseAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        String string = account2.getTbeServerUrl() + "/api/login/refresh";
        Map map2 = MapsKt.emptyMap();
        ContentType contentType = ContentType.JSON;
        return new RefreshConfigurationImpl(string, map2, null, contentType, false, 16, null);
    }

    @Override
    @NotNull
    protected OAuthSecureToken updateToken(@NotNull OAuthSecureToken previousToken, @NotNull OAuth2Token newToken2, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)previousToken, (String)"previousToken");
        Intrinsics.checkNotNullParameter((Object)newToken2, (String)"newToken");
        return previousToken.updateFrom(newToken2);
    }
}

