/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.OAuthSecureToken$;
import com.jetbrains.toolbox.accounts.SecureAccountToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.serialization.InstantAsEpochSecondsSerializer;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SourceDebugExtension(value={"SMAP\nSecureAccountToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureAccountToken.kt\ncom/jetbrains/toolbox/accounts/OAuthSecureToken\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class OAuthSecureToken
extends SecureAccountToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @NotNull
    private final String refreshToken;
    @Nullable
    private final String scope;
    @NotNull
    private final String tokenType;
    @Nullable
    private final Instant expiresAt;
    @Nullable
    private final String idToken;

    public OAuthSecureToken(@NotNull String accessToken2, @NotNull String refreshToken, @Nullable String scope2, @NotNull String tokenType, @Nullable Instant expiresAt) {
        Intrinsics.checkNotNullParameter((Object)accessToken2, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        super(null);
        this.accessToken = accessToken2;
        this.refreshToken = refreshToken;
        this.scope = scope2;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
    }

    @Override
    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    @NotNull
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @NotNull
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @Nullable
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public OAuthSecureToken(@NotNull OAuth2Token oAuth2Token) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Token, (String)"oAuth2Token");
        OAuthSecureToken oAuthSecureToken = this;
        String string = oAuth2Token.getAccessToken();
        if (string == null) {
            OAuthSecureToken oAuthSecureToken2 = oAuthSecureToken;
            boolean $i$a$-requireNotNull-OAuthSecureToken$42 = false;
            OAuthSecureToken oAuthSecureToken3 = oAuthSecureToken2;
            String $i$a$-requireNotNull-OAuthSecureToken$42 = "accessToken is missing but required by https://www.rfc-editor.org/rfc/rfc6749.html#section-5.1";
            throw new IllegalArgumentException($i$a$-requireNotNull-OAuthSecureToken$42.toString());
        }
        String string2 = oAuth2Token.getRefreshToken();
        if (string2 == null) {
            String string3 = string;
            OAuthSecureToken oAuthSecureToken4 = oAuthSecureToken;
            boolean $i$a$-requireNotNull-OAuthSecureToken$52 = false;
            String string4 = "refreshToken is missing but needed";
            OAuthSecureToken oAuthSecureToken5 = oAuthSecureToken4;
            String string5 = string3;
            String $i$a$-requireNotNull-OAuthSecureToken$52 = string4;
            throw new IllegalArgumentException($i$a$-requireNotNull-OAuthSecureToken$52.toString());
        }
        String string6 = oAuth2Token.getScope();
        String string7 = oAuth2Token.getTokenType();
        if (string7 == null) {
            String string8 = string6;
            String string9 = string2;
            String string10 = string;
            OAuthSecureToken oAuthSecureToken6 = oAuthSecureToken;
            boolean bl = false;
            String string11 = "tokenType is missing but required by https://www.rfc-editor.org/rfc/rfc6749.html#section-5.1";
            OAuthSecureToken oAuthSecureToken7 = oAuthSecureToken6;
            String string12 = string10;
            String string13 = string9;
            String string14 = string8;
            String string15 = string11;
            throw new IllegalArgumentException(string15.toString());
        }
        oAuthSecureToken(string, string2, string6, string7, oAuth2Token.getExpiresAt());
    }

    @Override
    @NotNull
    public String getAuthorizationHeader() {
        return ((CharSequence)this.getTokenType()).length() == 0 ? this.getAccessToken() : this.getTokenType() + " " + this.getAccessToken();
    }

    @Override
    @Nullable
    public String getIdToken() {
        return this.idToken;
    }

    @NotNull
    public final OAuthSecureToken updateFrom(@NotNull OAuth2Token token2) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        String string4 = token2.getAccessToken();
        if (string4 == null) {
            string4 = this.getAccessToken();
        }
        if ((string3 = token2.getRefreshToken()) == null) {
            string3 = this.getRefreshToken();
        }
        if ((string2 = token2.getScope()) == null) {
            string2 = this.scope;
        }
        if ((string = token2.getTokenType()) == null) {
            string = this.getTokenType();
        }
        return this.copy(string4, string3, string2, string, token2.getExpiresAt());
    }

    @NotNull
    public final OAuthSecureToken copy(@NotNull String accessToken2, @NotNull String refreshToken, @Nullable String scope2, @NotNull String tokenType, @Nullable Instant expiresAt) {
        Intrinsics.checkNotNullParameter((Object)accessToken2, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return new OAuthSecureToken(accessToken2, refreshToken, scope2, tokenType, expiresAt);
    }

    @NotNull
    public String toString() {
        return "OAuthSecureToken(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", expiresAt=" + this.expiresAt + ")";
    }

    public int hashCode() {
        int result2 = this.accessToken.hashCode();
        result2 = result2 * 31 + this.refreshToken.hashCode();
        result2 = result2 * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result2 = result2 * 31 + this.tokenType.hashCode();
        result2 = result2 * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuthSecureToken)) {
            return false;
        }
        OAuthSecureToken oAuthSecureToken = (OAuthSecureToken)other;
        if (!Intrinsics.areEqual((Object)this.accessToken, (Object)oAuthSecureToken.accessToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)oAuthSecureToken.refreshToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scope, (Object)oAuthSecureToken.scope)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenType, (Object)oAuthSecureToken.tokenType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expiresAt, (Object)oAuthSecureToken.expiresAt);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$accounts_api(OAuthSecureToken self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        SecureAccountToken.write$Self(self, output2, serialDesc);
        output2.encodeStringElement(serialDesc, 0, self.getAccessToken());
        output2.encodeStringElement(serialDesc, 1, self.getRefreshToken());
        output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.scope);
        output2.encodeStringElement(serialDesc, 3, self.getTokenType());
        output2.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)InstantAsEpochSecondsSerializer.INSTANCE, (Object)self.getExpiresAt());
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.getIdToken() != null) {
            output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getIdToken());
        }
    }

    public /* synthetic */ OAuthSecureToken(int seen0, String accessToken2, String refreshToken, String scope2, String tokenType, Instant expiresAt, String idToken, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.accessToken = accessToken2;
        this.refreshToken = refreshToken;
        this.scope = scope2;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.idToken = (seen0 & 0x20) == 0 ? null : idToken;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<OAuthSecureToken> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

