/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildKt;
import com.jetbrains.toolbox.OS;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/jetbrains/toolbox/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n774#2:38\n865#2,2:39\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/jetbrains/toolbox/UtilKt\n*L\n32#1:38\n32#1:39,2\n*E\n"})
public final class UtilKt {
    public static final boolean valueMatches(@NotNull String value2, @NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        return ((CharSequence)filter2).length() == 0 || StringsKt.contains((CharSequence)value2, (CharSequence)filter2, (boolean)true);
    }

    @NotNull
    public static final String generateReportIssueUrl(@NotNull String targetOS, @Nullable String providerName) {
        Intrinsics.checkNotNullParameter((Object)targetOS, (String)"targetOS");
        String string = providerName;
        Object providerSuffix = string != null ? "&" + UtilKt.setProvider(string) : "";
        return "https://jb.gg/toolbox-app-support?" + UtilKt.setAffectedVersions() + "&" + UtilKt.setOS(targetOS) + (String)providerSuffix;
    }

    public static /* synthetic */ String generateReportIssueUrl$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = OS.INSTANCE.getKernelName();
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UtilKt.generateReportIssueUrl(string, string2);
    }

    @NotNull
    public static final String generateReportIssueUrl(@NotNull String summary, @NotNull String description2, @NotNull String targetOS) {
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetOS, (String)"targetOS");
        return "https://youtrack.jetbrains.com/newIssue?project=TBX&type=Bug&" + UtilKt.setAffectedVersions() + "&" + UtilKt.setOS(targetOS) + "&summary=" + UtilKt.encodeParameter(summary) + "&description=" + UtilKt.encodeParameter(description2);
    }

    public static /* synthetic */ String generateReportIssueUrl$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = OS.INSTANCE.getKernelName();
        }
        return UtilKt.generateReportIssueUrl(string, string2, string3);
    }

    private static final String setAffectedVersions() {
        return "c=Affected%20versions%20" + BuildKt.getVersionNumber(Build.INSTANCE);
    }

    private static final String setProvider(String providerName) {
        return "c=Provider%20" + URLEncoder.encode(providerName, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private static final String setOS(String targetOS) {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new String[]{"Linux", "macOS", "Windows"};
        List oses = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$filter$iv = oses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)targetOS))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String removeOsesArg = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"%20", null, null, (int)0, null, UtilKt::setOS$lambda$1, (int)30, null);
        return "c=" + removeOsesArg + "%20add%20OS%20" + targetOS;
    }

    private static final String encodeParameter(String it) {
        return URLEncoder.encode(it, "UTF-8");
    }

    private static final CharSequence setOS$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "remove%20OS%20" + it;
    }
}

