/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.UIEvent;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.WindowManager;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class NotificationsWindows
implements Notifications {
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final WindowManager windowManager;

    public NotificationsWindows(@NotNull UIGlobalState uiGlobalState, @NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        this.uiGlobalState = uiGlobalState;
        this.windowManager = windowManager;
    }

    @Override
    @Nullable
    public Object showInfoMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Logger.INSTANCE.info("Show notification '" + message2 + "' (inApp=" + this.windowManager.isWindowFocused().getValue() + ")");
        if (((Boolean)this.windowManager.isWindowFocused().getValue()).booleanValue()) {
            Object object = this.uiGlobalState.processEvent(new UIEvent.InAppNotification(message2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.uiGlobalState.processEvent(new UIEvent.Notification(this.cutMessage(message2)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object showErrorMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.showInfoMessage(message2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String cutMessage(String message2) {
        Object object;
        if (message2.length() > 255) {
            String string = message2.substring(0, 252);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        } else {
            object = message2;
        }
        return object;
    }
}

